/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import com.huawei.support.icslite.download.dto.TaskDo;
import com.huawei.support.icslite.download.service.impl.DownloadServiceHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationDownloadHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationDownloadHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_ICSDOWNLOAD";
    private static final String QUERY_DATA_SQL = "select * from TB_ICSDOWNLOAD OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("TB_ICSDOWNLOAD", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationDownloadHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationDownloadHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        DownloadServiceHandler.getInstance().deleteAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, TaskDo.class);
        List resultList = res.getBeanList();
        if (!DownloadServiceHandler.getInstance().addMigrationTasks(resultList)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Download manage migration data exist failed.");
            return false;
        }
        return true;
    }
}

