/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.commonsearch.searchdb.dto.HdxIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.dto.OldDbHdxIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.HdxIndexServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.index.dto.mapper.HdxIndexDoConverter;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationHdxIndexHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationHdxIndexHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_HDXINDEX";
    private static final String QUERY_DATA_SQL = "select * from TB_HDXINDEX OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("TB_HDXINDEX", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationHdxIndexHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationHdxIndexHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        HdxIndexServiceHandler.getInstance().deleteAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, OldDbHdxIndexDo.class);
        List<HdxIndexDo> resultList = HdxIndexDoConverter.INSTANCE.domainOldIndexDos(res.getBeanList());
        if (!HdxIndexServiceHandler.getInstance().addBatchIndex(resultList)) {
            CodeCCUtils.INSTANCE.errorLog(log, "HdxIndex migration data exist failed.");
            return false;
        }
        return true;
    }
}

