/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.hdx.common.navi.dto.HdxNaviStatusDo;
import com.huawei.support.icscbb.hdx.common.navi.service.impl.NaviStatusServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationHdxNaviStatuHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationHdxNaviStatuHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM HDX_NAVI_STATU";
    private static final String QUERY_DATA_SQL = "select * from HDX_NAVI_STATU OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("HDX_NAVI_STATU", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationHdxNaviStatuHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationHdxNaviStatuHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        NaviStatusServiceHandler.getInstance().deleteAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, HdxNaviStatusDo.class);
        List resultList = res.getBeanList();
        if (!NaviStatusServiceHandler.getInstance().addBatch(resultList)) {
            CodeCCUtils.INSTANCE.errorLog(log, "HDXNaviStatu migration data exist failed.");
            return false;
        }
        return true;
    }
}

