/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.dto.OldDbIcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.ics.content.dto.mapper.IcsContentDtoConverter;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationIcsContentLastOldHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationIcsContentLastOldHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_ICSCONTENT_2021_09";
    private static final String QUERY_DATA_SQL = "select * from TB_ICSCONTENT_2021_09 OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("TB_ICSCONTENT_2021_09", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationIcsContentLastOldHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationIcsContentLastOldHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        IcsContentPoolServiceHandler.getInstance().delLastOldAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, OldDbIcsContentDo.class);
        List<IcsContentDo> resultList = IcsContentDtoConverter.INSTANCE.domainOldContentDos(res.getBeanList());
        if (!IcsContentPoolServiceHandler.getInstance().addLastOldBatch(resultList)) {
            CodeCCUtils.INSTANCE.errorLog(log, "LastOldIcsContent migration data exist failed.");
            return false;
        }
        return true;
    }
}

