/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.docnav.dto.OldDbIcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.docnav.service.impl.IcsDocnavPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.docnav.dto.mapper.IcsDocnavConverter;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationIcsDocNavHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationIcsDocNavHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_ICSDOCNAV";
    private static final String QUERY_DATA_SQL = "select * from TB_ICSDOCNAV OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("TB_ICSDOCNAV", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationIcsDocNavHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationIcsDocNavHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        IcsDocnavPoolServiceHandler.getInstance().delAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, OldDbIcsDocnavDo.class);
        List<IcsDocnavDo> resultList = IcsDocnavConverter.INSTANCE.domainOldDocnavDos(res.getBeanList());
        if (!IcsDocnavPoolServiceHandler.getInstance().add(resultList)) {
            CodeCCUtils.INSTANCE.errorLog(log, "IcsDocNav migration data exist failed.");
            return false;
        }
        return true;
    }
}

