/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.hwics.common.meta.dao.IcsMetaNameDaoHandler;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaNameDo;
import com.huawei.support.icscbb.hwics.common.meta.dto.OldDbIcsMetaNameDo;
import com.huawei.support.icscbb.hwics.common.meta.mapper.IcsMetaNameMapper;
import com.huawei.support.icscbb.hwics.common.meta.service.impl.IcsMetaNamePoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icslite.business.ics.meta.dto.mapper.IcsMetaNameConverter;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationIcsMetaNameHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationIcsMetaNameHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_ICSMETANAME";
    private static final String QUERY_DATA_SQL = "select * from TB_ICSMETANAME OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";
    private final IcsMetaNameMapper icsMetaNameMapper = (IcsMetaNameMapper)DbMapperUtils.getMapper(IcsMetaNameMapper.class);

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("TB_ICSMETANAME", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationIcsMetaNameHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationIcsMetaNameHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        IcsMetaNamePoolServiceHandler.getInstance().delAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, OldDbIcsMetaNameDo.class);
        List<IcsMetaNameDo> resultList = IcsMetaNameConverter.INSTANCE.domainOldMetaNameDos(res.getBeanList());
        if (!IcsMetaNameDaoHandler.getInstance().add(resultList, this.icsMetaNameMapper)) {
            CodeCCUtils.INSTANCE.errorLog(log, "IcsMetaName migration data exist failed.");
            return false;
        }
        return true;
    }
}

