/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.hwics.common.meta.dao.IcsMetaValueDaoHandler;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaValueDo;
import com.huawei.support.icscbb.hwics.common.meta.dto.OldDbIcsMetaValueDo;
import com.huawei.support.icscbb.hwics.common.meta.mapper.IcsMetaValueMapper;
import com.huawei.support.icscbb.hwics.common.meta.service.impl.IcsMetaValuePoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icslite.business.ics.meta.dto.mapper.IcsMetaValueConverter;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationIcsMetaValueHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationIcsMetaValueHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_ICSMETAVALUE";
    private static final String QUERY_DATA_SQL = "select * from TB_ICSMETAVALUE OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";
    private final IcsMetaValueMapper icsMetaValueMapper = (IcsMetaValueMapper)DbMapperUtils.getMapper(IcsMetaValueMapper.class);

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("TB_ICSMETAVALUE", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationIcsMetaValueHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationIcsMetaValueHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        IcsMetaValuePoolServiceHandler.getInstance().delAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, OldDbIcsMetaValueDo.class);
        List<IcsMetaValueDo> resultList = IcsMetaValueConverter.INSTANCE.domainOldMetaValueDos(res.getBeanList());
        if (!IcsMetaValueDaoHandler.getInstance().add(resultList, this.icsMetaValueMapper)) {
            CodeCCUtils.INSTANCE.errorLog(log, "IcsMetaValue migration data exist failed.");
            return false;
        }
        return true;
    }
}

