/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icspid.dto.OldDbIcsPidDo;
import com.huawei.support.icscbb.hwics.common.icspid.service.impl.IcsPidPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.pid.dto.mapper.IcsPidConverter;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class MigrationIcsPidHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationIcsPidHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_ICSPID";
    private static final String QUERY_DATA_SQL = "select * from TB_ICSPID WHERE ID > ? OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY";

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("TB_ICSPID", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationIcsPidHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationIcsPidHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        IcsPidPoolServiceHandler.getInstance().delAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, OldDbIcsPidDo.class);
        List<IcsPidDo> resultList = IcsPidConverter.INSTANCE.domainOldPidDos(res.getBeanList());
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.id = resultList.get(resultList.size() - 1).getId();
        }
        if (!IcsPidPoolServiceHandler.getInstance().add(resultList)) {
            CodeCCUtils.INSTANCE.errorLog(log, "IcsPid migration data exist failed.");
            return false;
        }
        return true;
    }
}

