/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.commonsearch.searchdb.dto.IcsIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.dto.OldDbIcsIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.IcsIndexServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.index.task.IcsIndexDoConverter;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationIndexHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationIndexHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_INDEX";
    private static final String QUERY_DATA_SQL = "select * from TB_INDEX OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("TB_INDEX", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationIndexHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationIndexHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        IcsIndexServiceHandler.getInstance().deleteAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, OldDbIcsIndexDo.class);
        List<IcsIndexDo> resultList = IcsIndexDoConverter.INSTANCE.domainOldIndexDos(res.getBeanList());
        if (!IcsIndexServiceHandler.getInstance().addBatchIndex(resultList)) {
            CodeCCUtils.INSTANCE.errorLog(log, "IcsIndex migration data exist failed.");
            return false;
        }
        return true;
    }
}

