/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import com.huawei.support.icslite.offlinedownload.dto.OfflineDownloadUrlDo;
import com.huawei.support.icslite.offlinedownload.service.impl.OfflineDownloadServiceHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationOfflineDownloadHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationOfflineDownloadHandler.class);
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_OFFLINEDOWNLOAD";
    private static final String QUERY_DATA_SQL = "select * from TB_OFFLINEDOWNLOAD WHERE ID > ? OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY";

    @Override
    protected void readOldData() {
        try {
            this.oldDataSize = this.readOldDataSize("TB_OFFLINEDOWNLOAD", this.connection.prepareStatement(QUERY_DATA_SIZE_SQL));
            this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationOfflineDownloadHandler readOldData error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationOfflineDownloadHandler readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        OfflineDownloadServiceHandler.getInstance().deleteAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, OfflineDownloadUrlDo.class);
        List resultList = res.getBeanList();
        if (OfflineDownloadServiceHandler.getInstance().addDownloadTasks(resultList) <= 0) {
            CodeCCUtils.INSTANCE.errorLog(log, "OfflineDownload manage migration data exist failed.");
            return false;
        }
        return true;
    }
}

