/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.ics.common.adapter.encryption.service.factory.DataSecurityHandlerFactory;
import com.huawei.support.ics.common.adapter.encryption.service.util.EncryptionUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.common.serviceimpl.ProxyServiceHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.KmcMigrationService;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class MigrationProxyHandler
extends KmcMigrationService<String> {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationProxyHandler.class);
    private static final int ENCRYPTION_DOMAIN_KEY_ID = 3;

    @Override
    protected void readOldData() {
        ProxyServiceHandler proxy = ProxyServiceHandler.getInstance();
        String passWord = proxy.preGetProxyProperty().getProperty(proxy.getIdentityKey());
        if (StringUtils.isNotBlank((CharSequence)passWord)) {
            this.oldData = this.decryKmcPassword(passWord);
            return;
        }
        this.oldData = passWord;
    }

    @Override
    protected boolean migrationOldData() {
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.oldData))) {
            return true;
        }
        String oldDataStr = (String)this.oldData;
        byte[] encryptData = DataSecurityHandlerFactory.getInstance((String)"DPAPI").encrypt(3, oldDataStr);
        boolean isUpdate = ProxyServiceHandler.getInstance().updatePassWordProperties(Base64.encodeBase64String((byte[])encryptData));
        try {
            EncryptionUtils.clearString((String)((String)this.oldData));
        }
        catch (PrivilegedActionException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "migrationOldData.EncryptionUtils.clearString Fail", (Throwable)e);
        }
        if (!isUpdate) {
            CodeCCUtils.INSTANCE.errorLog(log, "Migration updatePassWordProperties Fail");
        }
        return isUpdate && this.checkMigrationData(oldDataStr.length());
    }

    @Override
    protected void doMigration() {
        this.readOldData();
        this.migrationOldData();
    }

    private boolean checkMigrationData(int oldDataLength) {
        boolean isCheckRight;
        String password = ProxyServiceHandler.getInstance().getProxyProperty(true).getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            return false;
        }
        boolean bl = isCheckRight = oldDataLength == password.length();
        if (isCheckRight) {
            CodeCCUtils.INSTANCE.infoLog(log, "Migration ProxyEncryptData Success");
        } else {
            CodeCCUtils.INSTANCE.errorLog(log, "Migration ProxyEncryptData Fail");
        }
        return isCheckRight;
    }

    private String decryKmcPassword(String enPwd) {
        byte[] encrypt = enPwd.getBytes(StandardCharsets.UTF_8);
        return DataSecurityHandlerFactory.getInstance((String)"KMC").decrpy(3, encrypt);
    }
}

