/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.schedule.impl;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.schedule.ScheduleHandler;
import com.huawei.support.icslite.business.schedule.util.ScheduleUtils;
import com.huawei.support.icslite.business.upgrade.service.UpgradeBusiness;
import com.huawei.support.icslite.business.upgrade.task.UpgradeTask;
import com.huawei.support.icslite.business.upgrade.tip.UpgradeTip;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class UpgradeInfoSchedule
extends ScheduleHandler {
    private static final ThreadPoolExecutor COMMON_THREAD_POOL = ThreadPoolFactory.getThreadPool((String)"common", (int)2, (int)300, (int)10, (int)100);

    public UpgradeInfoSchedule(long initialDelay, long period, TimeUnit timeUnit) {
        super(initialDelay, period, timeUnit);
    }

    @Override
    public Runnable realRunnable() {
        return () -> {
            UpgradeBusiness upgradeBusiness = (UpgradeBusiness)SpringContextUtil.getBean((String)"upgradeBusiness");
            upgradeBusiness.upgradeInfoSchedule();
            this.updateLowVersionFlag(upgradeBusiness);
            this.initUpgradeTip(upgradeBusiness);
            ScheduleUtils.startUpgradeCheck(UpgradeTask.getInstance().getUpgradeInfoRunnable());
            this.collectUserClientInfo(upgradeBusiness);
        };
    }

    private void collectUserClientInfo(UpgradeBusiness upgradeBusiness) {
        COMMON_THREAD_POOL.execute(() -> upgradeBusiness.collectUserClientInfo());
    }

    private void updateLowVersionFlag(UpgradeBusiness upgradeBusiness) {
        String lowVersionMsg = upgradeBusiness.getLowVersionMsg();
        if (StringUtils.equals((CharSequence)lowVersionMsg, (CharSequence)"true")) {
            upgradeBusiness.resetLowVersionMsg();
            upgradeBusiness.updateLowVersionConfig(lowVersionMsg);
            return;
        }
        upgradeBusiness.updateLowVersionConfig("false");
    }

    private void initUpgradeTip(UpgradeBusiness upgradeBusiness) {
        String upgradeMsg = upgradeBusiness.getUpgradeMsg();
        if (StringUtils.isNotBlank((CharSequence)upgradeMsg)) {
            upgradeBusiness.resetUpgradeMsg();
            UpgradeTip.getInstance().init(upgradeMsg);
        }
    }
}

