/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.schedule.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.schedule.ScheduleHandler;
import com.huawei.support.icslite.business.schedule.impl.CrlUpdateSchedule;
import com.huawei.support.icslite.business.schedule.impl.EarlierExistSchedule;
import com.huawei.support.icslite.business.schedule.impl.FavoritesUpdateSchedule;
import com.huawei.support.icslite.business.schedule.impl.HdxCleanDirtyIndexSchedule;
import com.huawei.support.icslite.business.schedule.impl.IcsCleanDirtyIndexSchedule;
import com.huawei.support.icslite.business.schedule.impl.IndexSchedule;
import com.huawei.support.icslite.business.schedule.impl.UpdateUrlDataSchedule;
import com.huawei.support.icslite.business.schedule.impl.UpgradeDocsCacheSchedule;
import com.huawei.support.icslite.business.schedule.impl.UpgradeInfoSchedule;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ScheduleUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(ScheduleUtils.class);
    private static final ScheduledThreadPoolExecutor SCHEDULE_THREAD_POOL_EXECUTOR = ThreadPoolFactory.getScheduleThreadPoolExecutor();
    private static final Map<String, ScheduleHandler> SCHEDULE_MAP = new ConcurrentHashMap<String, ScheduleHandler>();
    private static volatile ScheduledFuture<?> scheduledFuture = null;
    private static volatile ScheduledFuture<?> restartScheduledFuture = null;
    private static long dayFixedRate = 0L;

    private ScheduleUtils() {
    }

    public static void init() {
        ScheduleUtils.initMap();
        CodeCCUtils.INSTANCE.infoLog(LOG, "init schedule task!");
        SCHEDULE_MAP.forEach((name, scheduleHandler) -> ScheduleUtils.startSchedule(scheduleHandler.handlerRunnable(), scheduleHandler.getInitialDelay(), scheduleHandler.getPeriod(), scheduleHandler.getUnit()));
    }

    private static void initMap() {
        Properties scheduleProperties = PropertiesUtils.getPropertiesByResourceName((String)"schedule-configure.properties");
        ScheduleUtils.initIndexMap(scheduleProperties);
        ScheduleUtils.initDayMap(scheduleProperties);
    }

    private static void initDayMap(Properties scheduleProperties) {
        try {
            long initialDelay = ScheduleUtils.getProperties2Long(scheduleProperties, "dayInitialDelay");
            dayFixedRate = ScheduleUtils.getProperties2Long(scheduleProperties, "dayFixedRate");
            SCHEDULE_MAP.put("ICSCLEANDIRTYINDEXSCHEDULE", new IcsCleanDirtyIndexSchedule(initialDelay, dayFixedRate, TimeUnit.MILLISECONDS));
            SCHEDULE_MAP.put("HDXCLEANDIRTYINDEXSCHEDULE", new HdxCleanDirtyIndexSchedule(initialDelay, dayFixedRate, TimeUnit.MILLISECONDS));
            SCHEDULE_MAP.put("CRLUPDATESCHEDULE", new CrlUpdateSchedule(initialDelay, dayFixedRate, TimeUnit.MILLISECONDS));
            SCHEDULE_MAP.put("UPDATEURLDATASCHEDULE", new UpdateUrlDataSchedule(initialDelay, dayFixedRate, TimeUnit.MILLISECONDS));
            SCHEDULE_MAP.put("UPGRADEDOCSCACHESCHEDULE", new UpgradeDocsCacheSchedule(initialDelay, dayFixedRate, TimeUnit.MILLISECONDS));
            SCHEDULE_MAP.put("EARLIEREXISTSCHEDULE", new EarlierExistSchedule(initialDelay, dayFixedRate, TimeUnit.MILLISECONDS));
            SCHEDULE_MAP.put("FAVORITEUPDATESCHEDULE", new FavoritesUpdateSchedule(initialDelay, dayFixedRate, TimeUnit.MILLISECONDS));
            UpgradeInfoSchedule upgradeInfoSchedule = new UpgradeInfoSchedule(0L, dayFixedRate, TimeUnit.MILLISECONDS);
            ScheduleUtils.startSchedule(upgradeInfoSchedule.handlerRunnable(), upgradeInfoSchedule.getInitialDelay(), upgradeInfoSchedule.getUnit());
        }
        catch (NumberFormatException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "initDayMap get properties can not parse to long!", (Throwable)e);
        }
    }

    public static void startUpgradeCheck(Runnable upgradeInfoRunnable) {
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        scheduledFuture = ScheduleUtils.startSchedule(upgradeInfoRunnable, dayFixedRate, dayFixedRate, TimeUnit.MILLISECONDS);
    }

    public static long getProperties2Long(Properties properties, String key) throws NumberFormatException {
        String property = properties.getProperty(key);
        return Long.parseLong(property);
    }

    private static void initIndexMap(Properties scheduleProperties) {
        try {
            long initialDelay = ScheduleUtils.getProperties2Long(scheduleProperties, "indexInitialDelay");
            long fixRate = ScheduleUtils.getProperties2Long(scheduleProperties, "indexFixedRate");
            SCHEDULE_MAP.put("ICSINDEXSCHEDULE", new IndexSchedule(initialDelay, fixRate, TimeUnit.MILLISECONDS));
        }
        catch (NumberFormatException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "initIndexMap get properties can not parse to long!", (Throwable)e);
        }
    }

    private static ScheduledFuture<?> startSchedule(Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        return SCHEDULE_THREAD_POOL_EXECUTOR.scheduleAtFixedRate(runnable, initialDelay, period, unit);
    }

    private static void startSchedule(Runnable runnable, long initialDelay, TimeUnit unit) {
        SCHEDULE_THREAD_POOL_EXECUTOR.schedule(runnable, initialDelay, unit);
    }

    public static void startSchedule(String name, Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        String keyName = name.toUpperCase(Locale.ENGLISH);
        if (SCHEDULE_MAP.containsKey(keyName)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "name {0} cannot start schedule,because it already exists ", new Object[]{name});
            return;
        }
        ScheduleUtils.startSchedule(runnable, initialDelay, period, unit);
    }

    public static synchronized void startUpgradeRestartSchedule(Runnable upgradeRestartRunnable) {
        ScheduleUtils.cancelRestartRemindSchedule();
        restartScheduledFuture = ScheduleUtils.startSchedule(upgradeRestartRunnable, 0L, dayFixedRate, TimeUnit.MILLISECONDS);
    }

    public static boolean cancelRestartRemindSchedule() {
        if (restartScheduledFuture == null) {
            return true;
        }
        boolean isCancel = restartScheduledFuture.cancel(true);
        if (!isCancel) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "cancel restartRemindSchedule fail");
        }
        return isCancel;
    }
}

