/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.dao;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchDocDto;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchField;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchResult;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.query.QueryCondition;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.HighlightUtils;
import com.huawei.support.icscbb.commonsearch.search.component.SearchProcessor;
import com.huawei.support.icscbb.commonsearch.search.entity.LibSearchParam;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.GlobalIndexServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.search.dao.IcsSearchBusinessDaoHandler;
import com.huawei.support.icslite.business.search.dao.SearchFilterDaoHandler;
import com.huawei.support.icslite.business.search.dto.IcsSearchTopicDto;
import com.huawei.support.icslite.business.search.dto.PageInfoDto;
import com.huawei.support.icslite.business.search.dto.SearchQuery;
import com.huawei.support.icslite.business.search.dto.SearchResultDto;
import com.huawei.support.icslite.business.search.dto.SearchTopicDto;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.ParseException;

public class GlobalSearchBusinessDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(GlobalSearchBusinessDaoHandler.class);
    private static final int DIVIDE_SCALE = 4;
    private static final int PERCENT_100 = 100;
    private static final double PROGRESS_DEFAULT_MIN = 0.01;
    private static final int DEFAULT_PAGE_SIZE = 15;
    private static final String TOPIC_PATH_LIB_INFO = "[%s %s]: ";
    private final IcsLiteStorageAdapter icsLiteStorageAdapter = IcsLiteStorageInstance.getInstance();

    private GlobalSearchBusinessDaoHandler() {
    }

    public static GlobalSearchBusinessDaoHandler getInstance() {
        return GlobalSearchBusinessDaoHandlerHolder.INSTANCE;
    }

    public SearchResultDto<SearchTopicDto> getSearchResult(SearchQuery searchQuery) {
        LibSearchParam searchParam = this.getSearchParam(searchQuery);
        List<String> indexDirs = this.getIndexDirs(searchQuery.getDocRangeList());
        if (CollectionUtils.isEmpty(indexDirs)) {
            SearchResultDto<SearchTopicDto> searchResultDto = new SearchResultDto<SearchTopicDto>();
            this.setProgressToSearchResultDto(searchResultDto);
            return searchResultDto;
        }
        SearchResult searchResult = null;
        try {
            searchResult = SearchProcessor.search((ParamBase)searchParam, indexDirs, (String)"libtasktype");
        }
        catch (SearchException | ParseException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Global search error.", e);
        }
        SearchResultDto<SearchTopicDto> searchResults = this.convertToSearchResult(searchResult, searchParam.getLang(), searchParam.getPageIndex(), searchParam.getPageSize());
        this.setProgressToSearchResultDto(searchResults);
        return searchResults;
    }

    private List<String> getIndexDirs(List<String> docRangeList) {
        List indexDirs = GlobalIndexServiceHandler.getInstance().selectIndexDirs();
        if (CollectionUtils.isEmpty((Collection)indexDirs)) {
            return Collections.emptyList();
        }
        String indexRootDir = this.icsLiteStorageAdapter.getIndexPath();
        if (StringUtils.isBlank((CharSequence)indexRootDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "index root dir is null, from ics lite storage adapter");
            return indexDirs;
        }
        if (CollectionUtils.isEmpty(docRangeList)) {
            return indexDirs.stream().map(indexDir -> indexRootDir + indexDir).collect(Collectors.toList());
        }
        return indexDirs.stream().filter(indexDir -> {
            String[] items = indexDir.split("\\\\");
            if (items.length > 2) {
                return docRangeList.contains(items[2]);
            }
            return false;
        }).map(indexDir -> indexRootDir + indexDir).collect(Collectors.toList());
    }

    private void setProgressToSearchResultDto(SearchResultDto<SearchTopicDto> searchResultDto) {
        double indexProgress = this.getIndexProgress();
        String status = Double.compare(indexProgress, 100.0) == 0 ? "10000" : "10001";
        searchResultDto.setProgress(indexProgress);
        searchResultDto.setIndexTaskStatus(status);
    }

    private double getIndexProgress() {
        int numOfFinished = GlobalIndexServiceHandler.getInstance().selectNumOfFinished();
        int total = GlobalIndexServiceHandler.getInstance().selectTotal();
        if (total == 0) {
            return 100.0;
        }
        double percent = new BigDecimal(numOfFinished).divide(new BigDecimal(total), 4, RoundingMode.UP).multiply(new BigDecimal(100)).doubleValue();
        return Double.compare(percent, 0.0) == 0 ? 0.01 : percent;
    }

    private LibSearchParam getSearchParam(SearchQuery searchQuery) {
        LibSearchParam libSearchParam = new LibSearchParam();
        libSearchParam.setPoolSize(16000);
        libSearchParam.setExpireTime(5);
        libSearchParam.setLang(ConfigServiceHandler.getInstance().get("system.lang"));
        libSearchParam.setSearchText(searchQuery.getKeyword());
        libSearchParam.setPageIndex(searchQuery.getPageindex());
        libSearchParam.setPageSize(searchQuery.getPagesize());
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        fields.add(new SearchField("tp_keywords", 1.0f, false));
        fields.add(new SearchField("t_title", 10.0f, true));
        fields.add(new SearchField("t_content", 1.0f, true));
        libSearchParam.setSearchFields(fields);
        List<QueryCondition> queryMetas = SearchFilterDaoHandler.INSTANCE.getQueryMetas(searchQuery.getFilter(), "", true);
        queryMetas.forEach(queryCondition -> libSearchParam.addExtraConditions(queryCondition));
        return libSearchParam;
    }

    private SearchResultDto<SearchTopicDto> initSearchResult(int total, int pageIndex, int pageSize) {
        PageInfoDto hdxPageInfo = new PageInfoDto(total, this.countTotalPage(total, pageSize), pageIndex, pageSize);
        return new SearchResultDto<SearchTopicDto>(hdxPageInfo);
    }

    private int countTotalPage(int total, int pageSize) {
        int temp = pageSize;
        if (temp == 0) {
            temp = 15;
        }
        int totalPage = total / temp;
        return total % temp == 0 ? totalPage : totalPage + 1;
    }

    private SearchResultDto<SearchTopicDto> convertToSearchResult(SearchResult topicSearchResult, String lang, int pageIndex, int pageSize) {
        if (topicSearchResult == null) {
            SearchResultDto<SearchTopicDto> searchResultDto = new SearchResultDto<SearchTopicDto>();
            this.setProgressToSearchResultDto(searchResultDto);
            return searchResultDto;
        }
        List searchDocs = topicSearchResult.getResultSet();
        SearchResultDto<SearchTopicDto> searchResults = this.initSearchResult(topicSearchResult.getTotal(), pageIndex, pageSize);
        for (SearchDocDto searchDoc : searchDocs) {
            SearchTopicDto searchTopicDto;
            String icsDocId = searchDoc.getField("s_docid");
            if (StringUtils.isBlank((CharSequence)icsDocId)) {
                searchTopicDto = this.getHdxSearchTopicDto(searchDoc, lang);
            } else {
                SearchDocDto resultDocDto = IcsSearchBusinessDaoHandler.INSTANCE.getIcsDocDtoAfterCheck(searchDoc);
                String topicPathPrefix = String.format(Locale.ROOT, TOPIC_PATH_LIB_INFO, resultDocDto.getField("s_libname"), resultDocDto.getField("s_version"));
                Optional<IcsSearchTopicDto> icsSearchTopicDto = IcsSearchBusinessDaoHandler.INSTANCE.getSearchTopicDto(resultDocDto, lang, topicPathPrefix);
                if (!icsSearchTopicDto.isPresent()) continue;
                searchTopicDto = icsSearchTopicDto.get();
            }
            searchResults.addResult(searchTopicDto);
        }
        return searchResults;
    }

    private SearchTopicDto getHdxSearchTopicDto(SearchDocDto searchDocDto, String lang) {
        SearchTopicDto searchTopicDto = new SearchTopicDto();
        searchTopicDto.setDocId(searchDocDto.getField("docId")).setContents(HighlightUtils.encodeHighLightPieces((String)searchDocDto.getField("t_content"), (String)lang)).setTitle(HighlightUtils.encodeHighLightPieces((String)searchDocDto.getField("t_title"), (String)lang)).setTopicId(searchDocDto.getField("topicid")).setTopicPath(HWEncoder.encodeForHTML((String)searchDocDto.getField("navipath"))).setTopicUrl(searchDocDto.getField("topicurl")).setKeywords(searchDocDto.getKeywords()).setScore(String.valueOf(searchDocDto.getScore())).setResType("hdx").setLibName(HWEncoder.encodeForHTML((String)searchDocDto.getField("libName"))).setLibProductVersion(searchDocDto.getField("productV"));
        return searchTopicDto;
    }

    private static class GlobalSearchBusinessDaoHandlerHolder {
        private static final GlobalSearchBusinessDaoHandler INSTANCE = new GlobalSearchBusinessDaoHandler();

        private GlobalSearchBusinessDaoHandlerHolder() {
        }
    }
}

