/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.dao;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchField;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.query.QueryCondition;
import com.huawei.support.icscbb.commonsearch.search.component.SearchProcessor;
import com.huawei.support.icscbb.commonsearch.search.entity.HdxSearchResult;
import com.huawei.support.icscbb.commonsearch.search.entity.LibSearchParam;
import com.huawei.support.icscbb.commonsearch.searchdb.dto.HdxIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.HdxIndexServiceHandler;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviContentDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.docexport.util.HdxNaviUtils;
import com.huawei.support.icslite.business.index.task.manager.IndexTaskManager;
import com.huawei.support.icslite.business.search.convert.HdxSearchResultConverter;
import com.huawei.support.icslite.business.search.dao.SearchFilterDaoHandler;
import com.huawei.support.icslite.business.search.dto.HdxSearchQuery;
import com.huawei.support.icslite.business.search.dto.HdxSearchTopicDto;
import com.huawei.support.icslite.business.search.dto.SearchResultDto;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.ParseException;

public enum HdxSearchBusinessDaoHandler {
    INSTANCE;

    private static final CommonLogger LOG;
    private static final String SEARCH_TYPE_NAVI = "search-type-navi";
    private final IcsLiteStorageAdapter icsLiteStorageAdapter = IcsLiteStorageInstance.getInstance();

    public SearchResultDto<HdxSearchTopicDto> getResult(HdxSearchQuery hdxSearchQueryDto, List<String> extDocIds) {
        HdxIndexDo hdxSearchDo = HdxIndexServiceHandler.getInstance().selectIndex(hdxSearchQueryDto.getDocid());
        if (hdxSearchDo == null) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "index is not exist. docid:" + hdxSearchQueryDto.getDocid());
            return new SearchResultDto<HdxSearchTopicDto>(null, "10000", IndexTaskManager.getInstance().getQueueLocation(hdxSearchQueryDto.getDocid()), 0.0);
        }
        if (StringUtils.equals((CharSequence)"10003", (CharSequence)hdxSearchDo.getState())) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "index is waiting to create. docid:" + hdxSearchQueryDto.getDocid());
            return new SearchResultDto<HdxSearchTopicDto>(null, hdxSearchDo.getState(), IndexTaskManager.getInstance().getQueueLocation(hdxSearchQueryDto.getDocid()), 0.0);
        }
        if (this.validParam(hdxSearchQueryDto)) {
            return this.getSearchResultDto(null, hdxSearchDo);
        }
        LibSearchParam searchParam = this.getSearchParam(hdxSearchQueryDto, this.getNaviSearchConditions(hdxSearchQueryDto.getDocid(), hdxSearchQueryDto.getNaviids()));
        List<String> indexDirs = this.getIndexDirs(hdxSearchDo, extDocIds);
        if (CollectionUtils.isEmpty(indexDirs)) {
            return this.getSearchResultDto(null, hdxSearchDo);
        }
        HdxSearchResult searchResults = null;
        try {
            searchResults = SearchProcessor.searchHdxDoc((ParamBase)searchParam, indexDirs, (String)"libtasktype");
            if (searchResults == null || CollectionUtils.isEmpty((Collection)searchResults.getResultSet())) {
                searchParam.setLang(hdxSearchDo.getLang());
                searchResults = SearchProcessor.searchHdxDoc((ParamBase)searchParam, indexDirs, (String)"libtasktype");
            }
        }
        catch (SearchException | ParseException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "HdxSearch error.", e);
        }
        SearchResultDto<HdxSearchTopicDto> searchResultDto = HdxSearchResultConverter.INSTANCE.domain2dto(searchResults);
        return this.getSearchResultDto(searchResultDto, hdxSearchDo);
    }

    private SearchResultDto<HdxSearchTopicDto> getSearchResultDto(SearchResultDto<HdxSearchTopicDto> searchResults, HdxIndexDo hdxIndexDo) {
        double rate = Double.parseDouble((String)StringUtils.defaultIfBlank((CharSequence)hdxIndexDo.getRate(), (CharSequence)"100"));
        if (searchResults == null) {
            return new SearchResultDto<HdxSearchTopicDto>(null, hdxIndexDo.getState(), IndexTaskManager.getInstance().getQueueLocation(hdxIndexDo.getDocId()), rate);
        }
        searchResults.setProgress(rate);
        searchResults.setIndexTaskStatus(hdxIndexDo.getState());
        if (StringUtils.equals((CharSequence)hdxIndexDo.getState(), (CharSequence)"10004")) {
            searchResults.setQueueLocation(IndexTaskManager.getInstance().getQueueLocation(hdxIndexDo.getDocId()) + 1);
        }
        return searchResults;
    }

    public int getResultCount(HdxSearchQuery hdxSearchQueryDto, List<String> extDocIds, Map<String, List<String>> conditionMap) throws SearchException {
        if (this.validParam(hdxSearchQueryDto)) {
            return 0;
        }
        String docId = hdxSearchQueryDto.getDocid();
        HdxIndexDo hdxSearchDo = HdxIndexServiceHandler.getInstance().selectIndex(docId);
        if (hdxSearchDo == null) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Index is not exist. docId:{0}", new Object[]{docId});
            return 0;
        }
        if (StringUtils.equals((CharSequence)"10003", (CharSequence)hdxSearchDo.getState())) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Index is waiting to create. docId:{0}", new Object[]{docId});
            return 0;
        }
        LibSearchParam searchParam = this.getSearchParam(hdxSearchQueryDto, conditionMap);
        List<String> indexDirs = this.getIndexDirs(hdxSearchDo, extDocIds);
        return SearchProcessor.getResultCount((ParamBase)searchParam, indexDirs, (String)"libtasktype");
    }

    private boolean validParam(HdxSearchQuery hdxSearchQueryDto) {
        if (hdxSearchQueryDto == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The hdxSearchQueryDto is null.");
            return true;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{hdxSearchQueryDto.getKeyword(), hdxSearchQueryDto.getDocid()})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The queryString or docId is null.");
            return true;
        }
        return false;
    }

    private LibSearchParam getSearchParam(HdxSearchQuery hdxSearchQueryDto, Map<String, List<String>> naviSearchConditions) {
        LibSearchParam searchParam = new LibSearchParam();
        searchParam.setPoolSize(16000);
        searchParam.setExpireTime(5);
        List<QueryCondition> queryMetas = SearchFilterDaoHandler.INSTANCE.getQueryMetas(hdxSearchQueryDto.getFilter(), "", true);
        queryMetas.forEach(queryCondition -> searchParam.addExtraConditions(queryCondition));
        if (MapUtils.isNotEmpty(naviSearchConditions)) {
            searchParam.setType(SEARCH_TYPE_NAVI);
            searchParam.addExtraConditions(naviSearchConditions);
        }
        searchParam.setLang(ConfigServiceHandler.getInstance().get("system.lang"));
        searchParam.setPageIndex(hdxSearchQueryDto.getPageindex());
        searchParam.setPageSize(hdxSearchQueryDto.getPagesize());
        searchParam.setFirstPageSize(hdxSearchQueryDto.getFirstpagesize());
        searchParam.setSearchText(hdxSearchQueryDto.getKeyword());
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        fields.add(new SearchField("t_title", 10.0f, true));
        fields.add(new SearchField("t_content", 1.0f, true));
        fields.add(new SearchField("tp_keywords", 1.0f, false));
        searchParam.setSearchFields(fields);
        return searchParam;
    }

    public Map<String, List<String>> getNaviSearchConditions(String docId, String naviIds) {
        List<NaviContentDo> naviByPosition = HdxNaviUtils.getNaviListByPositions(docId, naviIds);
        HashMap<String, List<String>> conditionMap = new HashMap<String, List<String>>();
        if (CollectionUtils.isEmpty(naviByPosition)) {
            return conditionMap;
        }
        conditionMap.put("topicidstring", naviByPosition.stream().map(NaviContentDo::getTopicId).collect(Collectors.toList()));
        return conditionMap;
    }

    private List<String> getIndexDirs(HdxIndexDo hdxSearchDo, List<String> extDocIds) {
        ArrayList<String> indexDirs = new ArrayList<String>();
        String indexRootDir = this.icsLiteStorageAdapter.getIndexPath();
        if (StringUtils.isBlank((CharSequence)indexRootDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Index root dir is null, from ics lite storage adapter");
            return indexDirs;
        }
        indexDirs.add(indexRootDir + hdxSearchDo.getIndexDir());
        if (CollectionUtils.isEmpty(extDocIds)) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "Not exist extend lib. docId:{0}", new Object[]{hdxSearchDo.getDocId()});
            return indexDirs;
        }
        List extendIndexDirs = HdxIndexServiceHandler.getInstance().selectIndexDirByDocId(extDocIds);
        if (CollectionUtils.isEmpty((Collection)extendIndexDirs)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Not get extend indexdirs. docId:{0}", new Object[]{hdxSearchDo.getDocId()});
            return indexDirs;
        }
        extendIndexDirs.forEach(extendIndexDir -> indexDirs.add(indexRootDir + extendIndexDir));
        return indexDirs;
    }

    public boolean deleteIndexReaderCache(String docId) {
        HdxIndexDo hdxIndexDo = HdxIndexServiceHandler.getInstance().selectIndex(docId);
        if (hdxIndexDo == null) {
            return false;
        }
        String indexRootDir = this.icsLiteStorageAdapter.getIndexPath();
        if (StringUtils.isBlank((CharSequence)indexRootDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Index root dir is null, from ics lite storage adapter");
            return false;
        }
        return SearchProcessor.deleteIndexReaderCache((String)(indexRootDir + hdxIndexDo.getIndexDir()), (String)"libtasktype");
    }

    static {
        LOG = CommonLoggerFactory.getLogger(HdxSearchBusinessDaoHandler.class);
    }
}

