/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.dao;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.index.entity.PidDo;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchDocDto;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchField;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchResult;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.query.QueryCondition;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.HighlightUtils;
import com.huawei.support.icscbb.commonsearch.search.component.SearchProcessor;
import com.huawei.support.icscbb.commonsearch.search.entity.LibSearchParam;
import com.huawei.support.icscbb.commonsearch.searchdb.dto.IcsIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.IcsIndexServiceHandler;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.index.task.manager.IndexTaskManager;
import com.huawei.support.icslite.business.search.dao.SearchFilterDaoHandler;
import com.huawei.support.icslite.business.search.dto.IcsSearchQuery;
import com.huawei.support.icslite.business.search.dto.IcsSearchTopicDto;
import com.huawei.support.icslite.business.search.dto.PageInfoDto;
import com.huawei.support.icslite.business.search.dto.SearchResultDto;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.wsf.core.HWEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.ParseException;

public enum IcsSearchBusinessDaoHandler {
    INSTANCE;

    private static final CommonLogger LOGGER;
    private static final int DEFAULT_PAGE_SIZE = 15;
    private static final String BROWSE_TOPIC_URL_FOUR_PARAM = "browse.topic.url.four.param.include.topicid";
    private static final String BROWSE_PORTAL_URL_TWO_PARAM = "browse.portal.url.two.param";
    private static final String SEARCH_FILTER_SHOW = "search.filter.show";
    private static final String INDEX_KEY_DOCNAVI_ID = "docnavid";
    private static final String TOPIC_NAVI_PATH_LI = "<li><a target='_blank' class='%s' rel='noopener noreferrer' href='/icslite/%s'>%s</a></li>";
    private static final int MAX_PID_NUM = 3;
    private static final String DOCNAV_ID_EXT = "-0";
    private final IcsLiteStorageAdapter icsLiteStorageAdapter = IcsLiteStorageInstance.getInstance();
    private final Map<String, BiFunction<SearchDocDto, String, IcsSearchTopicDto>> functionMap = new HashMap<String, BiFunction<SearchDocDto, String, IcsSearchTopicDto>>();

    private IcsSearchBusinessDaoHandler() {
        this.functionMap.put("pid", this::getSearchDtoOfPid);
        this.functionMap.put("docNav", this::getSearchDtoOfDocNav);
        this.functionMap.put("ics", this::getSearchDtoOfTopic);
    }

    public SearchResultDto<IcsSearchTopicDto> getSearchResult(IcsSearchQuery icsSearchQuery) {
        LibSearchParam searchParam;
        String docId = icsSearchQuery.getDocid();
        IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, docId);
        if (icsIndexDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "not find index record from db-table.");
            return new SearchResultDto<IcsSearchTopicDto>(null, "10000", IndexTaskManager.getInstance().getQueueLocation(docId), 0.0);
        }
        if (StringUtils.equals((CharSequence)"10003", (CharSequence)icsIndexDo.getState())) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "status of index is waiting, please wait to create.");
            return new SearchResultDto<IcsSearchTopicDto>(null, icsIndexDo.getState(), IndexTaskManager.getInstance().getQueueLocation(docId), 0.0);
        }
        if (!this.validParam(icsSearchQuery)) {
            return this.getSearchResultDto(null, icsIndexDo);
        }
        try {
            searchParam = this.getSearchParam(icsSearchQuery, ConfigServiceHandler.getInstance().get("system.lang"));
        }
        catch (SearchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Ics search getSearchParam error.", (Throwable)e);
            return this.getSearchResultDto(null, icsIndexDo);
        }
        List<String> indexDirs = this.getIndexDirs(docId);
        if (CollectionUtils.isEmpty(indexDirs)) {
            return this.getSearchResultDto(null, icsIndexDo);
        }
        SearchResult searchResult = null;
        try {
            searchResult = SearchProcessor.search((ParamBase)searchParam, indexDirs, (String)"libtasktype");
            if (searchResult == null || CollectionUtils.isEmpty((Collection)searchResult.getResultSet())) {
                searchParam = this.getSearchParam(icsSearchQuery, icsIndexDo.getLanguage());
                searchResult = SearchProcessor.search((ParamBase)searchParam, indexDirs, (String)"libtasktype");
            }
        }
        catch (SearchException | ParseException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Ics search error.", e);
        }
        SearchResultDto<IcsSearchTopicDto> searchResults = this.convertToSearchResult(searchResult, searchParam.getLang(), searchParam.getPageIndex(), searchParam.getPageSize());
        return this.getSearchResultDto(searchResults, icsIndexDo);
    }

    private SearchResultDto<IcsSearchTopicDto> getSearchResultDto(SearchResultDto<IcsSearchTopicDto> searchResults, IcsIndexDo icsIndexDo) {
        String rate = icsIndexDo.getProcessRate();
        rate = (String)StringUtils.defaultIfBlank((CharSequence)rate, (CharSequence)"100");
        if (searchResults == null) {
            return new SearchResultDto<IcsSearchTopicDto>(null, icsIndexDo.getState(), IndexTaskManager.getInstance().getQueueLocation(icsIndexDo.getDocId()), Double.parseDouble(rate));
        }
        searchResults.setProgress(Double.parseDouble(rate));
        searchResults.setIndexTaskStatus(icsIndexDo.getState());
        if (StringUtils.equals((CharSequence)icsIndexDo.getState(), (CharSequence)"10004")) {
            searchResults.setQueueLocation(IndexTaskManager.getInstance().getQueueLocation(icsIndexDo.getDocId()) + 1);
        }
        return searchResults;
    }

    private List<String> getIndexDirs(String docId) {
        ArrayList<String> indexDirs = new ArrayList<String>();
        List icsIndexDos = IcsIndexServiceHandler.getInstance().selectIndex(docId);
        if (CollectionUtils.isEmpty((Collection)icsIndexDos)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "not find index record from db-table.");
            return indexDirs;
        }
        String indexRootDir = this.icsLiteStorageAdapter.getIndexPath();
        if (StringUtils.isBlank((CharSequence)indexRootDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "index root dir is null, from ics lite storage adapter");
            return indexDirs;
        }
        icsIndexDos.forEach(searchDo -> indexDirs.add(indexRootDir + searchDo.getIndexDir()));
        return indexDirs;
    }

    private boolean validParam(IcsSearchQuery icsSearchQueryDto) {
        boolean isLegal = false;
        if (icsSearchQueryDto == null) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "The searchQuery is null.");
            return isLegal;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{icsSearchQueryDto.getDocid(), icsSearchQueryDto.getKeyword()})) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "The queryString is null.");
            return isLegal;
        }
        return true;
    }

    private LibSearchParam getSearchParam(IcsSearchQuery icsSearchQueryDto, String lang) throws SearchException {
        Map<String, List<String>> metaFilters;
        LibSearchParam hwicsSearchParam = new LibSearchParam();
        hwicsSearchParam.setPoolSize(16000);
        hwicsSearchParam.setExpireTime(5);
        hwicsSearchParam.setLang(lang);
        hwicsSearchParam.setPageIndex(icsSearchQueryDto.getPageindex());
        hwicsSearchParam.setPageSize(icsSearchQueryDto.getPagesize());
        hwicsSearchParam.setFirstPageSize(icsSearchQueryDto.getFirstpagesize());
        hwicsSearchParam.setSearchText(icsSearchQueryDto.getKeyword());
        List<QueryCondition> queryMetas = SearchFilterDaoHandler.INSTANCE.getQueryMetas(icsSearchQueryDto.getFilter(), "tt_", false);
        queryMetas.forEach(queryCondition -> hwicsSearchParam.addExtraConditions(queryCondition));
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        fields.add(new SearchField("t_title", 10.0f, true));
        fields.add(new SearchField("t_content", 1.0f, true));
        fields.add(new SearchField("tp_keywords", 1.0f, false));
        hwicsSearchParam.setSearchFields(fields);
        if (StringUtils.isNotBlank((CharSequence)icsSearchQueryDto.getPid())) {
            HashMap metas = new HashMap();
            ArrayList<String> pidIds = new ArrayList<String>();
            pidIds.add(icsSearchQueryDto.getPid());
            metas.put("p_id", pidIds);
            hwicsSearchParam.addExtraConditions(metas);
        }
        if (StringUtils.isNotBlank((CharSequence)icsSearchQueryDto.getMetafiters()) && MapUtils.isNotEmpty(metaFilters = this.convertMetaFiltersToMap(icsSearchQueryDto.getMetafiters()))) {
            hwicsSearchParam.addExtraConditions(metaFilters);
        }
        return hwicsSearchParam;
    }

    private Map<String, List<String>> convertMetaFiltersToMap(String metaFilters) throws SearchException {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        if (!this.isJson(metaFilters)) {
            throw new SearchException("metaFilters param is Illegal JSON format.");
        }
        Map metaFilterMap = JsonUtils.stringToMap((String)metaFilters);
        if (MapUtils.isEmpty((Map)metaFilterMap)) {
            return resultMap;
        }
        for (Map.Entry it : metaFilterMap.entrySet()) {
            List values = JsonUtils.castList(it.getValue(), String.class);
            if (!CollectionUtils.isNotEmpty((Collection)values)) continue;
            resultMap.put("tt_" + (String)it.getKey(), values);
        }
        return resultMap;
    }

    private boolean isJson(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return false;
        }
        String temp = content.trim();
        if (temp.startsWith("{") && temp.endsWith("}")) {
            return true;
        }
        return temp.startsWith("[") && temp.endsWith("]");
    }

    private SearchResultDto<IcsSearchTopicDto> initSearchResult(int total, int pageIndex, int pageSize) {
        PageInfoDto hdxPageInfo = new PageInfoDto(total, this.countTotalPage(total, pageSize), pageIndex, pageSize);
        return new SearchResultDto<IcsSearchTopicDto>(hdxPageInfo);
    }

    private int countTotalPage(int total, int pageSize) {
        int temp = pageSize;
        if (temp == 0) {
            temp = 15;
        }
        int totalPage = total / temp;
        return total % temp == 0 ? totalPage : totalPage + 1;
    }

    private SearchResultDto<IcsSearchTopicDto> convertToSearchResult(SearchResult topicSearchResult, String lang, int pageIndex, int pageSize) {
        if (topicSearchResult == null) {
            return new SearchResultDto<IcsSearchTopicDto>();
        }
        List<SearchDocDto> searchDocs = topicSearchResult.getResultSet();
        searchDocs = this.getIcsResultsAfterCheck(searchDocs);
        SearchResultDto<IcsSearchTopicDto> searchResults = this.initSearchResult(topicSearchResult.getTotal(), pageIndex, pageSize);
        for (SearchDocDto searchDoc : searchDocs) {
            Optional<IcsSearchTopicDto> icsSearchTopicDto = this.getSearchTopicDto(searchDoc, lang, searchDoc.getField("s_name") + ">");
            icsSearchTopicDto.ifPresent(searchResults::addResult);
        }
        return searchResults;
    }

    public SearchDocDto getIcsDocDtoAfterCheck(SearchDocDto searchDoc) {
        String issueDate;
        String lang;
        String projectId = searchDoc.getField("s_projectid");
        Optional<IcsContentDo> icsContentDoOpt = this.getIcsContentDoByMustParams(projectId, lang = searchDoc.getField("s_lang"), issueDate = searchDoc.getField("s_time"));
        if (!icsContentDoOpt.isPresent()) {
            return searchDoc;
        }
        IcsContentDo icsContentDo = icsContentDoOpt.get();
        String docId = searchDoc.getField("s_docid");
        if (!StringUtils.equals((CharSequence)docId, (CharSequence)icsContentDo.getDocId())) {
            searchDoc.addField("s_docid", new String[]{icsContentDo.getDocId()});
        }
        return searchDoc;
    }

    private Optional<IcsContentDo> getIcsContentDoByMustParams(String projectId, String lang, String issueDate) {
        IcsContentDo paramContentDo = new IcsContentDo();
        paramContentDo.setProjectid(projectId);
        paramContentDo.setLang(lang);
        paramContentDo.setIssueDate(issueDate);
        ArrayList<IcsContentDo> paramList = new ArrayList<IcsContentDo>();
        paramList.add(paramContentDo);
        List icsContentDoList = IcsContentPoolServiceHandler.getInstance().getIcsList(paramList);
        if (CollectionUtils.isEmpty((Collection)icsContentDoList)) {
            return Optional.empty();
        }
        if (icsContentDoList.size() != 1) {
            icsContentDoList.sort((contentDo1, contentDo2) -> Long.compare(contentDo2.getLastModified(), contentDo1.getLastModified()));
        }
        return Optional.of(icsContentDoList.get(0));
    }

    public List<SearchDocDto> getIcsResultsAfterCheck(List<SearchDocDto> searchDocs) {
        if (CollectionUtils.isEmpty(searchDocs)) {
            return searchDocs;
        }
        return searchDocs.stream().map(this::getIcsDocDtoAfterCheck).collect(Collectors.toList());
    }

    public Optional<IcsSearchTopicDto> getSearchTopicDto(SearchDocDto searchDoc, String lang, String topicPathPrefix) {
        String type = (String)StringUtils.defaultIfBlank((CharSequence)searchDoc.getField("type"), (CharSequence)"ics");
        BiFunction<SearchDocDto, String, IcsSearchTopicDto> function = this.functionMap.get(type);
        if (function == null) {
            return Optional.empty();
        }
        IcsSearchTopicDto searchResultDto = function.apply(searchDoc, topicPathPrefix);
        searchResultDto.setRefFlag(searchDoc.getField("refflag")).setProductName(HWEncoder.encodeForHTML((String)searchDoc.getField("s_name"))).setProductVersion(searchDoc.getField("s_version")).setTopicId(HWEncoder.encodeForHTML((String)searchDoc.getField("t_id"))).setTopicUrl(searchDoc.getField("t_url")).setTitle(HighlightUtils.encodeHighLightPieces((String)searchDoc.getField("t_title"), (String)lang)).setContents(HighlightUtils.encodeHighLightPieces((String)searchDoc.getField("t_content"), (String)lang)).setDocId(searchDoc.getField("s_docid")).setKeywords(searchDoc.getKeywords()).setScore(String.valueOf(searchDoc.getScore())).setResType(type).setLibProductVersion(searchDoc.getField("s_libv")).setLibName(HWEncoder.encodeForHTML((String)searchDoc.getField("s_libname")));
        return Optional.of(searchResultDto);
    }

    private IcsSearchTopicDto getSearchDtoOfPid(SearchDocDto searchDoc, String topicPathPrefix) {
        IcsSearchTopicDto searchResultDto = new IcsSearchTopicDto();
        searchResultDto.setRefDocId(searchDoc.getField("refflag")).setPluginId(searchDoc.getField("p_id")).setTopicPath(HWEncoder.encodeForHTML((String)(topicPathPrefix + searchDoc.getField("t_topicpath"))));
        return searchResultDto;
    }

    private IcsSearchTopicDto getSearchDtoOfDocNav(SearchDocDto searchDoc, String topicPathPrefix) {
        IcsSearchTopicDto searchResultDto = new IcsSearchTopicDto();
        searchResultDto.setTopicPath(this.getDocNavTopicPath(searchDoc, topicPathPrefix));
        searchResultDto.setDocNaviId(searchDoc.getField(INDEX_KEY_DOCNAVI_ID) + DOCNAV_ID_EXT);
        return searchResultDto;
    }

    private IcsSearchTopicDto getSearchDtoOfTopic(SearchDocDto searchDoc, String topicPathPrefix) {
        IcsSearchTopicDto searchResultDto = new IcsSearchTopicDto();
        searchResultDto.setPluginId(searchDoc.getField("p_id")).setPluginName(HWEncoder.encodeForHTML((String)searchDoc.getField("p_name"))).setRefDocId(searchDoc.getField("s_reldocid")).setPosition(searchDoc.getField("t_position")).setTopicPath(searchDoc.getField("t_topicpath"));
        return searchResultDto;
    }

    private String getDocNavTopicPath(SearchDocDto searchDocDto, String topicPathPrefix) {
        Object[] pidEntities = searchDocDto.getMultiField("pIdEntity");
        if (ArrayUtils.isEmpty((Object[])pidEntities)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Arrays.stream(pidEntities).limit(3L).forEach(pidEntity -> {
            PidDo pidDo = (PidDo)JsonUtils.stringToBean((String)pidEntity, PidDo.class);
            stringBuilder.append(this.getTopicPathLiHtml(pidDo, topicPathPrefix));
        });
        if (pidEntities.length > 3) {
            stringBuilder.append(this.getTopicPathLiMore(searchDocDto));
        }
        return stringBuilder.toString();
    }

    private String getTopicPathLiHtml(PidDo pidDo, String topicPathPrefix) {
        String pidPageUrl = I18nResources.INSTANCE.getValueByKey(BROWSE_TOPIC_URL_FOUR_PARAM);
        pidPageUrl = pidPageUrl.replace("{0}", pidDo.getDocId()).replace("{1}", pidDo.getRefDocId()).replace("{2}", pidDo.getId());
        String navPath = HWEncoder.encodeForHTML((String)(topicPathPrefix + pidDo.getNavPath()));
        return String.format(Locale.ROOT, TOPIC_NAVI_PATH_LI, "", pidPageUrl, navPath);
    }

    private String getTopicPathLiMore(SearchDocDto searchDocDto) {
        String docId = searchDocDto.getField("s_docid");
        String docNavId = searchDocDto.getField(INDEX_KEY_DOCNAVI_ID) + DOCNAV_ID_EXT;
        String portalUrl = I18nResources.INSTANCE.getValueByKey(BROWSE_PORTAL_URL_TWO_PARAM);
        portalUrl = portalUrl.replace("{0}", docId).replace("{1}", docNavId);
        String moreTitle = I18nResources.INSTANCE.getValueByKey(SEARCH_FILTER_SHOW);
        return String.format(Locale.ROOT, TOPIC_NAVI_PATH_LI, "more-pid", portalUrl, moreTitle);
    }

    public boolean deleteIndexReaderCache(String docId) {
        IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, docId);
        if (icsIndexDo == null) {
            return false;
        }
        String indexRootDir = this.icsLiteStorageAdapter.getIndexPath();
        if (StringUtils.isBlank((CharSequence)indexRootDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "index root dir is null, from ics lite storage adapter");
            return false;
        }
        return SearchProcessor.deleteIndexReaderCache((String)(indexRootDir + icsIndexDo.getIndexDir()), (String)"libtasktype");
    }

    public int getIcsResultCount(IcsSearchQuery icsSearchQuery) throws SearchException {
        List<String> indexDirs;
        if (!this.validParam(icsSearchQuery)) {
            return 0;
        }
        IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(icsSearchQuery.getDocid(), icsSearchQuery.getDocid());
        if (icsIndexDo == null) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "ics index is not exist. docid:{0}", new Object[]{icsSearchQuery.getDocid()});
            return 0;
        }
        if (StringUtils.equals((CharSequence)"10003", (CharSequence)icsIndexDo.getState())) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "ics index is waiting to create. docid:{0}", new Object[]{icsSearchQuery.getDocid()});
            return 0;
        }
        LibSearchParam searchParam = this.getSearchParam(icsSearchQuery, ConfigServiceHandler.getInstance().get("system.lang"));
        int resultCount = SearchProcessor.getResultCount((ParamBase)searchParam, indexDirs = this.getIndexDirs(icsSearchQuery.getDocid()), (String)"libtasktype");
        if (resultCount < 1) {
            searchParam = this.getSearchParam(icsSearchQuery, icsIndexDo.getLanguage());
            return SearchProcessor.getResultCount((ParamBase)searchParam, indexDirs, (String)"libtasktype");
        }
        return resultCount;
    }

    static {
        LOGGER = CommonLoggerFactory.getLogger(IcsSearchBusinessDaoHandler.class);
    }
}

