/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.dao;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.lucene.config.HdxMetaConfig;
import com.huawei.support.icscbb.commonsearch.lucene.search.query.QueryCondition;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.dom.XmlDom4jUtils;
import com.huawei.support.icslite.business.search.dto.SearchSortCommonDto;
import com.huawei.support.icslite.business.search.dto.SearchSortDto;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.wsf.core.HWEncoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.xml.sax.SAXException;

public enum SearchFilterDaoHandler {
    INSTANCE;

    private static final CommonLogger LOGGER;
    private static final String XML_NODE_ATTR_VALUE = "value";
    private final Map<String, String> xmlNodeAttrMap = new HashMap<String, String>();
    private final transient Map<String, BiFunction<Element, String, String>> biFunctionMap = new HashMap<String, BiFunction<Element, String, String>>();

    private SearchFilterDaoHandler() {
        this.xmlNodeAttrMap.put("hdxbigTypeFieldName", "field");
        this.xmlNodeAttrMap.put("icsbigTypeFieldName", "metanameid");
        this.xmlNodeAttrMap.put("hdxsmallTypeFieldName", "name");
        this.xmlNodeAttrMap.put("icssmallTypeFieldName", "valueid");
        this.xmlNodeAttrMap.put("hdxsmallTypeName", "zh");
        this.xmlNodeAttrMap.put("icssmallTypeName", XML_NODE_ATTR_VALUE);
        this.biFunctionMap.put("hdx", this::getHdxFilterHtmlPieces);
        this.biFunctionMap.put("ics", this::getIcsFilterHtmlPieces);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean generateFilterHtmlPieces(String docId, String docPath, String resPath, String resType) {
        try (InputStream inputStream = ZipFilePool.getInputStream((String)docPath, (String)resPath);){
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            org.dom4j.Document document = XmlDom4jUtils.getDocument((InputStream)inputStream);
            Element rootEle = document.getRootElement();
            BiFunction<Element, String, String> biFunction = this.biFunctionMap.get(resType);
            if (biFunction == null) {
                boolean bl = false;
                return bl;
            }
            String htmlPieces = biFunction.apply(rootEle, resType);
            if (StringUtils.isNotBlank((CharSequence)htmlPieces)) {
                IcsFileUtils.writeFileContent((String)this.getHtmlSavePath(docId, resType), (String)(this.getFilterHtmlHead() + htmlPieces));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | DocumentException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Generate FilterHtml Pieces error. docId:{0}", e, new Object[]{docId});
            return false;
        }
    }

    private String getHdxFilterHtmlPieces(Element rootElement, String resType) {
        Element searchEle = rootElement.element("search");
        if (searchEle == null) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Not exist search config.");
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(300);
        searchEle.elements().forEach(element -> stringBuilder.append(this.getBigTypeHtml(rootElement.element(element.attributeValue("name")), resType)));
        return stringBuilder.toString();
    }

    private String getIcsFilterHtmlPieces(Element rootElement, String resType) {
        StringBuilder stringBuilder = new StringBuilder(300);
        rootElement.elements("bigType").forEach(element -> stringBuilder.append(this.getBigTypeHtml((Element)element, resType)));
        return stringBuilder.toString();
    }

    public boolean delConfigFile(String docId, String resType) {
        return FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{this.getHtmlSavePath(docId, resType)}));
    }

    public String getFilterHtmlPieces(String docId, String resType) {
        return IcsFileUtils.readFileContent((String)this.getHtmlSavePath(docId, resType), (String)"");
    }

    private String getBigTypeHtml(Element element, String resType) {
        if (element == null) {
            return "";
        }
        String bigTypeId = element.attributeValue(this.xmlNodeAttrMap.get(resType + "bigTypeFieldName"));
        List smallTypeElements = element.elements();
        String smallTypeList = this.getSmallTypeList(smallTypeElements, resType);
        if (StringUtils.isBlank((CharSequence)smallTypeList)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Profile config empty bigType. bigType:{0}", new Object[]{bigTypeId});
            return "";
        }
        String bigTypeName = HdxMetaConfig.INSTANCE.getSortName(bigTypeId, ConfigServiceHandler.getInstance().get("system.lang"));
        bigTypeName = (String)StringUtils.defaultIfBlank((CharSequence)bigTypeName, (CharSequence)element.attributeValue("name"));
        return String.format("<div class='search-filter-item input-checkbox'><div class='search-filter-title' id='%s' title='%s'><span class='titlename'>%s</span></div><ul class='search-filter-child'>%s</ul>%s</div>", HWEncoder.encodeForHTMLAttribute((String)bigTypeId), HWEncoder.encodeForHTMLAttribute((String)bigTypeName), HWEncoder.encodeForHTML((String)bigTypeName), smallTypeList, this.getSmallTypeMoreHtml(smallTypeElements.size()));
    }

    private String getSmallTypeMoreHtml(int smallTypeNums) {
        if (smallTypeNums <= 5) {
            return "";
        }
        return String.format(Locale.ROOT, "<div><a href='javascript:void(0);' class='fr showMore'>%s<em class='icon_more'></em></a></div>", HWEncoder.encodeForHTML((String)I18nResources.INSTANCE.getValueByKey("portal.filter.show")));
    }

    private String getSmallTypeList(List<Element> smallTypeElements, String resType) {
        if (CollectionUtils.isEmpty(smallTypeElements)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(300);
        smallTypeElements.forEach(childrenEle -> stringBuilder.append(this.getTypeHtml((Element)childrenEle, resType)));
        return stringBuilder.toString();
    }

    private String getTypeHtml(Element element, String resType) {
        String smallTypeValue;
        if (element == null) {
            return "";
        }
        String smallTypeValueId = element.attributeValue(this.xmlNodeAttrMap.get(resType + "smallTypeFieldName"));
        if (StringUtils.isBlank((CharSequence)smallTypeValueId)) {
            return "";
        }
        if (StringUtils.equals((CharSequence)resType, (CharSequence)"hdx") && StringUtils.equalsIgnoreCase((CharSequence)smallTypeValueId, (CharSequence)"all")) {
            return "";
        }
        if (StringUtils.equals((CharSequence)resType, (CharSequence)"hdx")) {
            smallTypeValue = this.getHdxSmallTypeName(element, smallTypeValueId, resType);
            if (StringUtils.isBlank((CharSequence)smallTypeValue)) {
                return "";
            }
        } else {
            smallTypeValue = element.attributeValue(this.xmlNodeAttrMap.get(resType + "smallTypeName"));
            smallTypeValue = (String)StringUtils.defaultIfBlank((CharSequence)smallTypeValue, (CharSequence)smallTypeValueId);
        }
        return String.format(Locale.ROOT, "<li><label class='inputcheckbox'><input type='checkbox' value='' /><span></span><a id='%s' title='%s' nodetext='%s'>%s</a></label></li>", HWEncoder.encodeForHTMLAttribute((String)smallTypeValueId), HWEncoder.encodeForHTMLAttribute((String)smallTypeValue), HWEncoder.encodeForHTMLAttribute((String)smallTypeValue), HWEncoder.encodeForHTML((String)smallTypeValue));
    }

    private String getHdxSmallTypeName(Element element, String smallTypeValueId, String resType) {
        String appLang = ConfigServiceHandler.getInstance().get("system.lang");
        if (StringUtils.equals((CharSequence)appLang, (CharSequence)"en")) {
            return smallTypeValueId;
        }
        String smallTypeValue = HdxMetaConfig.INSTANCE.getSortName(smallTypeValueId, appLang);
        if (StringUtils.isNotBlank((CharSequence)smallTypeValue)) {
            return smallTypeValue;
        }
        smallTypeValue = element.attributeValue(this.xmlNodeAttrMap.get(resType + "smallTypeName"));
        return (String)StringUtils.defaultIfBlank((CharSequence)smallTypeValue, (CharSequence)element.attributeValue(XML_NODE_ATTR_VALUE));
    }

    private String getFilterHtmlHead() {
        String filterHeadTitle = I18nResources.INSTANCE.getValueByKey("search.filter.title");
        return String.format(Locale.ROOT, "<div class='search-filter-item input-checkbox'><div class='search-filter-maintitle' id='network_function' title='%s'><span class='maintitlename'>%s</span><div class='search-filter-loading'></div></div></div>", HWEncoder.encodeForHTMLAttribute((String)filterHeadTitle), HWEncoder.encodeForHTML((String)filterHeadTitle));
    }

    public List<SearchSortCommonDto> getSearchSorts(String docId, String resType) {
        String filterPath = this.getHtmlSavePath(docId, resType);
        ArrayList<SearchSortCommonDto> hexSearchSortDos = new ArrayList<SearchSortCommonDto>();
        try {
            Document document = Jsoup.parse((File)FileUtils.getFile((String[])new String[]{filterPath}));
            Elements elements = document.getElementsByAttributeValue("class", "search-filter-item input-checkbox");
            elements.forEach(element -> hexSearchSortDos.addAll(this.getSubSearchSorts((org.jsoup.nodes.Element)element)));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getSearchSorts error, Io exception.", (Throwable)e);
        }
        return hexSearchSortDos;
    }

    private String getHtmlSavePath(String docId, String resType) {
        return IcsLiteStorageInstance.getInstance().getIndexPath() + File.separator + resType + File.separator + docId + File.separator + "searchFilter.html";
    }

    private List<SearchSortCommonDto> getSubSearchSorts(org.jsoup.nodes.Element element) {
        Elements bigTagNodes = element.getElementsByAttributeValue("class", "search-filter-title");
        if (bigTagNodes.isEmpty()) {
            return new ArrayList<SearchSortCommonDto>();
        }
        String bigTypeId = ((org.jsoup.nodes.Element)bigTagNodes.get(0)).attr("id");
        Elements smallNodes = element.getElementsByTag("a");
        ArrayList<SearchSortCommonDto> searchSortDtoList = new ArrayList<SearchSortCommonDto>();
        smallNodes.forEach(node -> {
            String smallTypeId = node.attr("id");
            if (StringUtils.isNotBlank((CharSequence)smallTypeId)) {
                searchSortDtoList.add(new SearchSortCommonDto(bigTypeId, smallTypeId, 0));
            }
        });
        return searchSortDtoList;
    }

    public List<QueryCondition> getQueryMetas(String filters, String metaNamePrefix, boolean isAll) {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        if (StringUtils.isBlank((CharSequence)filters)) {
            return queryConditions;
        }
        if (!StringUtils.contains((CharSequence)filters, (CharSequence)"||")) {
            this.parseFilterItem(filters, metaNamePrefix, isAll, queryConditions);
            return queryConditions;
        }
        String[] filterList = filters.split("\\|\\|");
        Arrays.stream(filterList).forEach(filter -> this.parseFilterItem((String)filter, metaNamePrefix, isAll, (List<QueryCondition>)queryConditions));
        return queryConditions;
    }

    private void parseFilterItem(String filterItem, String metaNamePrefix, boolean isAll, List<QueryCondition> queryConditions) {
        String[] metas = filterItem.split("\\$");
        if (metas.length != 2) {
            return;
        }
        String[] smallTypes = metas[1].split("@");
        List valueList = Arrays.stream(smallTypes).map(StringUtils::toRootLowerCase).collect(Collectors.toList());
        if (isAll) {
            valueList.add("all");
        }
        String metaName = StringUtils.toRootLowerCase((String)(metaNamePrefix + metas[0]));
        queryConditions.add(new QueryCondition(metaName, valueList));
    }

    public List<SearchSortDto> getSorts(String docId, String resType) {
        Document document = null;
        try {
            document = Jsoup.parse((File)FileUtils.getFile((String[])new String[]{this.getHtmlSavePath(docId, resType)}));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get search sort error.", (Throwable)e);
        }
        if (document == null) {
            return Collections.emptyList();
        }
        Elements elements = document.select("div[class=search-filter-item input-checkbox]");
        ArrayList<SearchSortDto> searchSortDtoList = new ArrayList<SearchSortDto>();
        for (org.jsoup.nodes.Element element : elements) {
            Elements smallTypes;
            Elements bigTypeEle = element.select("div[class=search-filter-title]");
            if (CollectionUtils.isEmpty((Collection)bigTypeEle) || CollectionUtils.isEmpty((Collection)(smallTypes = element.select("ul li a")))) continue;
            ArrayList<SearchSortDto> subSearchSortDtoList = new ArrayList<SearchSortDto>();
            smallTypes.forEach(smallType -> subSearchSortDtoList.add(this.getSearchSortDto((org.jsoup.nodes.Element)smallType, (List<SearchSortDto>)new ArrayList<SearchSortDto>())));
            searchSortDtoList.add(this.getSearchSortDto((org.jsoup.nodes.Element)bigTypeEle.get(0), subSearchSortDtoList));
        }
        return searchSortDtoList;
    }

    private SearchSortDto getSearchSortDto(org.jsoup.nodes.Element element, List<SearchSortDto> subSearchSortDtoList) {
        String sortId = element.attr("id");
        String title = element.attr("title");
        String sortName = HdxMetaConfig.INSTANCE.getSortName(sortId, ConfigServiceHandler.getInstance().get("system.lang"));
        if (StringUtils.isNotBlank((CharSequence)sortName)) {
            title = sortName;
        }
        return new SearchSortDto(HWEncoder.encodeForHTMLAttribute((String)sortId), HWEncoder.encodeForHTML((String)title), subSearchSortDtoList);
    }

    public String getFilters(SearchSortCommonDto searchSortCommonDto, String advFilters, String filterFormat) {
        String bigTypeId = searchSortCommonDto.getBigTypeId();
        String smallTypeId = searchSortCommonDto.getSmallTypeId();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{bigTypeId, smallTypeId})) {
            return advFilters;
        }
        String filters = String.format(Locale.ROOT, filterFormat, StringUtils.toRootLowerCase((String)bigTypeId), StringUtils.toRootLowerCase((String)smallTypeId));
        return filters + "||" + advFilters;
    }

    static {
        LOGGER = CommonLoggerFactory.getLogger(SearchFilterDaoHandler.class);
    }
}

