/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.dao;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.search.dto.SearchSuggestWordDto;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SearchSuggestBusinessDaoHandler {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(SearchSuggestBusinessDaoHandler.class);
    private final Cache<String, List<String>> searchSuggestCache = this.initCachePool();

    private SearchSuggestBusinessDaoHandler() {
    }

    public static SearchSuggestBusinessDaoHandler getInstance() {
        return SearchSuggestBusinessDaoHandlerHolder.INSTANCE;
    }

    private Cache<String, List<String>> initCachePool() {
        RemovalListener removeListener = notification -> {
            String docId = FileUtils.getFile((String[])new String[]{(String)notification.getKey()}).getName();
            CodeCCUtils.INSTANCE.debugLog(LOG, "Cache expire, remove search suggest cache of Doc[{0}].", new Object[]{docId});
        };
        return CacheBuilder.newBuilder().maximumSize(4L).expireAfterAccess(30L, TimeUnit.MINUTES).removalListener(removeListener).build();
    }

    public List<String> getCache(String key) {
        return (List)this.searchSuggestCache.getIfPresent((Object)key);
    }

    public void addCache(String key, List<? extends SearchSuggestWordDto> searchSuggestWordDtoList) {
        if (CollectionUtils.isEmpty(searchSuggestWordDtoList)) {
            return;
        }
        List suggestWordList = searchSuggestWordDtoList.stream().map(searchSuggestWordDto -> searchSuggestWordDto.getWord()).collect(Collectors.toList());
        this.searchSuggestCache.put((Object)key, suggestWordList);
    }

    public void deleteCache(String key) {
        this.searchSuggestCache.invalidate((Object)key);
    }

    public List<String> getResultOfMatch(String inputWord, List<String> cacheSuggestList, List<String> pidSuggestList, int num) {
        if (CollectionUtils.isEmpty(cacheSuggestList)) {
            return new ArrayList<String>();
        }
        List<String> suggestWordList = this.getResultOfPrefixMatch(inputWord, cacheSuggestList, pidSuggestList, num);
        if (suggestWordList.size() < num) {
            suggestWordList.addAll(this.getResultOfIncludeMatch(inputWord, cacheSuggestList, pidSuggestList, num - suggestWordList.size()));
        }
        return suggestWordList;
    }

    private List<String> getResultOfPrefixMatch(String inputWord, List<String> cacheSuggestList, List<String> pidSuggestList, int num) {
        return cacheSuggestList.stream().filter(word -> !pidSuggestList.contains(word) && this.prefixJudgment(inputWord, (String)word)).limit(num).collect(Collectors.toList());
    }

    private List<String> getResultOfIncludeMatch(String inputWord, List<String> cacheSuggestList, List<String> pidSuggestList, int num) {
        return cacheSuggestList.stream().filter(word -> !pidSuggestList.contains(word) && this.includeJudgment(inputWord, (String)word)).limit(num).collect(Collectors.toList());
    }

    private boolean prefixJudgment(String inputWord, String wordTmp) {
        return StringUtils.startsWithIgnoreCase((CharSequence)wordTmp, (CharSequence)StringUtils.trim((String)inputWord));
    }

    private boolean includeJudgment(String inputWord, String wordTmp) {
        return !StringUtils.startsWithIgnoreCase((CharSequence)wordTmp, (CharSequence)StringUtils.trim((String)inputWord)) && StringUtils.containsIgnoreCase((CharSequence)wordTmp, (CharSequence)StringUtils.trim((String)inputWord));
    }

    public int getFrequency(String queryContent, int index, int frequencyDefault) {
        String frequencyTemp = StringUtils.trim((String)queryContent.substring(index));
        int wordFrequency = frequencyDefault;
        if (StringUtils.isNumeric((CharSequence)frequencyTemp)) {
            wordFrequency = Integer.parseInt(frequencyTemp);
        }
        return wordFrequency;
    }

    private static class SearchSuggestBusinessDaoHandlerHolder {
        private static final SearchSuggestBusinessDaoHandler INSTANCE = new SearchSuggestBusinessDaoHandler();

        private SearchSuggestBusinessDaoHandlerHolder() {
        }
    }
}

