/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.serviceimpl;

import com.huawei.support.icslite.business.libmanage.dto.LibResponseDto;
import com.huawei.support.icslite.business.libmanage.serviceimpl.HdxManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.serviceimpl.IcsManageServiceHandler;
import com.huawei.support.icslite.business.search.dao.SearchFilterDaoHandler;
import com.huawei.support.icslite.business.search.dto.AdvSearchRangeDto;
import com.huawei.support.icslite.business.search.dto.IcsSearchContentDto;
import com.huawei.support.icslite.business.search.dto.SearchSortDto;
import com.huawei.support.icslite.business.search.service.AdvSearchBusiness;
import com.huawei.wsf.core.HWEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class AdvSearchBusinessHandler
implements AdvSearchBusiness {
    private AdvSearchBusinessHandler() {
    }

    public static AdvSearchBusinessHandler getInstance() {
        return AdvSearchBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public AdvSearchRangeDto getSearchRange() {
        ArrayList<LibResponseDto> libDatalist = new ArrayList<LibResponseDto>();
        libDatalist.addAll(IcsManageServiceHandler.getInstance().getAll("", ""));
        libDatalist.addAll(HdxManageServiceHandler.getInstance().getAll("", ""));
        ArrayList<SearchSortDto> searchSortList = new ArrayList<SearchSortDto>();
        ArrayList<IcsSearchContentDto> searchContentList = new ArrayList<IcsSearchContentDto>();
        libDatalist.forEach(libResponseDto -> {
            List<SearchSortDto> subSearchSortDtos = SearchFilterDaoHandler.INSTANCE.getSorts(libResponseDto.getDocId(), "hdx");
            searchSortList.addAll(subSearchSortDtos);
            searchContentList.add(this.getSearchContentDto((LibResponseDto)libResponseDto));
        });
        return new AdvSearchRangeDto(searchContentList, this.mergeSort(searchSortList));
    }

    @Override
    public AdvSearchRangeDto getSingleSearchRange(String docId, String resType) {
        return new AdvSearchRangeDto(new ArrayList<IcsSearchContentDto>(), SearchFilterDaoHandler.INSTANCE.getSorts(docId, resType));
    }

    private List<SearchSortDto> mergeSort(List<SearchSortDto> searchSortList) {
        Collection<SearchSortDto> mergeList = searchSortList.stream().collect(Collectors.toMap(item -> item.getId(), value -> value, (o1, o2) -> {
            o1.getSmallTypeList().addAll(o2.getSmallTypeList());
            o1.setSmallTypeList(o1.getSmallTypeList().stream().distinct().collect(Collectors.toList()));
            return o1;
        })).values();
        return mergeList.stream().collect(Collectors.toList());
    }

    private IcsSearchContentDto getSearchContentDto(LibResponseDto libResponseDto) {
        return new IcsSearchContentDto().setDocId(libResponseDto.getDocId()).setProductVersion(HWEncoder.encodeForHTML((String)libResponseDto.getProductV())).setLibName(HWEncoder.encodeForHTML((String)libResponseDto.getLibName())).setLibV(HWEncoder.encodeForHTML((String)libResponseDto.getLibV())).setIssueDate(libResponseDto.getIssueDate());
    }

    private static class AdvSearchBusinessHandlerHolder {
        private static final AdvSearchBusinessHandler INSTANCE = new AdvSearchBusinessHandler();

        private AdvSearchBusinessHandlerHolder() {
        }
    }
}

