/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.serviceimpl;

import com.huawei.support.icslite.business.search.dao.GlobalSearchBusinessDaoHandler;
import com.huawei.support.icslite.business.search.dto.SearchQuery;
import com.huawei.support.icslite.business.search.dto.SearchResultDto;
import com.huawei.support.icslite.business.search.dto.SearchTopicDto;
import com.huawei.support.icslite.business.search.dto.SemaphoreDto;
import com.huawei.support.icslite.business.search.service.GlobalSearchBusiness;

public class GlobalSearchBusinessHandler
implements GlobalSearchBusiness {
    private static final int SEMAPHORE_PERIMETERS = 5;
    private SemaphoreDto semaphoreDto = new SemaphoreDto(5);

    private GlobalSearchBusinessHandler() {
    }

    public static GlobalSearchBusinessHandler getInstance() {
        return GlobalSearchBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public SearchResultDto<SearchTopicDto> getSearchResult(SearchQuery searchQuery) {
        SearchResultDto<SearchTopicDto> searchResultDto = new SearchResultDto<SearchTopicDto>();
        if (searchQuery == null) {
            return searchResultDto;
        }
        try {
            this.semaphoreDto.acquire();
            searchResultDto = GlobalSearchBusinessDaoHandler.getInstance().getSearchResult(searchQuery);
        }
        finally {
            this.semaphoreDto.release();
        }
        return searchResultDto;
    }

    @Override
    public boolean availablePermits() {
        return this.semaphoreDto.availablePermits();
    }

    private static class GlobalSearchBusinessHandlerHolder {
        private static final GlobalSearchBusinessHandler INSTANCE = new GlobalSearchBusinessHandler();

        private GlobalSearchBusinessHandlerHolder() {
        }
    }
}

