/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.serviceimpl;

import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.search.dao.HdxSearchBusinessDaoHandler;
import com.huawei.support.icslite.business.search.dao.SearchFilterDaoHandler;
import com.huawei.support.icslite.business.search.dto.HdxSearchQuery;
import com.huawei.support.icslite.business.search.dto.HdxSearchTopicDto;
import com.huawei.support.icslite.business.search.dto.SearchResultDto;
import com.huawei.support.icslite.business.search.dto.SearchSortCommonDto;
import com.huawei.support.icslite.business.search.dto.SemaphoreDto;
import com.huawei.support.icslite.business.search.service.HdxSearchBusiness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxSearchBusinessHandler
implements HdxSearchBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxSearchBusinessHandler.class);
    private static final String SORT_META_FILTER_FORMAT = "%s$%s@all";
    private static final int SEMAPHORE_PERIMETERS = 5;
    private final SemaphoreDto semaphoreDto = new SemaphoreDto(5);

    private HdxSearchBusinessHandler() {
    }

    public static HdxSearchBusinessHandler getInstance() {
        return HdxSearchBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public SearchResultDto<HdxSearchTopicDto> getHdxSearchResult(HdxSearchQuery hdxSearchQuery) {
        SearchResultDto<HdxSearchTopicDto> searchResultDto = new SearchResultDto<HdxSearchTopicDto>();
        if (hdxSearchQuery == null) {
            return searchResultDto;
        }
        try {
            this.semaphoreDto.acquire();
            searchResultDto = HdxSearchBusinessDaoHandler.INSTANCE.getResult(hdxSearchQuery, this.getExtendLibIndexDir(hdxSearchQuery.getDocid()));
        }
        finally {
            this.semaphoreDto.release();
        }
        return searchResultDto;
    }

    @Override
    public boolean delConfigFile(String docId) {
        boolean isSuccess = SearchFilterDaoHandler.INSTANCE.delConfigFile(docId, "hdx");
        if (!isSuccess) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Delete filter file fail. docId:{0}", new Object[]{docId});
        }
        return isSuccess;
    }

    @Override
    public String getFilterHtmlPieces(String docId) {
        return SearchFilterDaoHandler.INSTANCE.getFilterHtmlPieces(docId, "hdx");
    }

    @Override
    public boolean availablePermits() {
        return this.semaphoreDto.availablePermits();
    }

    @Override
    public List<SearchSortCommonDto> getSortInfo(HdxSearchQuery hdxSearchQuery) {
        int pageEnd;
        if (hdxSearchQuery == null) {
            return new ArrayList<SearchSortCommonDto>();
        }
        String docId = hdxSearchQuery.getDocid();
        List<SearchSortCommonDto> searchSorts = SearchFilterDaoHandler.INSTANCE.getSearchSorts(docId, "hdx");
        if (CollectionUtils.isEmpty(searchSorts)) {
            return new ArrayList<SearchSortCommonDto>();
        }
        int sortCount = searchSorts.size();
        int pageIndex = hdxSearchQuery.getPageindex();
        int pageStart = pageIndex == 1 ? 0 : (pageIndex - 1) * hdxSearchQuery.getPagesize();
        if (pageStart >= (pageEnd = Math.min(pageStart + hdxSearchQuery.getPagesize(), sortCount))) {
            return new ArrayList<SearchSortCommonDto>();
        }
        List<SearchSortCommonDto> targetSearchSorts = searchSorts.subList(pageStart, pageEnd);
        String advSearchFilters = hdxSearchQuery.getFilter();
        Map<String, List<String>> searchConditions = HdxSearchBusinessDaoHandler.INSTANCE.getNaviSearchConditions(hdxSearchQuery.getDocid(), hdxSearchQuery.getNaviids());
        List<String> indexDirs = this.getExtendLibIndexDir(hdxSearchQuery.getDocid());
        for (SearchSortCommonDto searchSortCommonDto : targetSearchSorts) {
            String filters = SearchFilterDaoHandler.INSTANCE.getFilters(searchSortCommonDto, advSearchFilters, SORT_META_FILTER_FORMAT);
            if (StringUtils.isBlank((CharSequence)filters)) continue;
            hdxSearchQuery.setFilter(filters);
            searchSortCommonDto.setCount(this.getSortCount(hdxSearchQuery, indexDirs, searchConditions));
        }
        return targetSearchSorts;
    }

    @Override
    public boolean deleteIndexReaderCache(String docId) {
        return HdxSearchBusinessDaoHandler.INSTANCE.deleteIndexReaderCache(docId);
    }

    private int getSortCount(HdxSearchQuery hdxSearchQuery, List<String> indexDirs, Map<String, List<String>> conditionMap) {
        int count = 0;
        try {
            count = HdxSearchBusinessDaoHandler.INSTANCE.getResultCount(hdxSearchQuery, indexDirs, conditionMap);
        }
        catch (SearchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get sort count error.", (Throwable)e);
        }
        return count;
    }

    private List<String> getExtendLibIndexDir(String docId) {
        List hdxContentDos;
        HdxContentDo hdxLibDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        ArrayList<String> extendIds = new ArrayList<String>();
        if (hdxLibDo == null) {
            return extendIds;
        }
        HdxContentDo hdxBaseDo = hdxLibDo;
        if (StringUtils.equals((CharSequence)hdxLibDo.getLibType(), (CharSequence)"1")) {
            hdxBaseDo = HdxContentPoolServiceHandler.getInstance().getBaseByMend(docId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(hdxContentDos = HdxContentPoolServiceHandler.getInstance().getExtendList(hdxBaseDo)))) {
            hdxContentDos.forEach(hdxContentDo -> extendIds.add(hdxContentDo.getDocId()));
        }
        return extendIds;
    }

    @Override
    public boolean generateFilterHtmlPieces(String docId) {
        HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (hdxContentDo == null) {
            return false;
        }
        return SearchFilterDaoHandler.INSTANCE.generateFilterHtmlPieces(docId, hdxContentDo.getPath(), "profile.xml", "hdx");
    }

    private static class HdxSearchBusinessHandlerHolder {
        private static final HdxSearchBusinessHandler INSTANCE = new HdxSearchBusinessHandler();

        private HdxSearchBusinessHandlerHolder() {
        }
    }
}

