/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.serviceimpl;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.search.dao.SearchSuggestBusinessDaoHandler;
import com.huawei.support.icslite.business.search.dto.HdxSearchSuggestWordDto;
import com.huawei.support.icslite.business.search.service.HdxSearchSuggestBusiness;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;

public class HdxSearchSuggestBusinessHander
implements HdxSearchSuggestBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxSearchSuggestBusinessHander.class);
    private static final int SUGGEST_MAX_NUMBER = 10;
    private List<HdxSearchSuggestWordDto> searchSuggestWordTimes = Collections.synchronizedList(new ArrayList());

    private HdxSearchSuggestBusinessHander() {
    }

    public static HdxSearchSuggestBusinessHander getInstance() {
        return HdxSearchSuggestBusinessHanderHolder.INSTANCE;
    }

    @Override
    public List<String> getSearchSuggestWords(String docId, String inputWord) {
        ArrayList<String> suggestList = new ArrayList<String>();
        HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (hdxContentDo == null) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Not found {0}.", new Object[]{docId});
            return suggestList;
        }
        if (StringUtils.isBlank((CharSequence)inputWord)) {
            return suggestList;
        }
        List<String> cacheSuggestList = SearchSuggestBusinessDaoHandler.getInstance().getCache(docId);
        if (CollectionUtils.isEmpty(cacheSuggestList)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "{0} cacheSuggestList is empty .", new Object[]{docId});
            return suggestList;
        }
        return SearchSuggestBusinessDaoHandler.getInstance().getResultOfMatch(inputWord, cacheSuggestList, new ArrayList<String>(), 10);
    }

    private List<HdxSearchSuggestWordDto> getSuggestWordFromFileToCache(HdxContentDo hdxContentDo) {
        List extendList;
        this.searchSuggestWordTimes.addAll(this.getSearchSuggestFromFile(hdxContentDo));
        String type = hdxContentDo.getLibType();
        if (StringUtils.equals((CharSequence)"0", (CharSequence)type)) {
            extendList = HdxContentPoolServiceHandler.getInstance().getExtendList(hdxContentDo);
            this.getExtendContent(extendList);
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)type)) {
            extendList = HdxContentPoolServiceHandler.getInstance().getExtendList(HdxContentPoolServiceHandler.getInstance().getBaseByMend(hdxContentDo));
            this.getExtendContent(extendList);
        }
        List<HdxSearchSuggestWordDto> suggestList = this.searchSuggestWordTimes;
        this.searchSuggestWordTimes = Collections.synchronizedList(new ArrayList());
        return suggestList;
    }

    private void getExtendContent(List<HdxContentDo> extendList) {
        for (HdxContentDo extendContent : extendList) {
            this.mergeSearchSuggest(extendContent);
        }
    }

    private void mergeSearchSuggest(HdxContentDo contentDo) {
        List<HdxSearchSuggestWordDto> wordTimes = this.getSearchSuggestFromFile(contentDo);
        for (HdxSearchSuggestWordDto wordTime : wordTimes) {
            boolean isAdded = true;
            String contentDoWord = wordTime.getWord();
            for (HdxSearchSuggestWordDto cacheWordDto : this.searchSuggestWordTimes) {
                String cacheWord = cacheWordDto.getWord();
                if (!StringUtils.equals((CharSequence)contentDoWord, (CharSequence)cacheWord)) continue;
                cacheWordDto.setTimes(wordTime.getTimes() + cacheWordDto.getTimes());
                isAdded = false;
                break;
            }
            if (!isAdded) continue;
            this.searchSuggestWordTimes.add(wordTime);
        }
        Collections.sort(this.searchSuggestWordTimes);
    }

    private List<HdxSearchSuggestWordDto> getSearchSuggestFromFile(HdxContentDo hdxContentDo) {
        ArrayList<HdxSearchSuggestWordDto> wordTimeDescList = new ArrayList<HdxSearchSuggestWordDto>();
        return this.getSuggestTxt(hdxContentDo, wordTimeDescList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<HdxSearchSuggestWordDto> getSuggestTxt(HdxContentDo hdxContentDo, List<HdxSearchSuggestWordDto> wordTimeDescList) {
        File file = FileUtils.getFile((String[])new String[]{hdxContentDo.getPath()});
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry("resources/suggest.txt");
            if (zipEntry == null) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "suggest.txt is not exists");
                List<HdxSearchSuggestWordDto> list = wordTimeDescList;
                return list;
            }
            this.getSuggestContent(wordTimeDescList, zipFile, zipEntry);
            return wordTimeDescList;
        }
        catch (ZipException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create new ZipFile error", (Throwable)e);
            return wordTimeDescList;
        }
        catch (FileNotFoundException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Exeception when create zipfile  error");
            return wordTimeDescList;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create zipFile getInputStream error");
        }
        return wordTimeDescList;
    }

    private void getSuggestContent(List<HdxSearchSuggestWordDto> wordTimeDescList, ZipFile zipFile, ZipEntry zipEntry) {
        int nLine = 0;
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry), StandardCharsets.UTF_8));){
            LineIterator lineIterator = new LineIterator((Reader)bufReader);
            while (lineIterator.hasNext()) {
                String lineInput = StringUtils.trim((String)lineIterator.next());
                if (StringUtils.isBlank((CharSequence)lineInput)) continue;
                int frequency = 1;
                if (++nLine == 1 && lineInput.charAt(0) == '\ufeff') {
                    lineInput = lineInput.substring(1);
                }
                int splitPos = lineInput.lastIndexOf(" ");
                String wordStr = lineInput;
                if (splitPos > 0) {
                    wordStr = lineInput.substring(0, splitPos);
                    frequency = SearchSuggestBusinessDaoHandler.getInstance().getFrequency(lineInput, splitPos, frequency);
                }
                HdxSearchSuggestWordDto wordTimeTmp = new HdxSearchSuggestWordDto(wordStr, frequency);
                wordTimeDescList.add(wordTimeTmp);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getSuggestContent io ERROR !");
        }
    }

    @Override
    public void getCacheSuggest(String docId) {
        HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (hdxContentDo == null) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Not found {0}.", new Object[]{docId});
            return;
        }
        List<String> cacheSuggestList = SearchSuggestBusinessDaoHandler.getInstance().getCache(docId);
        if (CollectionUtils.isNotEmpty(cacheSuggestList)) {
            return;
        }
        List<HdxSearchSuggestWordDto> suggestWordDtoList = this.getSuggestWordFromFileToCache(hdxContentDo);
        SearchSuggestBusinessDaoHandler.getInstance().addCache(docId, suggestWordDtoList);
    }

    @Override
    public void deleteSuggestWords(String docId) {
        HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (hdxContentDo == null) {
            return;
        }
        String libType = hdxContentDo.getLibType();
        SearchSuggestBusinessDaoHandler.getInstance().deleteCache(docId);
        if (StringUtils.equals((CharSequence)"2", (CharSequence)libType)) {
            this.deleteAssociationCache(docId);
        }
    }

    @Override
    public void updateSuggestWords(String docId) {
        this.deleteSuggestWords(docId);
    }

    private void deleteAssociationCache(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Not found {0}.", new Object[]{docId});
            return;
        }
        List baseLibs = HdxContentPoolServiceHandler.getInstance().getBaseByExtend(docId);
        if (CollectionUtils.isEmpty((Collection)baseLibs)) {
            return;
        }
        for (HdxContentDo baseDo : baseLibs) {
            SearchSuggestBusinessDaoHandler.getInstance().deleteCache(baseDo.getDocId());
            List mendList = HdxContentPoolServiceHandler.getInstance().getMendList(baseDo);
            if (CollectionUtils.isEmpty((Collection)mendList)) continue;
            for (HdxContentDo mendDo : mendList) {
                SearchSuggestBusinessDaoHandler.getInstance().deleteCache(mendDo.getDocId());
            }
        }
    }

    private static class HdxSearchSuggestBusinessHanderHolder {
        private static final HdxSearchSuggestBusinessHander INSTANCE = new HdxSearchSuggestBusinessHander();

        private HdxSearchSuggestBusinessHanderHolder() {
        }
    }
}

