/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.serviceimpl;

import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.IcsContentService;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.search.dao.IcsSearchBusinessDaoHandler;
import com.huawei.support.icslite.business.search.dao.SearchFilterDaoHandler;
import com.huawei.support.icslite.business.search.dto.IcsSearchContentDto;
import com.huawei.support.icslite.business.search.dto.IcsSearchQuery;
import com.huawei.support.icslite.business.search.dto.IcsSearchTopicDto;
import com.huawei.support.icslite.business.search.dto.SearchResultDto;
import com.huawei.support.icslite.business.search.dto.SearchSortCommonDto;
import com.huawei.support.icslite.business.search.dto.SemaphoreDto;
import com.huawei.support.icslite.business.search.service.IcsSearchBusiness;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsSearchBusinessHandler
implements IcsSearchBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsSearchBusinessHandler.class);
    private static final String SORT_META_FILTER_FORMAT = "%s$%s";
    private static final int SEMAPHORE_PERMISSIONS = 5;
    private final IcsContentService icsContentService = IcsContentPoolServiceHandler.getInstance();
    private final SemaphoreDto semaphoreDto = new SemaphoreDto(5);

    private IcsSearchBusinessHandler() {
    }

    public static IcsSearchBusinessHandler getInstance() {
        return IcsSearchBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public SearchResultDto<IcsSearchTopicDto> getSearchResult(IcsSearchQuery icsSearchQuery) {
        SearchResultDto<IcsSearchTopicDto> icsSearchResultDto = new SearchResultDto<IcsSearchTopicDto>();
        if (icsSearchQuery == null) {
            return icsSearchResultDto;
        }
        try {
            this.semaphoreDto.acquire();
            icsSearchResultDto = IcsSearchBusinessDaoHandler.INSTANCE.getSearchResult(icsSearchQuery);
        }
        finally {
            this.semaphoreDto.release();
        }
        return icsSearchResultDto;
    }

    @Override
    public IcsSearchContentDto getContentInfo(String docId) {
        IcsContentDo icsContentDo = this.icsContentService.get(docId);
        IcsSearchContentDto icsSearchContentDto = null;
        if (icsContentDo != null) {
            icsSearchContentDto = new IcsSearchContentDto();
            icsSearchContentDto.setDocId(icsContentDo.getDocId());
            icsSearchContentDto.setProductName(icsContentDo.getProductName());
            icsSearchContentDto.setProductVersion(icsContentDo.getProductV());
        }
        return icsSearchContentDto;
    }

    @Override
    public boolean availablePermits() {
        return this.semaphoreDto.availablePermits();
    }

    @Override
    public boolean deleteIndexReaderCache(String docId) {
        return IcsSearchBusinessDaoHandler.INSTANCE.deleteIndexReaderCache(docId);
    }

    @Override
    public String getIcsFilterHtmlPieces(String docId) {
        String filterHtml = SearchFilterDaoHandler.INSTANCE.getFilterHtmlPieces(docId, "ics");
        if (StringUtils.isBlank((CharSequence)filterHtml)) {
            this.generateIcsFilterHtmlPieces(docId);
            return SearchFilterDaoHandler.INSTANCE.getFilterHtmlPieces(docId, "ics");
        }
        return filterHtml;
    }

    @Override
    public boolean generateIcsFilterHtmlPieces(String docId) {
        IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
        if (icsContentDo == null) {
            return false;
        }
        String icsPath = icsContentDo.getPath();
        return SearchFilterDaoHandler.INSTANCE.generateFilterHtmlPieces(docId, icsPath, "resources/infocenter_service/conf/search.xml", "ics");
    }

    @Override
    public List<SearchSortCommonDto> getIcsSortInfo(IcsSearchQuery icsSearchQuery) {
        int pageEnd;
        if (icsSearchQuery == null) {
            return new ArrayList<SearchSortCommonDto>();
        }
        String docId = icsSearchQuery.getDocid();
        List<SearchSortCommonDto> icsPrimarySearchSorts = SearchFilterDaoHandler.INSTANCE.getSearchSorts(docId, "ics");
        if (CollectionUtils.isEmpty(icsPrimarySearchSorts)) {
            return new ArrayList<SearchSortCommonDto>();
        }
        int pageIndex = icsSearchQuery.getPageindex();
        int allSmallTypeCount = icsPrimarySearchSorts.size();
        int pageStart = pageIndex == 1 ? 0 : (pageIndex - 1) * icsSearchQuery.getPagesize();
        if (pageStart >= (pageEnd = Math.min(pageStart + icsSearchQuery.getPagesize(), allSmallTypeCount))) {
            return new ArrayList<SearchSortCommonDto>();
        }
        String keyword = icsSearchQuery.getKeyword();
        String advSearchFilters = icsSearchQuery.getFilter();
        List<SearchSortCommonDto> icsFinalSearchSorts = icsPrimarySearchSorts.subList(pageStart, pageEnd);
        for (SearchSortCommonDto searchSortCommonDto : icsFinalSearchSorts) {
            String filters = SearchFilterDaoHandler.INSTANCE.getFilters(searchSortCommonDto, advSearchFilters, SORT_META_FILTER_FORMAT);
            if (StringUtils.isBlank((CharSequence)filters)) continue;
            searchSortCommonDto.setCount(this.getIcsSortCount(docId, keyword, filters));
        }
        return icsFinalSearchSorts;
    }

    private int getIcsSortCount(String docId, String keyword, String filters) {
        IcsSearchQuery icsSearchQuery = new IcsSearchQuery();
        icsSearchQuery.setKeyword(keyword);
        icsSearchQuery.setDocid(docId);
        icsSearchQuery.setFilter(filters);
        int count = 0;
        try {
            count = IcsSearchBusinessDaoHandler.INSTANCE.getIcsResultCount(icsSearchQuery);
        }
        catch (SearchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "ics Get smallType count error. exception is:{0}.", (Throwable)e);
        }
        return count;
    }

    private static class IcsSearchBusinessHandlerHolder {
        private static final IcsSearchBusinessHandler INSTANCE = new IcsSearchBusinessHandler();

        private IcsSearchBusinessHandlerHolder() {
        }
    }
}

