/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.search.serviceimpl;

import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.docnav.service.impl.IcsDocnavPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.service.impl.IcsVersionRelationPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavTreeDto;
import com.huawei.support.icslite.business.docnav.serviceimpl.IcsDocnavBusinessServiceHandler;
import com.huawei.support.icslite.business.search.dao.SearchSuggestBusinessDaoHandler;
import com.huawei.support.icslite.business.search.dto.IcsSearchSuggestWordDto;
import com.huawei.support.icslite.business.search.service.IcsSearchSuggestBusiness;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.internal.StringUtil;

public class IcsSearchSuggestBusinessHander
implements IcsSearchSuggestBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsSearchSuggestBusinessHander.class);
    private static final int SUGGEST_MAX_NUMBER = 10;
    private static final int PID_LOCATION = 2;
    private static final char FILE_BOM = '\ufeff';

    private IcsSearchSuggestBusinessHander() {
    }

    public static IcsSearchSuggestBusinessHander getInstance() {
        return IcsSearchSuggestBusinessHanderHolder.INSTANCE;
    }

    @Override
    public List<String> getSearchSuggestWords(String docId, String refDocId, String inputWord, String pidId) {
        if (StringUtil.isBlank((String)inputWord)) {
            return Collections.emptyList();
        }
        String cacheKey = (String)StringUtils.defaultIfEmpty((CharSequence)refDocId, (CharSequence)docId);
        if (StringUtils.isBlank((CharSequence)pidId)) {
            return this.getAllCacheSuggestWords(docId, inputWord, new ArrayList<String>(), 10);
        }
        return this.getPidCacheSuggestWords(docId, cacheKey + pidId, inputWord);
    }

    private List<String> getAllCacheSuggestWords(String key, String inputWord, List<String> pidSuggestList, int num) {
        List<String> cacheSuggestList = SearchSuggestBusinessDaoHandler.getInstance().getCache(key);
        if (CollectionUtils.isEmpty(cacheSuggestList)) {
            List<IcsSearchSuggestWordDto> suggestWordDtoList = this.getAllSuggestWords(key);
            SearchSuggestBusinessDaoHandler.getInstance().addCache(key, suggestWordDtoList);
        }
        return SearchSuggestBusinessDaoHandler.getInstance().getResultOfMatch(inputWord, cacheSuggestList, pidSuggestList, num);
    }

    private List<String> getPidCacheSuggestWords(String docId, String key, String inputWord) {
        List<String> cacheSuggestList = SearchSuggestBusinessDaoHandler.getInstance().getCache(key);
        List<String> suggestWordList = SearchSuggestBusinessDaoHandler.getInstance().getResultOfMatch(inputWord, cacheSuggestList, new ArrayList<String>(), 10);
        int size = suggestWordList.size();
        if (size < 10) {
            suggestWordList.addAll(this.getAllCacheSuggestWords(docId, inputWord, suggestWordList, 10 - size));
        }
        return suggestWordList;
    }

    @Override
    public void getCacheSuggest(String docId, String pidId, String reDocId) {
        String realDocId = (String)StringUtils.defaultIfBlank((CharSequence)reDocId, (CharSequence)docId);
        String cacheKey = StringUtils.isBlank((CharSequence)pidId) ? realDocId : realDocId + pidId;
        List<String> cacheSuggestList = SearchSuggestBusinessDaoHandler.getInstance().getCache(cacheKey);
        if (CollectionUtils.isNotEmpty(cacheSuggestList)) {
            return;
        }
        List<IcsSearchSuggestWordDto> searchSuggestWordDtoList = StringUtils.isBlank((CharSequence)pidId) ? this.getAllSuggestWords(docId) : this.getPidData(pidId, docId, reDocId).stream().distinct().collect(Collectors.toList());
        SearchSuggestBusinessDaoHandler.getInstance().addCache(cacheKey, searchSuggestWordDtoList);
    }

    private List<IcsSearchSuggestWordDto> getPidData(String pidId, String docId, String refDocId) {
        List<IcsSearchSuggestWordDto> currentPidSuggestWords = this.getPidsContent(pidId, (String)StringUtils.defaultIfBlank((CharSequence)refDocId, (CharSequence)docId));
        Collections.sort(currentPidSuggestWords);
        ArrayList<IcsSearchSuggestWordDto> wordDtoList = new ArrayList<IcsSearchSuggestWordDto>(currentPidSuggestWords);
        ArrayList<IcsSearchSuggestWordDto> innerWordDtoList = new ArrayList<IcsSearchSuggestWordDto>();
        this.getTopicContents(docId, pidId, innerWordDtoList, refDocId, 5);
        Collections.sort(innerWordDtoList);
        wordDtoList.addAll(innerWordDtoList);
        return wordDtoList.stream().distinct().collect(Collectors.toList());
    }

    private void getTopicContents(String docId, String pidId, List<IcsSearchSuggestWordDto> wordDtoList, String reDocId, int layer) {
        if (layer <= 0) {
            return;
        }
        List topicPids = IcsNaviTopicServiceHandler.getInstance().getTopicPids((String)StringUtils.defaultIfBlank((CharSequence)reDocId, (CharSequence)docId), pidId);
        if (CollectionUtils.isEmpty((Collection)topicPids)) {
            return;
        }
        List relationDocIcList = IcsVersionRelationPoolServiceHandler.getInstance().getRelationDocIcList(docId);
        if (CollectionUtils.isEmpty((Collection)relationDocIcList)) {
            topicPids.forEach(topicDo -> wordDtoList.addAll(this.getPidsContent(topicDo.getTopicPidId(), docId)));
            return;
        }
        int currentLayer = layer;
        for (IcsTopicDo topicPid : topicPids) {
            wordDtoList.addAll(this.getPidsContent(topicPid.getTopicPidId(), docId));
            for (String relationDocId : relationDocIcList) {
                wordDtoList.addAll(this.getPidsContent(topicPid.getTopicPidId(), relationDocId));
            }
            this.getTopicContents(docId, topicPid.getTopicPidId(), wordDtoList, reDocId, currentLayer--);
        }
    }

    private List<IcsSearchSuggestWordDto> getPidsContent(String pidId, String docId) {
        List<IcsSearchSuggestWordDto> searchSuggestFromFile = this.getSuggestTxt(docId);
        return searchSuggestFromFile.stream().filter(icsSearchSuggestWordDto -> CollectionUtils.isNotEmpty(icsSearchSuggestWordDto.getPidList())).filter(icsSearchSuggestWordDto -> icsSearchSuggestWordDto.getPidList().contains(pidId)).collect(Collectors.toList());
    }

    private List<IcsSearchSuggestWordDto> getAllSuggestWords(String docId) {
        List<IcsSearchSuggestWordDto> mainPackageContent = this.getSuggestTxt(docId);
        List<IcsSearchSuggestWordDto> referencesPidList = this.getReferencesPid(docId);
        for (IcsSearchSuggestWordDto referencesWordDto : referencesPidList) {
            if (!this.checkMainLibSuggestWord(mainPackageContent, referencesWordDto)) continue;
            mainPackageContent.add(referencesWordDto);
        }
        Collections.sort(mainPackageContent);
        return mainPackageContent;
    }

    private boolean checkMainLibSuggestWord(List<IcsSearchSuggestWordDto> mainPackageContent, IcsSearchSuggestWordDto referencesWordDto) {
        for (IcsSearchSuggestWordDto mainWordDto : mainPackageContent) {
            if (!StringUtils.equals((CharSequence)referencesWordDto.getWord(), (CharSequence)mainWordDto.getWord())) continue;
            mainWordDto.setTimes(referencesWordDto.getTimes() + mainWordDto.getTimes());
            return false;
        }
        return true;
    }

    private List<IcsSearchSuggestWordDto> getReferencesPid(String docId) {
        ArrayList<IcsSearchSuggestWordDto> wordTimeDescPidList = new ArrayList<IcsSearchSuggestWordDto>();
        List docNaviDtos = IcsDocnavPoolServiceHandler.getInstance().get(docId);
        if (CollectionUtils.isEmpty((Collection)docNaviDtos)) {
            return wordTimeDescPidList;
        }
        Map<String, Set<String>> refPids = this.getRefPids(docId, docNaviDtos);
        LinkedHashSet suggestWords = new LinkedHashSet();
        for (Map.Entry<String, Set<String>> entry : refPids.entrySet()) {
            Optional.ofNullable(entry.getValue()).orElseGet(HashSet::new).forEach(pId -> this.getReferenceData((String)entry.getKey(), (String)pId, suggestWords));
        }
        wordTimeDescPidList.addAll(suggestWords);
        return wordTimeDescPidList;
    }

    private Map<String, Set<String>> getAllPIds(String docId, List<IcsDocnavDo> docNaviDtos) {
        HashedMap allPids = new HashedMap();
        for (IcsDocnavDo icsDocnavDo : docNaviDtos) {
            List<IcsPidDo> pIdsFromDocNav = this.getPidsFromDocNav(docId, icsDocnavDo.getDocnavId());
            pIdsFromDocNav.forEach(arg_0 -> IcsSearchSuggestBusinessHander.lambda$getAllPIds$5((Map)allPids, arg_0));
        }
        return allPids;
    }

    private Map<String, Set<String>> getRefPids(String docId, List<IcsDocnavDo> docNaviDtos) {
        HashedMap refPids = new HashedMap();
        for (IcsDocnavDo icsDocnavDo : docNaviDtos) {
            List<IcsPidDo> pIdsFromDocNav = this.getPidsFromDocNav(docId, icsDocnavDo.getDocnavId());
            pIdsFromDocNav.stream().filter(icsPidDo -> !StringUtils.equals((CharSequence)icsPidDo.getDocId(), (CharSequence)docId)).forEach(arg_0 -> IcsSearchSuggestBusinessHander.lambda$getRefPids$8((Map)refPids, arg_0));
        }
        return refPids;
    }

    private List<IcsPidDo> getPidsFromDocNav(String docId, String docNavId) {
        List<IcsDocnavTreeDto> icsDocNavTrees = IcsDocnavBusinessServiceHandler.getInstance().getNaviPid(docId, docNavId, "");
        ArrayList<IcsPidDo> icsPidDoList = new ArrayList<IcsPidDo>();
        for (IcsDocnavTreeDto docNavTreeDto : icsDocNavTrees) {
            List subPids = Optional.ofNullable(docNavTreeDto.getIcsPidSet()).orElseGet(HashSet::new).stream().filter(innerNavTreeDo -> StringUtils.equals((CharSequence)innerNavTreeDo.getType(), (CharSequence)"doc")).map(IcsDocnavTreeDto::getIcsPidDo).collect(Collectors.toList());
            icsPidDoList.addAll(subPids);
        }
        return icsPidDoList;
    }

    private void getReferenceData(String docId, String pidId, Set<IcsSearchSuggestWordDto> suggestWords) {
        List<IcsSearchSuggestWordDto> wordTimes = this.getSuggestTxt(docId);
        for (IcsSearchSuggestWordDto wordTime : wordTimes) {
            if (CollectionUtils.isEmpty(wordTime.getPidList()) || !wordTime.getPidList().contains(pidId)) continue;
            suggestWords.add(wordTime);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<IcsSearchSuggestWordDto> getSuggestTxt(String docId) {
        IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
        if (icsContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Not found relationContent{0}.", new Object[]{docId});
            return Collections.emptyList();
        }
        ArrayList<IcsSearchSuggestWordDto> wordTimeDescList = new ArrayList<IcsSearchSuggestWordDto>();
        File file = FileUtils.getFile((String[])new String[]{icsContentDo.getPath()});
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry("resources/infocenter_service/conf/suggest.txt");
            if (zipEntry == null) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "suggest.txt is not exists");
                ArrayList<IcsSearchSuggestWordDto> arrayList = wordTimeDescList;
                return arrayList;
            }
            this.getSuggestContent(wordTimeDescList, zipFile, zipEntry);
            return wordTimeDescList;
        }
        catch (FileNotFoundException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Exeception when create zipfile  error");
            return wordTimeDescList;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create zipFile getInputStream error", (Throwable)e);
        }
        return wordTimeDescList;
    }

    private void getSuggestContent(List<IcsSearchSuggestWordDto> wordTimeDescList, ZipFile zipFile, ZipEntry zipEntry) {
        try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(zipEntry), StandardCharsets.UTF_8);
             BufferedReader bufReader = new BufferedReader(reader);
             LineIterator lineIterator = new LineIterator((Reader)bufReader);){
            int nLine = 0;
            while (lineIterator.hasNext()) {
                int index;
                String lineInput = StringUtils.trim((String)lineIterator.next());
                if (StringUtils.isBlank((CharSequence)lineInput)) continue;
                int frequency = 1;
                if (++nLine == 1 && lineInput.charAt(0) == '\ufeff') {
                    lineInput = lineInput.substring(1);
                }
                if ((index = this.getPidListRightPos(lineInput)) < 0) {
                    this.getNotPidContent(wordTimeDescList, frequency, lineInput);
                    continue;
                }
                this.getPidContent(wordTimeDescList, frequency, lineInput, index);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getSuggestContent io ERROR !", (Throwable)e);
        }
    }

    private int getPidListRightPos(String lineInput) {
        int leftIndex = lineInput.lastIndexOf(" [");
        int rightIndex = lineInput.lastIndexOf("]");
        if (leftIndex != -1 && rightIndex != -1 && rightIndex == lineInput.length() - 1) {
            return rightIndex;
        }
        return -1;
    }

    private void getPidContent(List<IcsSearchSuggestWordDto> wordTimeDescList, int frequency, String lineInput, int index) {
        int separator = lineInput.lastIndexOf(" ");
        if (separator < 0) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Suggest word [{0}] is invalid.", new Object[]{lineInput});
            return;
        }
        String queryContent = lineInput.substring(0, separator).trim();
        int spaceIndex = queryContent.lastIndexOf(" ");
        int wordFrequency = frequency;
        String wordStr = lineInput;
        if (spaceIndex > 0) {
            wordFrequency = SearchSuggestBusinessDaoHandler.getInstance().getFrequency(queryContent, spaceIndex, frequency);
            wordStr = lineInput.substring(0, spaceIndex).trim();
        }
        String[] pidIdArray = lineInput.substring(separator + 2, index).split(";");
        IcsSearchSuggestWordDto wordTimeTmp = new IcsSearchSuggestWordDto(wordStr, wordFrequency, Arrays.asList(pidIdArray));
        wordTimeDescList.add(wordTimeTmp);
    }

    private void getNotPidContent(List<IcsSearchSuggestWordDto> wordTimeDescList, int frequency, String lineInput) {
        int splitPos = lineInput.lastIndexOf(" ");
        int wordFrequency = frequency;
        String wordStr = lineInput;
        if (splitPos > 0) {
            wordFrequency = SearchSuggestBusinessDaoHandler.getInstance().getFrequency(lineInput, splitPos, frequency);
            wordStr = lineInput.substring(0, splitPos).trim();
        }
        IcsSearchSuggestWordDto wordTimeTmp = new IcsSearchSuggestWordDto(wordStr, wordFrequency, null);
        wordTimeDescList.add(wordTimeTmp);
    }

    @Override
    public void deleteCachedSuggestWords(String docId) {
        IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
        if (icsContentDo == null) {
            return;
        }
        SearchSuggestBusinessDaoHandler.getInstance().deleteCache(docId);
        this.deleteCachedPids(docId, icsContentDo);
        List mainDocIdList = IcsVersionRelationPoolServiceHandler.getInstance().getMainDocIdList(docId);
        if (CollectionUtils.isEmpty((Collection)mainDocIdList)) {
            return;
        }
        for (String mainDocId : mainDocIdList) {
            SearchSuggestBusinessDaoHandler.getInstance().deleteCache(mainDocId);
            IcsContentDo referenceContentDo = IcsContentPoolServiceHandler.getInstance().get(mainDocId);
            if (referenceContentDo == null) continue;
            this.deleteCachedPids(mainDocId, referenceContentDo);
        }
    }

    private void deleteCachedPids(String docId, IcsContentDo icsContentDo) {
        List docNaviDtos = IcsDocnavPoolServiceHandler.getInstance().get(icsContentDo.getDocId());
        if (CollectionUtils.isEmpty((Collection)docNaviDtos)) {
            return;
        }
        this.getAllPIds(docId, docNaviDtos).forEach((key, value) -> value.forEach(item -> SearchSuggestBusinessDaoHandler.getInstance().deleteCache(key + item)));
    }

    private static /* synthetic */ void lambda$getRefPids$8(Map refPids, IcsPidDo icsPidDo) {
        refPids.computeIfAbsent(icsPidDo.getDocId(), v -> new HashSet()).add(icsPidDo.getPidId());
    }

    private static /* synthetic */ void lambda$getAllPIds$5(Map allPids, IcsPidDo icsPidDo) {
        allPids.computeIfAbsent(icsPidDo.getDocId(), v -> new HashSet()).add(icsPidDo.getPidId());
    }

    private static class IcsSearchSuggestBusinessHanderHolder {
        private static final IcsSearchSuggestBusinessHander INSTANCE = new IcsSearchSuggestBusinessHander();

        private IcsSearchSuggestBusinessHanderHolder() {
        }
    }
}

