/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.softwaremanage.enums;

import com.huawei.support.icslite.i18n.init.I18nResources;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public enum VerifyStatusEnum {
    WAIT_VERIFY(0, I18nResources.INSTANCE.getValueByKey("download.soft.status.verified.wait")),
    IN_VERIFICATION_QUEUE(1, I18nResources.INSTANCE.getValueByKey("download.soft.status.verified.queue")),
    VERIFYING(2, I18nResources.INSTANCE.getValueByKey("download.file.status.validate")),
    VERIFIED(3, I18nResources.INSTANCE.getValueByKey("download.soft.status.verified")),
    NO_FILE(11, I18nResources.INSTANCE.getValueByKey("download.soft.status.verified.no.file")),
    NO_SIGN_FILES(12, I18nResources.INSTANCE.getValueByKey("download.soft.status.verified.no.sign.files")),
    PGP_FAILED(13, VerifyStatusEnum.getMsg(false, "pgp")),
    CMS_FAILED(14, VerifyStatusEnum.getMsg(false, "cms")),
    CMS_SUCCEED_PGP_FAILED(15, VerifyStatusEnum.getMsg(true, false)),
    CMS_FAILED_PGP_SUCCEED(16, VerifyStatusEnum.getMsg(false, true)),
    CMS_PGP_FAILED(17, VerifyStatusEnum.getMsg(false, false));

    private static Map<Integer, String> STATUS_MAP;
    private final int status;
    private final String statusMsg;

    public static Map<Integer, String> getStatusMap() {
        return STATUS_MAP;
    }

    public static boolean isVerifying(int status) {
        return status == IN_VERIFICATION_QUEUE.getStatus() || status == VERIFYING.getStatus();
    }

    private static String getMsg(boolean verifyResult, String type) {
        return String.format(Locale.ROOT, I18nResources.INSTANCE.getValueByKey(verifyResult ? "download.file.verify.status.success" : "download.file.verify.status.failed"), type);
    }

    private static String getMsg(boolean cmsVerifyResult, boolean pgpVerifyResult) {
        return VerifyStatusEnum.getMsg(cmsVerifyResult, "cms") + I18nResources.INSTANCE.getValueByKey("common.symbol.comma") + VerifyStatusEnum.getMsg(pgpVerifyResult, "pgp");
    }

    private VerifyStatusEnum(int status, String statusMsg) {
        this.status = status;
        this.statusMsg = statusMsg;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    static {
        STATUS_MAP = Arrays.stream(VerifyStatusEnum.values()).collect(Collectors.toMap(VerifyStatusEnum::getStatus, VerifyStatusEnum::getStatusMsg));
    }
}

