/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.softwaremanage.service.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.date.DateUtils;
import com.huawei.support.icslite.business.softwaremanage.converter.SoftwareManageDirConverter;
import com.huawei.support.icslite.business.softwaremanage.dto.SoftwareManageDirDto;
import com.huawei.support.icslite.business.softwaremanage.enums.VerifyStatusEnum;
import com.huawei.support.icslite.business.softwaremanage.service.SoftwareManageDirBusiness;
import com.huawei.support.icslite.business.softwaremanage.service.impl.SoftwareManageFileBusinessHandler;
import com.huawei.support.icslite.download.dto.SoftwareManageDirDo;
import com.huawei.support.icslite.download.service.impl.SoftwareManageDirServiceHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SoftwareManageDirBusinessHandler
implements SoftwareManageDirBusiness {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(SoftwareManageDirBusinessHandler.class);
    private final Object LOCK = new Object();

    private SoftwareManageDirBusinessHandler() {
    }

    public static SoftwareManageDirBusinessHandler getInstance() {
        return SoftwareManageDirBusinessHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        SoftwareManageDirServiceHandler.getInstance().createTb();
    }

    @Override
    public SoftwareManageDirDto addDirAndFile(String path, String name) {
        SoftwareManageDirDto softwareManageDirDto = this.addDir(path, name);
        SoftwareManageFileBusinessHandler.getInstance().addFiles(softwareManageDirDto.getId(), path, "", VerifyStatusEnum.WAIT_VERIFY.getStatus());
        return softwareManageDirDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoftwareManageDirDto addDir(String path, String name) {
        Optional<SoftwareManageDirDto> dirByPath = this.getDirByPath(path);
        if (dirByPath.isPresent()) {
            return dirByPath.get();
        }
        Object object = this.LOCK;
        synchronized (object) {
            dirByPath = this.getDirByPath(path);
            if (dirByPath.isPresent()) {
                return dirByPath.get();
            }
            SoftwareManageDirDto softwareManageDirDto = this.createDirDto(path, name);
            SoftwareManageDirServiceHandler.getInstance().addDir(SoftwareManageDirConverter.INSTANCE.convertDtoToDo(softwareManageDirDto));
            return this.getDirByPath(path).get();
        }
    }

    private SoftwareManageDirDto createDirDto(String path, String name) {
        int count = SoftwareManageDirServiceHandler.getInstance().getTimesByName(name);
        String recordName = name;
        if (count > 0) {
            recordName = name + "(" + count + ")";
        }
        SoftwareManageDirDto softwareManageDirDto = new SoftwareManageDirDto();
        softwareManageDirDto.setPath(path);
        softwareManageDirDto.setName(recordName);
        softwareManageDirDto.setTimes(++count);
        softwareManageDirDto.setCreateTime(DateUtils.parseLongToString((long)System.currentTimeMillis()));
        return softwareManageDirDto;
    }

    @Override
    public List<SoftwareManageDirDto> getDirs() {
        List softwareManageDirDoList = SoftwareManageDirServiceHandler.getInstance().getDirs();
        return softwareManageDirDoList.stream().filter(Objects::nonNull).map(SoftwareManageDirConverter.INSTANCE::convertDoToDto).collect(Collectors.toList());
    }

    @Override
    public List<Integer> deleteDirs(List<Integer> dirIds, String type) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"0")) {
            SoftwareManageDirServiceHandler.getInstance().deleteDirs(dirIds);
            return Collections.emptyList();
        }
        ArrayList<Integer> deleteFailList = new ArrayList<Integer>();
        ArrayList<Integer> deleteSuccessList = new ArrayList<Integer>();
        for (int dirId : dirIds) {
            if (SoftwareManageFileBusinessHandler.getInstance().delFilesByDirId(dirId, type)) {
                File directory = FileUtils.getFile((String[])new String[]{SoftwareManageDirServiceHandler.getInstance().getPathById(dirId)});
                try {
                    FileUtils.deleteDirectory((File)directory);
                    deleteSuccessList.add(dirId);
                }
                catch (IOException e) {
                    CodeCCUtils.INSTANCE.errorLog(log, "Delete dir error, dirId is {0}", (Throwable)e, new Object[]{dirId});
                    deleteFailList.add(dirId);
                }
                continue;
            }
            deleteFailList.add(dirId);
        }
        if (CollectionUtils.isNotEmpty(deleteSuccessList)) {
            SoftwareManageDirServiceHandler.getInstance().deleteDirs(deleteSuccessList);
        }
        if (CollectionUtils.isNotEmpty(deleteFailList)) {
            CodeCCUtils.INSTANCE.infoLog(log, "Delete dir error, dir ids is {0}", new Object[]{((Object)deleteFailList).toString()});
        }
        return deleteFailList;
    }

    @Override
    public Optional<SoftwareManageDirDto> getDirByPath(String path) {
        SoftwareManageDirDo dirByPath = SoftwareManageDirServiceHandler.getInstance().getDirByPath(path);
        if (Objects.isNull(dirByPath)) {
            return Optional.empty();
        }
        return Optional.of(SoftwareManageDirConverter.INSTANCE.convertDoToDto(dirByPath));
    }

    private static class SoftwareManageDirBusinessHolder {
        private static final SoftwareManageDirBusinessHandler INSTANCE = new SoftwareManageDirBusinessHandler();

        private SoftwareManageDirBusinessHolder() {
        }
    }
}

