/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.softwaremanage.service.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.date.DateUtils;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icscbb.verify.service.lmpl.CMSVerifyServiceImpl;
import com.huawei.support.icscbb.verify.service.lmpl.PGPVerifyServiceImpl;
import com.huawei.support.icslite.business.common.util.WindowsUtils;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.business.softwaremanage.converter.SoftwareManageFileConverter;
import com.huawei.support.icslite.business.softwaremanage.dto.DirPathDto;
import com.huawei.support.icslite.business.softwaremanage.enums.VerifyStatusEnum;
import com.huawei.support.icslite.business.softwaremanage.service.SoftwareManageFileBusiness;
import com.huawei.support.icslite.business.softwaremanage.util.SoftwareManageUtils;
import com.huawei.support.icslite.business.softwaremanage.vo.SoftwareManageFileVo;
import com.huawei.support.icslite.download.dto.SoftwareManageFileDo;
import com.huawei.support.icslite.download.service.impl.SoftwareManageFileServiceHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SoftwareManageFileBusinessHandler
implements SoftwareManageFileBusiness {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(SoftwareManageFileBusinessHandler.class);
    private static final int QUEUE_MAX_CAPACITY = 1000;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final ThreadPoolExecutor VERIFY_POOL = ThreadPoolFactory.getThreadPool((String)"SoftwareManageVerifyExecutor", (int)10, (int)60, (int)20, (int)1000);
    private volatile boolean isVerifying = false;
    private ArrayBlockingQueue<Callable<Boolean>> verifyTaskQueue = new ArrayBlockingQueue(1000);
    private List<Future<Boolean>> verifyFutures = new ArrayList<Future<Boolean>>();

    private SoftwareManageFileBusinessHandler() {
    }

    public static SoftwareManageFileBusinessHandler getInstance() {
        return SoftwareManageFileBusinessHandlerHolder.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addDirFile(int dirId, String path, Path folder, Predicate<Path> addCondition) {
        try (Stream<Path> fileList = Files.list(folder);){
            fileList.filter(SoftwareManageUtils::isNormalFile).filter(file -> !StringUtils.endsWithAny((CharSequence)file.toString(), (CharSequence[])new CharSequence[]{".asc", ".p7s", ".info"})).filter(addCondition).forEach(file -> SoftwareManageFileServiceHandler.getInstance().addFiles(new SoftwareManageFileDo().setDirId(dirId).setPath(file.toString()).setName(file.getFileName().toString())));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to add files in the directory\uff1a{0}", (Throwable)e, new Object[]{path});
            return false;
        }
    }

    @Override
    public List<SoftwareManageFileVo> getFilesByDirId(int dirId) {
        return SoftwareManageFileServiceHandler.getInstance().getFilesByDirId(dirId).stream().map(SoftwareManageFileConverter.INSTANCE::convertDoToVo).collect(Collectors.toList());
    }

    @Override
    public boolean addFiles(int dirId, String path, String fileName, int fileStatus) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return SoftwareManageFileServiceHandler.getInstance().addFiles(new SoftwareManageFileDo().setDirId(dirId).setPath(path + File.separator + fileName).setVerifyTime(DateUtils.formatDateToString((Date)new Date(), (DateTimeFormatter)DATE_TIME_FORMATTER)).setName(fileName).setStatus(fileStatus));
        }
        Path folder = new File(path).toPath();
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            return false;
        }
        return this.addDirFile(dirId, path, folder, fullAdd -> true);
    }

    @Override
    public boolean refreshFileByDirId(DirPathDto dirPathDto) {
        SoftwareManageFileServiceHandler instance = SoftwareManageFileServiceHandler.getInstance();
        List fileDoList = instance.getFilesByDirId(dirPathDto.getDirId().intValue());
        List idList = fileDoList.stream().filter(fileDo -> !FileUtils.getFile((String[])new String[]{fileDo.getPath()}).exists()).map(SoftwareManageFileDo::getId).collect(Collectors.toList());
        boolean delStatus = CollectionUtils.isEmpty(idList) || instance.delFilesByIds(idList);
        List fileNameList = fileDoList.stream().map(SoftwareManageFileDo::getName).collect(Collectors.toList());
        boolean addStatus = this.addDirFile(dirPathDto.getDirId(), dirPathDto.getDirPath(), new File(dirPathDto.getDirPath()).toPath(), file -> !fileNameList.contains(file.getFileName().toString()));
        return delStatus || addStatus;
    }

    @Override
    public boolean openFileDir(int fileId) {
        SoftwareManageFileDo filesById = SoftwareManageFileServiceHandler.getInstance().getFileById(fileId);
        if (Objects.isNull(filesById)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Soft manage open dir, input file id has exception {0}", new Object[]{fileId});
            return false;
        }
        String filePath = filesById.getPath();
        if (WindowsUtils.openDirByPath(filePath, FileUtils.getFile((String[])new String[]{filePath}))) {
            return true;
        }
        return WindowsUtils.desktopOpenFile(FileUtils.getFile((String[])new String[]{StringUtils.substringBeforeLast((String)filePath, (String)File.separator)}));
    }

    @Override
    public boolean delFilesByIds(List<Integer> fileIds, String type) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"0")) {
            return SoftwareManageFileServiceHandler.getInstance().delFilesByIds(fileIds);
        }
        List<Integer> idList = this.delFile(SoftwareManageFileServiceHandler.getInstance().getFilesByIds(fileIds));
        if (CollectionUtils.isEmpty(idList)) {
            return false;
        }
        return SoftwareManageFileServiceHandler.getInstance().delFilesByIds(idList);
    }

    @Override
    public boolean delFilesByDirId(int dirId, String type) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"0")) {
            return SoftwareManageFileServiceHandler.getInstance().delFilesByDirId(dirId);
        }
        List fileList = SoftwareManageFileServiceHandler.getInstance().getFilesByDirId(dirId);
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return true;
        }
        return SoftwareManageFileServiceHandler.getInstance().delFilesByIds(this.delFile(fileList));
    }

    @Override
    public boolean verify(List<Integer> fileIds) {
        this.isVerifying = true;
        SoftwareManageFileServiceHandler instance = SoftwareManageFileServiceHandler.getInstance();
        instance.getFilesByIds(fileIds).forEach(fileDo -> {
            if (this.verifyTaskQueue.size() >= 1000) {
                return;
            }
            if (!this.addQueue(instance, (SoftwareManageFileDo)fileDo)) {
                CodeCCUtils.INSTANCE.errorLog(log, "The queue is full and add the task later.");
            }
        });
        VERIFY_POOL.execute(() -> {
            while (!this.verifyTaskQueue.isEmpty()) {
                this.verifyFutures.add(VERIFY_POOL.submit(this.verifyTaskQueue.poll()));
            }
        });
        return true;
    }

    private boolean addQueue(SoftwareManageFileServiceHandler instance, SoftwareManageFileDo fileDo) {
        return this.verifyTaskQueue.offer(() -> {
            SoftwareManageFileDo softwareManageFileDo = new SoftwareManageFileDo().setId(fileDo.getId()).setVerifyTime(DateUtils.formatDateToString((Date)new Date(), (DateTimeFormatter)DATE_TIME_FORMATTER));
            instance.updateFile(softwareManageFileDo.setStatus(VerifyStatusEnum.IN_VERIFICATION_QUEUE.getStatus()));
            return this.doVerify(fileDo.getPath(), softwareManageFileDo);
        });
    }

    @Override
    public boolean isVerifying() {
        if (!this.isVerifying) {
            this.verifyFutures.clear();
            return false;
        }
        boolean isAllDone = true;
        for (Future<Boolean> future : this.verifyFutures) {
            isAllDone = isAllDone && future.isDone();
        }
        this.isVerifying = !isAllDone;
        return this.isVerifying;
    }

    private boolean doVerify(String filePath, SoftwareManageFileDo fileDo) {
        SoftwareManageFileServiceHandler instance = SoftwareManageFileServiceHandler.getInstance();
        instance.updateFile(fileDo.setStatus(VerifyStatusEnum.VERIFYING.getStatus()));
        if (!FileUtils.getFile((String[])new String[]{filePath}).exists()) {
            instance.updateFile(fileDo.setStatus(VerifyStatusEnum.NO_FILE.getStatus()));
            return false;
        }
        String ascFilePath = filePath + ".asc";
        String p7sFilePath = filePath + ".p7s";
        boolean isAscFileExists = FileUtils.getFile((String[])new String[]{ascFilePath}).exists();
        boolean isP7sFileExists = FileUtils.getFile((String[])new String[]{p7sFilePath}).exists();
        if (!isAscFileExists && !isP7sFileExists) {
            instance.updateFile(fileDo.setStatus(VerifyStatusEnum.NO_SIGN_FILES.getStatus()));
            return false;
        }
        boolean ascVerifyResult = PGPVerifyServiceImpl.getInstance().verify(isAscFileExists ? ascFilePath : "", filePath);
        boolean p7sVerifyResult = CMSVerifyServiceImpl.getInstance().verify(isP7sFileExists ? p7sFilePath : "", filePath);
        String resultStr = this.getStr(isAscFileExists) + this.getStr(isP7sFileExists) + this.getStr(ascVerifyResult) + this.getStr(p7sVerifyResult);
        int statusByStr = SoftwareManageUtils.getStatusByStr(resultStr);
        instance.updateFile(fileDo.setStatus(statusByStr));
        return statusByStr == VerifyStatusEnum.VERIFIED.getStatus();
    }

    private String getStr(boolean flag) {
        return flag ? "1" : "0";
    }

    private List<Integer> delFile(List<SoftwareManageFileDo> fileList) {
        return fileList.stream().filter(fileDo -> this.deleteActualFile(fileDo.getPath())).map(SoftwareManageFileDo::getId).collect(Collectors.toList());
    }

    private boolean deleteActualFile(String filePath) {
        return DownloadManangeUtils.deleteFile(FileUtils.getFile((String[])new String[]{filePath})) && DownloadManangeUtils.deleteFile(FileUtils.getFile((String[])new String[]{filePath + ".asc"})) && DownloadManangeUtils.deleteFile(FileUtils.getFile((String[])new String[]{filePath + ".p7s"}));
    }

    private static class SoftwareManageFileBusinessHandlerHolder {
        private static final SoftwareManageFileBusinessHandler INSTANCE = new SoftwareManageFileBusinessHandler();

        private SoftwareManageFileBusinessHandlerHolder() {
        }
    }
}

