/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.softwaremanage.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.softwaremanage.enums.VerifyStatusEnum;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SoftwareManageUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(SoftwareManageUtils.class);
    private static final Map<String, Integer> VERIFY_STATUS_MAP = new HashMap<String, Integer>();

    public static int getStatusByStr(String inputStr) {
        Integer status = VERIFY_STATUS_MAP.get(inputStr);
        if (Objects.isNull(status)) {
            CodeCCUtils.INSTANCE.infoLog(log, "Get result has empty, please check input, {0}", new Object[]{inputStr});
            return VerifyStatusEnum.CMS_PGP_FAILED.getStatus();
        }
        return status;
    }

    public static boolean isNormalFile(Path path) {
        File file = path.toFile();
        return Files.isRegularFile(path, new LinkOption[0]) && !file.isHidden() && !StringUtils.startsWith((CharSequence)file.getName(), (CharSequence)"~$");
    }

    static {
        VERIFY_STATUS_MAP.put("1111", VerifyStatusEnum.VERIFIED.getStatus());
        VERIFY_STATUS_MAP.put("1010", VerifyStatusEnum.VERIFIED.getStatus());
        VERIFY_STATUS_MAP.put("0101", VerifyStatusEnum.VERIFIED.getStatus());
        VERIFY_STATUS_MAP.put("1100", VerifyStatusEnum.CMS_PGP_FAILED.getStatus());
        VERIFY_STATUS_MAP.put("1110", VerifyStatusEnum.CMS_FAILED_PGP_SUCCEED.getStatus());
        VERIFY_STATUS_MAP.put("1101", VerifyStatusEnum.CMS_SUCCEED_PGP_FAILED.getStatus());
        VERIFY_STATUS_MAP.put("1000", VerifyStatusEnum.CMS_FAILED.getStatus());
        VERIFY_STATUS_MAP.put("0100", VerifyStatusEnum.PGP_FAILED.getStatus());
    }
}

