/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.softwaresearch.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.util.HttpUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.common.util.HoupHttpsUtils;
import com.huawei.support.icslite.business.softwaresearch.dto.ProductSuggestDto;
import com.huawei.support.icslite.business.softwaresearch.dto.SoftwareApplyDto;
import com.huawei.support.icslite.business.softwaresearch.dto.SoftwareSearchDto;
import com.huawei.support.icslite.business.softwaresearch.service.SoftwareSearchBusiness;
import com.huawei.support.icslite.business.softwaresearch.vo.FileInfoVo;
import com.huawei.support.icslite.business.softwaresearch.vo.ProductLineVo;
import com.huawei.support.icslite.business.softwaresearch.vo.ProductSuggestVo;
import com.huawei.support.icslite.business.softwaresearch.vo.ProductVo;
import com.huawei.support.icslite.business.softwaresearch.vo.VersionInfoVo;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SoftwareSearchBusinessHandler
implements SoftwareSearchBusiness {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(SoftwareSearchBusinessHandler.class);

    private SoftwareSearchBusinessHandler() {
    }

    public static SoftwareSearchBusinessHandler getInstance() {
        return SoftwareSearchBusinessHolder.INSTANCE;
    }

    @Override
    public List<ProductLineVo> getProductLine(String domain) {
        String response = HoupHttpsUtils.doGetByCert(UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", "icslite.houp.softwarelist.productline.url") + "?domain=" + domain, this.getLangHeader());
        if (StringUtils.isBlank((CharSequence)response)) {
            return Collections.emptyList();
        }
        return JSONArray.parseArray((String)response, ProductLineVo.class);
    }

    @Override
    public List<ProductVo> getProduct(String domain, String productLineId) {
        String response = HoupHttpsUtils.doGetByCert(UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", "icslite.houp.softwarelist.product.url") + "?domain=" + domain + "&productLineId=" + productLineId, this.getLangHeader());
        if (StringUtils.isBlank((CharSequence)response)) {
            return Collections.emptyList();
        }
        return JSONArray.parseArray((String)response, ProductVo.class);
    }

    @Override
    public VersionInfoVo getVersion(String productId, String productName) {
        String inputStr = HttpUtils.encode((String)productName);
        if (StringUtils.isBlank((CharSequence)inputStr)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Soft ware search has exception, input str is {0}", new Object[]{inputStr});
            return new VersionInfoVo();
        }
        String response = HoupHttpsUtils.doGetByCert(UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", "icslite.houp.softwarelist.version.url") + "?productId=" + productId + "&productName=" + inputStr, null);
        return (VersionInfoVo)JSON.parseObject((String)response, VersionInfoVo.class);
    }

    @Override
    public FileInfoVo getSoftware(SoftwareSearchDto softwareSearchDto) {
        Map<String, String> searchMap = this.getSearchMap(softwareSearchDto.getDomain(), softwareSearchDto.getProductId(), softwareSearchDto.getVersionId(), softwareSearchDto.getVersionName(), softwareSearchDto.getProductLineId());
        searchMap.put("productName", softwareSearchDto.getProductName());
        String response = HoupHttpsUtils.doPostByCert(UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", "icslite.houp.softwarelist.software.url"), searchMap, this.getLangHeader());
        return (FileInfoVo)JSON.parseObject((String)response, FileInfoVo.class);
    }

    @Override
    public String getSoftwareApply(SoftwareApplyDto softwareApplyDto) {
        Map<String, String> searchMap = this.getSearchMap(softwareApplyDto.getDomain(), softwareApplyDto.getProductId(), softwareApplyDto.getVersionId(), softwareApplyDto.getVersionName(), softwareApplyDto.getProductLineId());
        searchMap.put("nid", softwareApplyDto.getNid());
        return StringUtils.replace((String)HoupHttpsUtils.doPostByCert(UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", "icslite.houp.softwarelist.software.apply.url"), searchMap, this.getLangHeader()), (String)"\"", (String)"");
    }

    private Map<String, String> getSearchMap(String domain, String productId, String versionId, String versionName, String productLineId) {
        HashMap<String, String> searchMap = new HashMap<String, String>();
        searchMap.put("domain", domain);
        searchMap.put("productId", this.convertToPbiId(domain, productId));
        searchMap.put("versionId", this.convertToPbiId(domain, versionId));
        searchMap.put("versionName", versionName);
        searchMap.put("productLineId", this.convertToPbiId(domain, productLineId));
        return searchMap;
    }

    private String convertToPbiId(String domain, String nodeId) {
        return StringUtils.startsWith((CharSequence)nodeId, (CharSequence)"PBI") ? nodeId : "PBI" + this.convertDomain(domain) + "-" + nodeId;
    }

    private String convertDomain(String domain) {
        if (StringUtils.equals((CharSequence)domain, (CharSequence)"1")) {
            return "2";
        }
        return "1";
    }

    @Override
    public List<ProductSuggestVo> getSuggestProduct(String keyword, Integer size, String domain) {
        String inputStr = HttpUtils.encode((String)keyword);
        if (StringUtils.isBlank((CharSequence)inputStr)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Soft ware search has exception, input str is {0}", new Object[]{inputStr});
            return Collections.emptyList();
        }
        String response = HoupHttpsUtils.doGetByCert(UrlDataServiceHandler.getInstance().getUrlFromSceneAndKey("HOUP.NGINX", "icslite.houp.softwarelist.productsuggest.url") + "?domain=" + domain + "&keyword=" + inputStr + (size == null ? "" : "&size=" + size), this.getLangHeader());
        if (StringUtils.isBlank((CharSequence)response)) {
            return Collections.emptyList();
        }
        return JSONArray.parseArray((String)response).stream().map(suggestProduct -> {
            ProductSuggestDto productSuggestDto = (ProductSuggestDto)JSON.parseObject((String)suggestProduct.toString(), ProductSuggestDto.class);
            return ProductSuggestVo.builder().productLineName(productSuggestDto.getProductLine().getProductLineName()).productLineId(productSuggestDto.getProductLine().getProductLineId()).productName(productSuggestDto.getProduct().getProductName()).productId(productSuggestDto.getProduct().getProductId()).build();
        }).collect(Collectors.toList());
    }

    private Map<String, String> getLangHeader() {
        return Collections.singletonMap("lang", ConfigServiceHandler.getInstance().get("system.lang"));
    }

    private static class SoftwareSearchBusinessHolder {
        private static final SoftwareSearchBusinessHandler INSTANCE = new SoftwareSearchBusinessHandler();

        private SoftwareSearchBusinessHolder() {
        }
    }
}

