/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgrade.serviceimpl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.CustomSslException;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icscbb.util.response.ResultCode;
import com.huawei.support.icscbb.util.response.ServiceResponse;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icslite.business.common.dto.UrlDataDto;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkConnServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.schedule.util.ScheduleUtils;
import com.huawei.support.icslite.business.upgrade.dao.SoftUpgradeDao;
import com.huawei.support.icslite.business.upgrade.dto.SoftUpgradeDto;
import com.huawei.support.icslite.business.upgrade.message.SoftUpgradeMessage;
import com.huawei.support.icslite.business.upgrade.service.UpgradeBusiness;
import com.huawei.support.icslite.business.upgrade.task.UpgradeTask;
import com.huawei.support.icslite.business.upgrade.thread.SoftUpgradeThread;
import com.huawei.support.icslite.business.upgrade.thread.SoftwareUpgradeManageThread;
import com.huawei.support.icslite.business.upgrade.tip.UpgradeRestartTip;
import com.huawei.support.icslite.business.upgrade.tip.UpgradeTip;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.upgrade.constant.UpgradeAtomConstants;
import com.huawei.support.icslite.upgrade.dto.UpgradeInfoDto;
import com.huawei.support.icslite.upgrade.service.impl.UpgradeFileServiceHandler;
import com.huawei.support.icslite.upgrade.service.impl.UpgradeServiceHandler;
import com.huawei.support.icslite.upgrade.util.GetFileSha256;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UpgradeBusinessHandler
implements UpgradeBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(UpgradeBusinessHandler.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyy-MM-dd");
    private static final String UPGRADE_DIR = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade" + File.separator;
    private static final AsyncEventBus EVENT_BUS = EventBusUtils.INSTANCE.getEventBus();
    private static final String SYSTEM_32 = "32";
    private static final String SYSTEM_64 = "64";
    private static final String SYSTEM_TYPE_CARRIER = "1";
    private static final String SYSTEM_TYPE_ENTERPRISE = "2";
    private String upgradeMsg = "";
    private String lowVersionMsg = "";

    private UpgradeBusinessHandler() {
        EVENT_BUS.register((Object)this);
    }

    public static UpgradeBusinessHandler getInstance() {
        return UpgradeBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public UpgradeInfoDto checkUpgradeInfo() {
        try {
            HttpClientDto httpClientForHuawei = NetworkServiceHandler.getInstance().getHttpClientForHuawei();
            String downloadFileUrl = this.getDownloadFileUrl(httpClientForHuawei);
            String lowVersionStr = UrlDataServiceHandler.getInstance().getUrlEntry(null, "clientLowVersion", false);
            UpgradeInfoDto upgradeInfoDto = UpgradeServiceHandler.getInstance().checkUpgradeInfo(httpClientForHuawei, downloadFileUrl, lowVersionStr);
            upgradeInfoDto.setUse(SoftwareUpgradeManageThread.getInstance().isUse());
            return upgradeInfoDto;
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "NetWorkSwitchException. failed to get the httpClient.", (Throwable)e);
            return null;
        }
    }

    private String getDownloadFileUrl(HttpClientDto httpClient) {
        UrlDataDto urlDataDto = UrlDataServiceHandler.getInstance().getUrl(httpClient, this.getUpgradeKey(), true);
        String downloadFileUrl = "";
        if (urlDataDto != null) {
            downloadFileUrl = urlDataDto.getMainUrl();
        }
        CodeCCUtils.INSTANCE.infoLog(LOG, "Get download upgrade lite soft url is {0}", new Object[]{downloadFileUrl});
        return downloadFileUrl;
    }

    private String getUpgradeKey() {
        String lang = ConfigServiceHandler.getInstance().get("system.lang");
        String systemBits = ConfigServiceHandler.getInstance().getOrSetDefault("system.operate.bits", this.getSystemBits());
        if (StringUtils.equals((CharSequence)lang, (CharSequence)"en")) {
            if (StringUtils.equals((CharSequence)systemBits, (CharSequence)SYSTEM_64)) {
                return "ClientUpgrade_en_64";
            }
            return "ClientUpgrade_en_V2";
        }
        if (StringUtils.equals((CharSequence)systemBits, (CharSequence)SYSTEM_64)) {
            return "ClientUpgrade_zh_64";
        }
        return "ClientUpgrade_zh_V2";
    }

    private String getSystemBits() {
        String wmicOsGetOsarchitecture = SystemCommandUtils.cmdExec((String)"wmic os get osarchitecture");
        String[] split = wmicOsGetOsarchitecture.split(System.lineSeparator());
        if (split.length <= 1) {
            return SYSTEM_32;
        }
        return StringUtils.contains((CharSequence)split[1], (CharSequence)SYSTEM_64) ? SYSTEM_64 : SYSTEM_32;
    }

    @Override
    public String getLiteCurrentVersion() {
        return IcsCommonServiceHandler.getInstance().getAppVersion();
    }

    @Override
    public void upgradeProcess(boolean restartNow) {
        SoftUpgradeDao.remove();
        SoftUpgradeDto softUpgradeDto = this.initUpgradeTask();
        softUpgradeDto.setRestartNow(restartNow);
        SoftUpgradeDao.addSoftUpgradeTask(softUpgradeDto);
        SoftwareUpgradeManageThread.getInstance().toStart();
    }

    private SoftUpgradeDto initUpgradeTask() {
        SoftUpgradeDto softUpgradeDto = new SoftUpgradeDto();
        softUpgradeDto.setUpgradeStatus("0");
        return softUpgradeDto;
    }

    @Override
    public void openUpgrader() {
        OperationLogUtils.INSTANCE.successOperationLog("icslite-upgrade-service", "UPGRADE", "operate restart button succeed.");
        ScheduleUtils.cancelRestartRemindSchedule();
        UpgradeServiceHandler.getInstance().openUpgrader();
    }

    @Override
    public void upgradeInfoSchedule() {
        UpgradeInfoDto upgradeInfoDto;
        if (NetworkConnServiceHandler.getInstance().isClosed()) {
            this.setOfflineTime();
            CodeCCUtils.INSTANCE.infoLog(LOG, "Networking is not enabled.");
            return;
        }
        try {
            upgradeInfoDto = this.checkUpgradeInfo();
        }
        catch (CustomSslException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "upgradeInfoSchedule has CustomSslException", (Throwable)e);
            return;
        }
        if (ObjectUtils.isEmpty((Object)upgradeInfoDto)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "checkUpgradeInfo upgradeInfoDto is null");
        }
        if (StringUtils.equals((CharSequence)upgradeInfoDto.getCheckError(), (CharSequence)SYSTEM_TYPE_CARRIER)) {
            this.setOfflineTime();
            CodeCCUtils.INSTANCE.errorLog(LOG, "The software upgrade detection is abnormal.");
            return;
        }
        this.delOfflineTime();
        if (upgradeInfoDto.isLowVersion() && this.isMatchConfigRole()) {
            this.setLowVersionMsg("true");
            CodeCCUtils.INSTANCE.infoLog(LOG, "Schedule check upgrade info and current version is low version.");
        } else {
            this.resetLowVersionMsg();
        }
        if (upgradeInfoDto.isAutoUpgrade() && upgradeInfoDto.isChanged()) {
            this.setUpgradeMsg(upgradeInfoDto.getReleaseNote());
            CodeCCUtils.INSTANCE.infoLog(LOG, "Upgrade push, a new version is available.");
            return;
        }
        this.resetUpgradeMsg();
    }

    @Override
    public boolean isMatchConfigRole() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String systemType = this.getSystemType();
        paramMap.put("systemType", systemType);
        String upgradeMatchRoleUrl = UrlDataServiceHandler.getInstance().getUrlFromConfig("UpgradeRoleMatch");
        CodeCCUtils.INSTANCE.infoLog(LOG, "Upgrade send request check configured roles, the url is {0}, the systemType is {1}.", new Object[]{upgradeMatchRoleUrl, systemType});
        Optional<ServiceResponse<Object>> response = this.sendPostRequest(upgradeMatchRoleUrl, paramMap);
        if (!response.isPresent() || response.get().getCode() == ResultCode.ERROR.getReusltCode()) {
            return true;
        }
        return (Boolean)response.get().getData();
    }

    private String getSystemType() {
        String scene = ConfigServiceHandler.getInstance().get("system.ics.scene");
        return StringUtils.equalsIgnoreCase((CharSequence)scene, (CharSequence)"support") ? SYSTEM_TYPE_CARRIER : SYSTEM_TYPE_ENTERPRISE;
    }

    private Optional<ServiceResponse<Object>> sendPostRequest(String url, Map<String, String> param) {
        if (StringUtils.isBlank((CharSequence)url)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Send post request but url is blank.");
            return Optional.empty();
        }
        try {
            HttpClientDto clientDto;
            String result;
            HttpClientDto.Builder clientDtoBuilder = NetworkServiceHandler.getInstance().getHttpClientForHuawei().newBuilder().url(url);
            if (MapUtils.isNotEmpty(param)) {
                clientDtoBuilder.params(param);
            }
            if (StringUtils.isNotBlank((CharSequence)(result = NetWorkUtil.post((HttpClientDto)(clientDto = clientDtoBuilder.build()))))) {
                Map responseMap = JsonUtils.stringToMap((String)result);
                return Optional.of(ServiceResponse.getServiceResponse((String)((String)responseMap.get("msg")), (int)((Integer)responseMap.get("code")), responseMap.get("data")));
            }
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Send post request but network switch is not open", (Throwable)e);
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Send post request but get response error", (Throwable)e);
        }
        return Optional.empty();
    }

    private void delOfflineTime() {
        ConfigServiceHandler.getInstance().set("isOffline", "false");
        ConfigServiceHandler.getInstance().remove("offlineTime");
        CodeCCUtils.INSTANCE.infoLog(LOG, "Delete long offline time info.");
    }

    private void setOfflineTime() {
        String lastOfflineDay = ConfigServiceHandler.getInstance().get("offlineTime");
        if (StringUtils.isBlank((CharSequence)lastOfflineDay)) {
            ConfigServiceHandler.getInstance().set("offlineTime", LocalDate.now().format(DATE_TIME_FORMATTER));
            ConfigServiceHandler.getInstance().set("isOffline", "false");
            CodeCCUtils.INSTANCE.infoLog(LOG, "Set current time as offline time.");
            return;
        }
        LocalDate initLocalDate = LocalDate.parse(lastOfflineDay, DATE_TIME_FORMATTER);
        long offlineDays = LocalDate.now().toEpochDay() - initLocalDate.toEpochDay();
        if (offlineDays > (long)this.getOverLimitDays()) {
            ConfigServiceHandler.getInstance().set("isOffline", "true");
            CodeCCUtils.INSTANCE.infoLog(LOG, "Offline {0} days,set long time offline flag.", new Object[]{offlineDays});
        }
    }

    @Override
    public void upgradeRestartSchedule() {
        UpgradeRestartTip.getInstance().showRestartDialog();
    }

    @Override
    public String getUpgradeMsg() {
        return this.upgradeMsg;
    }

    private void setUpgradeMsg(String upgradeMsg) {
        this.upgradeMsg = upgradeMsg;
    }

    @Override
    public String getLowVersionMsg() {
        return this.lowVersionMsg;
    }

    private void setLowVersionMsg(String lowVersionMsg) {
        this.lowVersionMsg = lowVersionMsg;
    }

    @Override
    public void resetUpgradeMsg() {
        this.upgradeMsg = "";
    }

    @Override
    public void resetLowVersionMsg() {
        this.lowVersionMsg = "";
    }

    @Override
    public boolean isPush() {
        String upgradeMessage = this.getUpgradeMsg();
        boolean isExists = StringUtils.isNotBlank((CharSequence)upgradeMessage);
        if (isExists) {
            this.resetUpgradeMsg();
            UpgradeTip.getInstance().init(upgradeMessage);
        }
        return isExists;
    }

    @Override
    public boolean updateLowVersionConfig(String lowVersionFlag) {
        return ConfigServiceHandler.getInstance().set("isLowVersion", lowVersionFlag);
    }

    @Override
    public int getLongOfflineDays() {
        int result = this.getOverLimitDays();
        String initOfflineDay = ConfigServiceHandler.getInstance().get("offlineTime");
        if (StringUtils.isBlank((CharSequence)initOfflineDay)) {
            return result;
        }
        LocalDate initLocalDate = LocalDate.parse(initOfflineDay, DATE_TIME_FORMATTER);
        long spaceDay = LocalDate.now().toEpochDay() - initLocalDate.toEpochDay();
        if (spaceDay > 0L) {
            result = (int)spaceDay;
        }
        return result;
    }

    @Override
    public void openNetworkCheckUpgrade() {
        NetworkConnServiceHandler.getInstance().updateNetworkSwitchStatus(SYSTEM_TYPE_CARRIER);
        this.upgradeInfoSchedule();
    }

    @Override
    public void collectUserClientInfo() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String systemType = this.getSystemType();
        paramMap.put("clientId", this.getClientId());
        paramMap.put("clientVersion", IcsCommonServiceHandler.getInstance().getAppVersion());
        paramMap.put("softwareName", this.getSoftwareName());
        paramMap.put("systemType", systemType);
        String collectLogUrl = UrlDataServiceHandler.getInstance().getUrlFromConfig("UserCollectLog");
        CodeCCUtils.INSTANCE.infoLog(LOG, "Upgrade send request collect log, the url is {0}, the systemType is {1}.", new Object[]{collectLogUrl, systemType});
        Optional<ServiceResponse<Object>> response = this.sendPostRequest(collectLogUrl, paramMap);
        if (!response.isPresent() || response.get().getCode() == ResultCode.ERROR.getReusltCode()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Send request collect log but error.");
            return;
        }
        if (((Boolean)response.get().getData()).booleanValue()) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Send request collect log success.");
            return;
        }
        CodeCCUtils.INSTANCE.errorLog(LOG, "Send request collect log but fail.");
    }

    private String getClientId() {
        String lang = ConfigServiceHandler.getInstance().get("system.lang");
        String clientIdFilePath = IcsCommonServiceHandler.getInstance().getSysProgramDataPath() + lang + CommonConstants.CLIENT_MARK;
        return IcsFileUtils.readFileContent((String)clientIdFilePath, null);
    }

    private String getSoftwareName() {
        String lang = ConfigServiceHandler.getInstance().get("system.lang");
        if (StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)"zh")) {
            return "ICSLite_zh.zip";
        }
        return "ICSLite_en.zip";
    }

    private int getOverLimitDays() {
        return Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)UrlDataServiceHandler.getInstance().getUrlEntry(null, "longOfflineTime", false), (CharSequence)"90"));
    }

    @Override
    public int getSoftUpgradeCount() {
        return SoftUpgradeDao.getSoftUpgradeCount();
    }

    @Override
    public int getSoftErrorCount() {
        return SoftUpgradeDao.getSoftErrorCount();
    }

    @Override
    public int getCompletedCount() {
        return SoftUpgradeDao.getCompletedCount();
    }

    @Override
    public void init() {
        SoftwareUpgradeManageThread.getInstance().start();
    }

    private boolean refreshNewUrlData(SoftUpgradeDto softUpgradeDto) {
        JSONObject heartData = UpgradeFileServiceHandler.getInstance().getJsonData(CommonConstants.UPGRADE_URL_DATA_JSON);
        if (MapUtils.isEmpty((Map)heartData)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "local upgrade.json file doesn't exist");
            this.changeToErrorStatus(softUpgradeDto);
            return true;
        }
        return false;
    }

    private void changeToErrorStatus(SoftUpgradeDto softUpgradeDto) {
        softUpgradeDto.setErrorCode("40");
    }

    private void validateSoftwareProcess(SoftUpgradeDto softUpgradeDto) {
        String filePath = UPGRADE_DIR + softUpgradeDto.getSoftVersion();
        String downLoadFilePath = filePath + File.separator + softUpgradeDto.getFileName();
        String downloadFlag = GetFileSha256.checkSha256Code((String)softUpgradeDto.getClientIntegrityCode(), (String)downLoadFilePath);
        softUpgradeDto.setProgressPercent("96");
        if (StringUtils.equals((CharSequence)downloadFlag, (CharSequence)"40")) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Validate software process and the SHA256 verification failed.");
            File softVersionDir = FileUtils.getFile((String[])new String[]{filePath});
            try {
                IcsFileUtils.deleteFile((File)softVersionDir);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "delete downloaded zip file failed.", (Throwable)e);
            }
            this.changeToErrorStatus(softUpgradeDto);
            return;
        }
        if (!StringUtils.equals((CharSequence)downloadFlag, (CharSequence)"20")) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Validate software process and the SHA256 verification not success.");
            return;
        }
        downloadFlag = UpgradeServiceHandler.getInstance().unZipProcess(filePath, softUpgradeDto.getFileName());
        if (StringUtils.equals((CharSequence)downloadFlag, (CharSequence)"40")) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Validate software process and unzip fail.");
            this.changeToErrorStatus(softUpgradeDto);
        }
        softUpgradeDto.setProgressPercent("98");
    }

    private void upgradeJreProcess(SoftUpgradeDto softUpgradeDto) {
        String upgraderJrePath = IcsCommonServiceHandler.getInstance().getUpgraderJavaHomeDir();
        IcsCommonServiceHandler.getInstance().exitUpgrader();
        File file = FileUtils.getFile((String[])new String[]{upgraderJrePath});
        if (file.exists()) {
            try {
                CodeCCUtils.INSTANCE.infoLog(LOG, "Jre of upgrader/jre exists need to delete,and jre path is {0}.", new Object[]{upgraderJrePath});
                IcsFileUtils.deleteFile((File)file);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "delete jre failed.", (Throwable)e);
                this.changeToErrorStatus(softUpgradeDto);
                return;
            }
        }
        String serverJrePath = IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgradeAtomConstants.SERVER_JRE_DIR;
        File jreFile = FileUtils.getFile((String[])new String[]{serverJrePath});
        if (!jreFile.exists()) {
            this.changeToErrorStatus(softUpgradeDto);
            return;
        }
        try {
            IcsFileUtils.copyDirectory((String)serverJrePath, (String)upgraderJrePath);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "upgrade jre copy failed.", (Throwable)e);
            this.changeToErrorStatus(softUpgradeDto);
        }
        softUpgradeDto.setProgressPercent("99");
    }

    private void createUpgradeOperateFile(SoftUpgradeDto softUpgradeDto) {
        String upgradeFilePath = UPGRADE_DIR + softUpgradeDto.getSoftVersion();
        File upgradeFile = FileUtils.getFile((String[])new String[]{UPGRADE_DIR + "upgradeOperate.txt"});
        if (upgradeFile.exists()) {
            return;
        }
        try {
            if (!upgradeFile.createNewFile()) {
                UpgradeServiceHandler.getInstance().deleteUpgradeFile(upgradeFilePath);
                CodeCCUtils.INSTANCE.errorLog(LOG, "Upgrade operate file create failed.");
                this.changeToErrorStatus(softUpgradeDto);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create UpgradeOperate.txt file failed.", (Throwable)e);
            UpgradeServiceHandler.getInstance().deleteUpgradeFile(upgradeFilePath);
            this.changeToErrorStatus(softUpgradeDto);
        }
        softUpgradeDto.setProgressPercent("100");
        if (softUpgradeDto.isRestartNow()) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Soft downloaded success and will restart automatically.");
            IcsCommonServiceHandler.getInstance().startUpgrader();
            return;
        }
        EVENT_BUS.post((Object)new SoftUpgradeMessage("softDownLoaded"));
    }

    @Override
    public SoftUpgradeDto getProcess() {
        return SoftUpgradeDao.getSoftUpgradeData();
    }

    @Override
    public boolean isUse() {
        return SoftwareUpgradeManageThread.getInstance().isUse();
    }

    @Override
    public void countPercent(SoftUpgradeDto softUpgradeDto) {
        if (softUpgradeDto.getSoftUpgradeThread() == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)softUpgradeDto.getUpgradeStatus(), (CharSequence)SYSTEM_TYPE_ENTERPRISE)) {
            long currentPoint = softUpgradeDto.getSoftUpgradeThread().getCurrentPoint();
            long fileSize = softUpgradeDto.getSoftUpgradeThread().getFileSize();
            softUpgradeDto.setDownloadSize(currentPoint);
            softUpgradeDto.setFileSize(fileSize);
            softUpgradeDto.setProgressPercent(this.getSoftDownloadPercent(currentPoint, fileSize));
        }
    }

    @Override
    public void errorHandler(SoftUpgradeDto softUpgradeDto) {
        if (softUpgradeDto.getSoftUpgradeThread() == null) {
            return;
        }
        if (softUpgradeDto.getSoftUpgradeThread().hasError()) {
            softUpgradeDto.setErrorCode("40");
            CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to obtain the upgrade progress thread data.");
        }
    }

    private String getSoftDownloadPercent(long currentPoint, long fileSize) {
        if (currentPoint == 0L) {
            return "0";
        }
        BigDecimal upgradePercent = new BigDecimal(currentPoint).multiply(new BigDecimal("95")).divide(new BigDecimal(fileSize), 0, RoundingMode.HALF_UP);
        return String.valueOf(upgradePercent.intValue());
    }

    @Override
    public void downloadUpgrader(SoftUpgradeDto softUpgradeDto) {
        HttpClientDto httpClient;
        if (!StringUtils.equals((CharSequence)softUpgradeDto.getUpgradeStatus(), (CharSequence)"0")) {
            return;
        }
        softUpgradeDto.setProgressPercent("0");
        softUpgradeDto.setUpgradeStatus(SYSTEM_TYPE_CARRIER);
        try {
            httpClient = NetworkServiceHandler.getInstance().getHttpClientForHuawei();
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Download upgrader but occurred netWorkSwitchException, failed to get the httpClient.", (Throwable)e);
            this.changeToErrorStatus(softUpgradeDto);
            return;
        }
        String systemBits = ConfigServiceHandler.getInstance().getOrSetDefault("system.operate.bits", this.getSystemBits());
        String liteUpgraderUrl = UrlDataServiceHandler.getInstance().getUrlFromConfig(StringUtils.equals((CharSequence)systemBits, (CharSequence)SYSTEM_64) ? "LiteUpgrader_64" : "LiteUpgrader_V3");
        CodeCCUtils.INSTANCE.infoLog(LOG, "Get upgrader download url is {0}", new Object[]{liteUpgraderUrl});
        String downloadDomainUrl = UrlDataServiceHandler.getInstance().getDomainByScene("DOWNLOAD.NGINX");
        String downloadState = UpgradeServiceHandler.getInstance().upgraderUpdateOperation(httpClient, downloadDomainUrl, liteUpgraderUrl);
        if (StringUtils.equals((CharSequence)"40", (CharSequence)downloadState)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Download upgrader fail when upgrader update operation,the upgrader url is {0}.", new Object[]{liteUpgraderUrl});
            this.changeToErrorStatus(softUpgradeDto);
        }
        softUpgradeDto.setUpgradeStatus(SYSTEM_TYPE_ENTERPRISE);
    }

    @Override
    public void downloadSoftWare(SoftUpgradeDto softUpgradeDto) {
        if (softUpgradeDto.isStart()) {
            return;
        }
        if (!UpgradeServiceHandler.getInstance().isFreeSpace()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "the local disk space is insufficient.");
            softUpgradeDto.setErrorCode("46");
            return;
        }
        softUpgradeDto.setStart(true);
        if (this.refreshNewUrlData(softUpgradeDto)) {
            return;
        }
        JSONObject clientUpgradeJson = UpgradeFileServiceHandler.getInstance().getJsonData(CommonConstants.SERVER_UPGRADE_PATH);
        if (MapUtils.isNotEmpty((Map)clientUpgradeJson)) {
            softUpgradeDto.setSoftVersion(clientUpgradeJson.getString("clientVersion"));
            softUpgradeDto.setDownloadUrl(UrlDataServiceHandler.getInstance().getDomainByScene("DOWNLOAD.NGINX") + clientUpgradeJson.getString("clientDownLoadUrl.v2"));
            softUpgradeDto.setClientIntegrityCode(clientUpgradeJson.getString("clientIntegrityCode"));
            softUpgradeDto.setFileName(clientUpgradeJson.getString("clientName"));
        }
        String filePath = UPGRADE_DIR + softUpgradeDto.getSoftVersion() + File.separator + softUpgradeDto.getFileName();
        SoftUpgradeThread softUpgradeThread = new SoftUpgradeThread(softUpgradeDto.getDownloadUrl(), filePath);
        softUpgradeThread.start();
        softUpgradeDto.setSoftUpgradeThread(softUpgradeThread);
    }

    @Override
    public void upgradeOthersProcess(SoftUpgradeDto softUpgradeDto) {
        if (softUpgradeDto.getSoftUpgradeThread() == null) {
            return;
        }
        if (softUpgradeDto.isValidate()) {
            return;
        }
        if (!softUpgradeDto.getSoftUpgradeThread().isOver()) {
            return;
        }
        CodeCCUtils.INSTANCE.infoLog(LOG, "The software package is downloaded.");
        softUpgradeDto.setUpgradeStatus("3");
        softUpgradeDto.setValidate(true);
        this.validateSoftwareProcess(softUpgradeDto);
        if (StringUtils.isNotBlank((CharSequence)softUpgradeDto.getErrorCode())) {
            return;
        }
        this.upgradeJreProcess(softUpgradeDto);
        if (StringUtils.isNotBlank((CharSequence)softUpgradeDto.getErrorCode())) {
            return;
        }
        this.createUpgradeOperateFile(softUpgradeDto);
    }

    @Subscribe
    public void receiveSoftUpgradeMessage(SoftUpgradeMessage softUpgradeMessage) {
        if (StringUtils.equals((CharSequence)softUpgradeMessage.getEventType(), (CharSequence)"softDownLoaded")) {
            ScheduleUtils.startUpgradeRestartSchedule(UpgradeTask.getInstance().getUpgradeRestartRunnable());
            return;
        }
        UpgradeRestartTip.getInstance().showRestartDialog();
    }

    private static class UpgradeBusinessHandlerHolder {
        private static final UpgradeBusinessHandler INSTANCE = new UpgradeBusinessHandler();

        private UpgradeBusinessHandlerHolder() {
        }
    }
}

