/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgrade.task;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgrade.service.UpgradeBusiness;
import org.apache.commons.lang3.StringUtils;

public class UpgradeTask {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(UpgradeTask.class);
    private UpgradeBusiness upgradeBusiness = (UpgradeBusiness)SpringContextUtil.getBean((String)"upgradeBusiness");

    private UpgradeTask() {
    }

    public static UpgradeTask getInstance() {
        return UpgradeTaskHandler.INSTANCE;
    }

    public Runnable getUpgradeInfoRunnable() {
        return this::upgradeInfoCheck;
    }

    private void upgradeInfoCheck() {
        CodeCCUtils.INSTANCE.infoLog(LOG, "UpgradeInfoTimerTask start");
        this.upgradeBusiness.upgradeInfoSchedule();
        String lowVersionMsg = this.upgradeBusiness.getLowVersionMsg();
        if (StringUtils.equals((CharSequence)lowVersionMsg, (CharSequence)"true")) {
            this.upgradeBusiness.resetLowVersionMsg();
            this.upgradeBusiness.updateLowVersionConfig(lowVersionMsg);
        } else {
            this.upgradeBusiness.updateLowVersionConfig("false");
        }
        CodeCCUtils.INSTANCE.infoLog(LOG, "UpgradeInfoTimerTask end upgradeMsg {0}", new Object[]{this.upgradeBusiness.getUpgradeMsg()});
    }

    public Runnable getUpgradeRestartRunnable() {
        return () -> {
            CodeCCUtils.INSTANCE.infoLog(LOG, "UpgradeRestartRunnable start");
            this.upgradeBusiness.upgradeRestartSchedule();
        };
    }

    private static class UpgradeTaskHandler {
        private static final UpgradeTask INSTANCE = new UpgradeTask();

        private UpgradeTaskHandler() {
        }
    }
}

