/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgrade.thread;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.dto.HttpHeaderDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class SoftUpgradeThread
extends Thread {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SoftUpgradeThread.class);
    private static final int BYTE_DEFAULT_SIZE = 1024;
    private String downloadUrl;
    private String downloadPath;
    private long currentPoint;
    private long fileSize;
    private boolean isOver;
    private boolean hasError;

    public SoftUpgradeThread(String downloadUrl, String downloadPath) {
        super.setName("SoftUpgradeThread");
        this.setUncaughtExceptionHandler((thisThread, exception) -> CodeCCUtils.INSTANCE.errorLog(LOGGER, thisThread.getName(), exception));
        this.downloadPath = downloadPath;
        this.downloadUrl = downloadUrl;
    }

    @Override
    public void run() {
        HttpClientDto httpClientDto;
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "SoftUpgradeThread is started.");
        try {
            httpClientDto = NetworkServiceHandler.getInstance().getHttpClientDefault().newBuilder().url(this.downloadUrl).build();
            Optional<HttpHeaderDto> httpHeaderDto = Optional.ofNullable(NetWorkUtil.getHeaders((HttpClientDto)httpClientDto));
            if (!httpHeaderDto.isPresent()) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Software upgrade, but HttpClientDto is null.");
                this.hasError = true;
                return;
            }
            this.fileSize = httpHeaderDto.get().getSize();
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Software upgrade, but connect failed.", (Throwable)e);
            this.hasError = true;
            return;
        }
        File file = FileUtils.getFile((String[])new String[]{this.downloadPath});
        try (InputStream inputStream = NetWorkUtil.getInputStream((HttpClientDto)httpClientDto);
             FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)file);){
            int readByte;
            if (inputStream == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Software upgrade, but InputStream is null.");
                this.hasError = true;
                return;
            }
            byte[] bytes = new byte[1024];
            while ((readByte = inputStream.read(bytes)) > 0) {
                fileOutputStream.write(bytes, 0, readByte);
                this.currentPoint += (long)readByte;
            }
            if (this.currentPoint >= this.fileSize) {
                this.isOver = true;
            }
        }
        catch (DownloadException | IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Software upgrade, but get InputStream error.", e);
            this.hasError = true;
        }
    }

    public long getCurrentPoint() {
        return this.currentPoint;
    }

    public boolean isOver() {
        return this.isOver;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean hasError() {
        return this.hasError;
    }
}

