/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgrade.thread;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgrade.dao.SoftUpgradeDao;
import com.huawei.support.icslite.business.upgrade.dto.SoftUpgradeDto;
import com.huawei.support.icslite.business.upgrade.service.UpgradeBusiness;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SoftwareUpgradeManageThread
extends Thread {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(SoftwareUpgradeManageThread.class);
    private volatile boolean isUse = true;
    private Lock upgradeManageLock = new ReentrantLock();
    private Condition upgradeManageCondition = this.upgradeManageLock.newCondition();

    private SoftwareUpgradeManageThread() {
        super.setName("SoftwareUpgradeManage");
        this.setUncaughtExceptionHandler((thisThread, exception) -> CodeCCUtils.INSTANCE.errorLog(LOG, thisThread.getName(), exception));
    }

    public static SoftwareUpgradeManageThread getInstance() {
        return SoftwareUpgradeManageThreadHandler.INSTANCE;
    }

    public void toStart() {
        this.signal();
    }

    private void signal() {
        this.upgradeManageLock.lock();
        this.isUse = true;
        try {
            this.upgradeManageCondition.signal();
        }
        finally {
            this.upgradeManageLock.unlock();
        }
    }

    public boolean isUse() {
        return this.isUse;
    }

    @Override
    public void run() {
        CodeCCUtils.INSTANCE.infoLog(LOG, "SoftwareUpgradeManageThread Thread run start");
        while (true) {
            if (this.isStop()) {
                this.upgradeManageLock.lock();
                this.isUse = false;
                try {
                    this.upgradeManageCondition.await();
                }
                catch (InterruptedException e) {
                    CodeCCUtils.INSTANCE.errorLog(LOG, "await: ", (Throwable)e);
                }
                finally {
                    this.upgradeManageLock.unlock();
                }
            }
            try {
                SoftUpgradeDto softUpgradeDto = SoftUpgradeDao.getSoftUpgradeData();
                this.refreshData(softUpgradeDto);
                continue;
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "refresh data exception.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private boolean isStop() {
        UpgradeBusiness upgradeBusiness = (UpgradeBusiness)SpringContextUtil.getBean((String)"upgradeBusiness");
        return upgradeBusiness.getSoftUpgradeCount() == 0 || upgradeBusiness.getSoftErrorCount() != 0 || upgradeBusiness.getCompletedCount() != 0;
    }

    private void refreshData(SoftUpgradeDto softUpgradeDto) {
        UpgradeBusiness upgradeBusiness = (UpgradeBusiness)SpringContextUtil.getBean((String)"upgradeBusiness");
        upgradeBusiness.countPercent(softUpgradeDto);
        upgradeBusiness.errorHandler(softUpgradeDto);
        upgradeBusiness.downloadUpgrader(softUpgradeDto);
        upgradeBusiness.downloadSoftWare(softUpgradeDto);
        upgradeBusiness.upgradeOthersProcess(softUpgradeDto);
    }

    private static class SoftwareUpgradeManageThreadHandler {
        private static final SoftwareUpgradeManageThread INSTANCE = new SoftwareUpgradeManageThread();

        private SoftwareUpgradeManageThreadHandler() {
        }
    }
}

