/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgrade.tip;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ScrollBarUi
extends BasicScrollBarUI {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(ScrollBarUi.class);
    private static final int HANDLE_WIDTH = 7;
    private static final float OPAQUE = 1.0f;
    private static final Color HANDLE_COLOR = new Color(226, 226, 227);
    private static final Color HANDLE_COLOR_FROM = new Color(193, 193, 193);
    private static final Color HANDLE_COLOR_TO = new Color(193, 193, 193);
    private static final Color BACK_COLOR_FROM = new Color(255, 255, 255);
    private static final Color BACK_COLOR_TO = new Color(255, 255, 255);

    @Override
    protected void configureScrollBarColors() {
        this.setThumbBounds(0, 0, 3, 10);
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        component.setPreferredSize(new Dimension(7, 7));
        return super.getPreferredSize(component);
    }

    @Override
    public void paintTrack(Graphics graphics, JComponent component, Rectangle trackBounds) {
        if (!(graphics instanceof Graphics2D)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Forced type conversion failed.");
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = null;
        if (this.scrollbar.getOrientation() == 1) {
            gradientPaint = new GradientPaint(0.0f, 0.0f, BACK_COLOR_FROM, 0.0f, trackBounds.height, BACK_COLOR_TO);
        }
        if (this.scrollbar.getOrientation() == 0) {
            gradientPaint = new GradientPaint(0.0f, 0.0f, BACK_COLOR_FROM, trackBounds.width, 0.0f, BACK_COLOR_TO);
        }
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(graphics);
        }
        if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(graphics);
        }
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent component, Rectangle handleBounds) {
        graphics.translate(handleBounds.x, handleBounds.y);
        graphics.setColor(HANDLE_COLOR);
        graphics.drawRoundRect(0, 0, handleBounds.width - 1, handleBounds.height - 1, 5, 5);
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.addRenderingHints(renderingHints);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setPaint(new GradientPaint((float)component.getWidth() / 2.0f, 1.0f, HANDLE_COLOR_FROM, (float)component.getWidth() / 2.0f, component.getHeight(), HANDLE_COLOR_TO));
        graphics2D.fillRoundRect(0, 0, handleBounds.width - 1, handleBounds.height - 1, 5, 5);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        JButton button = new JButton();
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setBorder(null);
        return button;
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        JButton button = new JButton();
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusable(false);
        button.setBorder(null);
        return button;
    }
}

