/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgrade.tip;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.awt.Window;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class UpgradeRestartTip {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(UpgradeRestartTip.class);
    private static final ThreadPoolExecutor UPGRADE_RESTART_THREAD_POOL = ThreadPoolFactory.getThreadPool((String)"UpgradeRestart", (int)1, (int)600, (int)1, (int)5);
    private static final AtomicBoolean IS_SHOW_RESTART_DIALOG = new AtomicBoolean(Boolean.TRUE);
    private JFrame frame;
    private JButton[] buttons;

    private UpgradeRestartTip() {
        this.initFrame();
        this.initButtons();
    }

    public static UpgradeRestartTip getInstance() {
        return UpgradeRestartTipHandler.INSTANCE;
    }

    private void initFrame() {
        this.setWindowsUiStyle();
        this.frame = new JFrame();
        this.frame.setAlwaysOnTop(true);
        this.frame.setVisible(false);
    }

    private void setWindowsUiStyle() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "UpgradeRestartTip set UI style error.", (Throwable)e);
        }
    }

    private void initButtons() {
        JButton restartNowButton = new JButton(I18nResources.INSTANCE.getValueByKey("upgrade.restart.now.button.content"));
        this.restartNowEvent(restartNowButton);
        JButton restartLaterButton = new JButton(I18nResources.INSTANCE.getValueByKey("upgrade.restart.later.button.content"));
        this.restartLaterEvent(restartLaterButton);
        this.buttons = new JButton[]{restartNowButton, restartLaterButton};
    }

    private void restartNowEvent(JButton restartNowButton) {
        restartNowButton.addActionListener(event -> {
            OperationLogUtils.INSTANCE.successOperationLog("icslite-upgrade-service", "UPGRADE", "operate restartNowButton succeed.");
            this.disposeWindow(restartNowButton);
            IcsCommonServiceHandler.getInstance().startUpgrader();
        });
    }

    private void restartLaterEvent(JButton restartLaterButton) {
        restartLaterButton.addActionListener(event -> {
            OperationLogUtils.INSTANCE.successOperationLog("icslite-upgrade-service", "UPGRADE", "operate restartLaterButton succeed.");
            this.disposeWindow(restartLaterButton);
        });
    }

    public void showRestartDialog() {
        if (IS_SHOW_RESTART_DIALOG.compareAndSet(true, false)) {
            UPGRADE_RESTART_THREAD_POOL.execute(() -> {
                int optionStatus = JOptionPane.showOptionDialog(this.frame, I18nResources.INSTANCE.getValueByKey("upgrade.restart.tip.content"), I18nResources.INSTANCE.getValueByKey("upgrade.restart.tip.title"), 1, 2, null, this.buttons, this.buttons[0]);
                if (optionStatus == -1) {
                    IS_SHOW_RESTART_DIALOG.set(true);
                }
            });
        }
    }

    private void disposeWindow(JButton button) {
        Window win = SwingUtilities.getWindowAncestor(button);
        if (win != null) {
            win.dispose();
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    private static class UpgradeRestartTipHandler {
        private static final UpgradeRestartTip INSTANCE = new UpgradeRestartTip();

        private UpgradeRestartTipHandler() {
        }
    }
}

