/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgrade.tip;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.schedule.util.ScheduleUtils;
import com.huawei.support.icslite.business.upgrade.constant.I18nUpgradeTipConstants;
import com.huawei.support.icslite.business.upgrade.task.UpgradeTask;
import com.huawei.support.icslite.business.upgrade.tip.CloseButton;
import com.huawei.support.icslite.business.upgrade.tip.RoundBorder;
import com.huawei.support.icslite.business.upgrade.tip.ScrollBarUi;
import com.huawei.support.icslite.business.upgrade.tip.ShadowPanel;
import com.huawei.support.icslite.common.resources.utils.LiteCommonUtils;
import com.huawei.support.icslite.common.utils.ValidateUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.wsf.core.HWDecoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.lang3.StringUtils;

public class UpgradeTip
implements I18nUpgradeTipConstants,
Serializable {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(UpgradeTip.class);
    private static final long serialVersionUID = 768388626270219354L;
    private static final int WIDTH = 430;
    private static final int HEIGHT = 210;
    private static final int STEP = 30;
    private static final int STEP_TIME = 30;
    private ToolTipSingle toolTipSingle = new ToolTipSingle();
    private int countOfToolTip = 0;
    private int startVerticalPosition;
    private int stopVerticalPosition;
    private int posx;
    private int maxToolTip = 0;

    public static UpgradeTip getInstance() {
        return UpgradeTipHandler.INSTANCE;
    }

    private boolean getUpgradeWindow() {
        boolean isAnimate;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle screenRect = ge.getMaximumWindowBounds();
        this.posx = screenRect.width - 430 - 10;
        int screenHeight = screenRect.height;
        if (this.countOfToolTip > 0) {
            if (this.startVerticalPosition != screenHeight) {
                this.toolTipSingle.setVisible(true);
                this.startVerticalPosition = screenHeight;
                this.showWindow();
            }
            return Boolean.FALSE;
        }
        this.startVerticalPosition = screenHeight;
        this.stopVerticalPosition = this.startVerticalPosition - 210 - 5;
        int maxToolTipScreen = screenHeight / 210;
        this.toolTipSingle.setLocation(this.posx, screenHeight);
        this.toolTipSingle.setVisible(true);
        boolean bl = isAnimate = screenRect.y <= 0;
        if (isAnimate) {
            this.startVerticalPosition = screenHeight;
            this.stopVerticalPosition = this.startVerticalPosition - 210 - 5;
            if (this.countOfToolTip > 0) {
                this.stopVerticalPosition -= this.maxToolTip % maxToolTipScreen * 210;
            } else {
                this.maxToolTip = 0;
            }
        } else {
            this.startVerticalPosition = screenRect.y - 210;
            this.stopVerticalPosition = screenRect.y;
            if (this.countOfToolTip > 0) {
                this.stopVerticalPosition += this.maxToolTip % maxToolTipScreen * 210;
            } else {
                this.maxToolTip = 0;
            }
        }
        ++this.countOfToolTip;
        return Boolean.TRUE;
    }

    private void showWindow() {
        try {
            this.animateVertically(this.startVerticalPosition, this.stopVerticalPosition);
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Tooltip up occur exception.", (Throwable)e);
        }
    }

    private void animateVertically(int startVertical, int endVertical) throws InterruptedException {
        this.toolTipSingle.setLocation(this.posx, startVertical);
        if (endVertical < startVertical) {
            for (int i = startVertical; i > endVertical; i -= 30) {
                this.toolTipSingle.setLocation(this.posx, i);
                TimeUnit.MILLISECONDS.sleep(30L);
            }
        } else {
            for (int i = startVertical; i < endVertical; i += 30) {
                this.toolTipSingle.setLocation(this.posx, i);
                TimeUnit.MILLISECONDS.sleep(30L);
            }
        }
        this.toolTipSingle.setLocation(this.posx, endVertical);
    }

    private void initStartVerticalPosition() {
        this.startVerticalPosition = 0;
    }

    public void openToolTip(String title, String msg) {
        this.toolTipSingle.dlgTitle.setText(title);
        this.toolTipSingle.dlgEditorPane.setText(msg);
        this.toolTipSingle.resetScroll();
        this.toolTipSingle.animate();
    }

    public void init(String message) {
        ThreadPoolExecutor commonThreadPool = ThreadPoolFactory.getThreadPool((String)"common", (int)2, (int)300, (int)10, (int)100);
        commonThreadPool.execute(() -> this.openToolTip(I18nResources.INSTANCE.getValueByKey("upgrade.tip.title.describ"), HWDecoder.decodeForHTML((String)((String)StringUtils.defaultIfBlank((CharSequence)message, (CharSequence)"")))));
    }

    class Animation {
        Animation() {
        }

        private void cancelOperate() {
            UpgradeTip.this.toolTipSingle.dlgCloseButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Animation.this.cancelAction(mouseEvent);
                }
            });
        }

        private void cancelAction(MouseEvent mouseEvent) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "CancelAction start");
            if (UpgradeTip.this.startVerticalPosition == 0) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "CancelAction startVerticalPosition is 0");
                return;
            }
            try {
                UpgradeTip.this.animateVertically(UpgradeTip.this.stopVerticalPosition, UpgradeTip.this.startVerticalPosition);
                UpgradeTip.this.toolTipSingle.setVisible(false);
                UpgradeTip.this.toolTipSingle.dispose();
                UpgradeTip.this.initStartVerticalPosition();
                if (mouseEvent != null) {
                    OperationLogUtils.INSTANCE.successOperationLog("icslite-upgrade-service", "UPGRADE", "Use close the upgrade tip window.");
                } else {
                    CodeCCUtils.INSTANCE.infoLog(LOG, "System close the upgrade tip window.");
                }
            }
            catch (InterruptedException interruptedException) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Tooltip down occur exception.", (Throwable)interruptedException);
            }
            ScheduleUtils.startUpgradeCheck(UpgradeTask.getInstance().getUpgradeInfoRunnable());
            CodeCCUtils.INSTANCE.infoLog(LOG, "CancelAction end");
        }

        public void init() {
            boolean isVisible = UpgradeTip.this.getUpgradeWindow();
            if (!isVisible) {
                return;
            }
            UpgradeTip.this.showWindow();
            this.cancelOperate();
        }
    }

    class ToolTipSingle
    extends JWindow {
        private static final long serialVersionUID = 1L;
        private static final int SCROLL_BAR_INIT_POSITION = 0;
        private static final String DEFAULT_EN_FONT = "Arial";
        private final JButton confirmBtn = new JButton();
        private final CloseButton dlgCloseButton = this.getCloseBtn();
        private String defaultFont = "Microsoft YaHei";
        private final JTextArea dlgTitle = this.getTitleArea();
        private final JEditorPane dlgEditorPane = this.getEditorPane();
        private final JScrollPane dlgContentPane = this.getScrollPane(this.dlgEditorPane);

        ToolTipSingle() {
            this.initComponents();
        }

        private void initComponents() {
            String liteLanguage = ConfigServiceHandler.getInstance().get("system.lang");
            if (StringUtils.equals((CharSequence)liteLanguage, (CharSequence)"en")) {
                this.defaultFont = DEFAULT_EN_FONT;
            }
            this.setAlwaysOnTop(true);
            this.setSize(430, 210);
            this.setConfirmBtnStyle();
            JPanel innerPanel = new JPanel();
            innerPanel.setBackground(Color.WHITE);
            innerPanel.setLayout(null);
            innerPanel.add(this.dlgCloseButton);
            innerPanel.add(this.dlgTitle);
            innerPanel.add(this.dlgContentPane);
            ShadowPanel externalPanel = new ShadowPanel(4);
            externalPanel.add(innerPanel);
            externalPanel.add((Component)this.getConfirmPanel(), "South");
            this.getContentPane().add(externalPanel);
            this.listenConfirmOperateEvent();
            this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.05f));
        }

        private void listenConfirmOperateEvent() {
            this.confirmBtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    String httpPort;
                    String httpIp = ConfigServiceHandler.getInstance().get("system.open.httpIpInfo");
                    if (!ValidateUtils.validateIpAndPort((String)httpIp, (String)(httpPort = ConfigServiceHandler.getInstance().get("system.http.port")))) {
                        return;
                    }
                    LiteCommonUtils.openHtml((String)("http://" + httpIp + ":" + httpPort + "/icslite/sys/preferences?id=upgrade#upgrade=tip"));
                    UpgradeTip.this.toolTipSingle.setVisible(false);
                    UpgradeTip.this.toolTipSingle.dispose();
                    UpgradeTip.this.initStartVerticalPosition();
                    OperationLogUtils.INSTANCE.successOperationLog("icslite-upgrade-service", "UPGRADE", "Go to the upgrade page for upgrading.");
                }
            });
        }

        private JPanel getConfirmPanel() {
            JPanel confirmPanel = new JPanel(new GridLayout(1, 4));
            confirmPanel.setBackground(Color.WHITE);
            confirmPanel.setLayout(new FlowLayout(2, 10, 10));
            confirmPanel.add(new Label(""));
            confirmPanel.add(new Label(""));
            confirmPanel.add(new Label(""));
            confirmPanel.add((Component)this.confirmBtn, "East");
            return confirmPanel;
        }

        private JTextArea getTitleArea() {
            JTextArea title = new JTextArea();
            title.setBounds(15, 8, 390, 24);
            title.setFont(new Font(this.defaultFont, 1, 15));
            return title;
        }

        private JEditorPane getEditorPane() {
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setEditable(false);
            jEditorPane.setContentType("text/html");
            jEditorPane.setFont(new Font(this.defaultFont, 0, 13));
            jEditorPane.addHyperlinkListener(event -> {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    LiteCommonUtils.openHtml((String)String.valueOf(event.getURL()));
                }
            });
            return jEditorPane;
        }

        private JScrollPane getScrollPane(JEditorPane jEditorPane) {
            JScrollPane scrollPane = new JScrollPane(jEditorPane);
            scrollPane.setBounds(12, 32, 390, 125);
            scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.getVerticalScrollBar().setUI(new ScrollBarUi());
            return scrollPane;
        }

        private void resetScroll() {
            if (this.dlgContentPane.getVerticalScrollBar().getValue() > 0) {
                this.dlgContentPane.getVerticalScrollBar().setValue(0);
            }
        }

        private CloseButton getCloseBtn() {
            final CloseButton closeButton = new CloseButton();
            closeButton.setPreferredSize(new Dimension(20, 20));
            closeButton.setBounds(395, 10, 30, 30);
            closeButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    closeButton.setCursor(Cursor.getPredefinedCursor(12));
                }
            });
            return closeButton;
        }

        private void setConfirmBtnStyle() {
            this.confirmBtn.setHideActionText(true);
            this.confirmBtn.setFont(new Font(this.defaultFont, 1, 13));
            this.confirmBtn.setBorder(new RoundBorder(Color.WHITE, 8, true));
            this.confirmBtn.setBackground(new Color(0, 153, 204));
            this.confirmBtn.setForeground(Color.WHITE);
            this.confirmBtn.setPreferredSize(new Dimension(80, 30));
            this.confirmBtn.setCursor(Cursor.getPredefinedCursor(12));
            this.confirmBtn.setText(I18nResources.INSTANCE.getValueByKey("upgrade.tip.button.describ"));
        }

        public void animate() {
            Animation animation = new Animation();
            animation.init();
            try {
                TimeUnit.MINUTES.sleep(2L);
            }
            catch (InterruptedException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Animation sleep InterruptedException", (Throwable)e);
            }
            animation.cancelAction(null);
        }
    }

    private static class UpgradeTipHandler {
        private static final UpgradeTip INSTANCE = new UpgradeTip();

        private UpgradeTipHandler() {
        }
    }
}

