/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelib.concurrent;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icslite.business.onlinelib.service.OnlineQueryBusiness;
import com.huawei.support.icslite.business.upgradelib.entity.convertors.UpgradeCompareConverter;
import com.huawei.support.icslite.business.upgradelib.entity.dto.UpgradeDocInfoDto;
import com.huawei.support.icslite.business.upgradelib.entity.dto.UpgradeThreadParameterDto;
import com.huawei.support.icslite.business.upgradelib.entity.message.UpgradeLibProcessingMessage;
import com.huawei.support.icslite.business.upgradelib.upgradefilter.UpgradeFilterChain;
import com.huawei.support.icslite.business.upgradelib.util.UpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class UpgradeThreadAbstract
implements Callable<Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>>> {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(UpgradeThreadAbstract.class);
    private final UpgradeThreadParameterDto upgradeThreadParameterDto;
    private final boolean isNeedUpgradePercent;

    public UpgradeThreadAbstract(UpgradeThreadParameterDto upgradeThreadParameterDto, boolean isNeedUpgradePercent) {
        this.upgradeThreadParameterDto = upgradeThreadParameterDto;
        this.isNeedUpgradePercent = isNeedUpgradePercent;
    }

    @Override
    public Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> call() {
        Set<UpgradeDocInfoDto> allOnlineContentDo = this.getAllOnlineContentDo();
        if (CollectionUtils.isEmpty(allOnlineContentDo)) {
            return new HashMap<UpgradeDocInfoDto, List<UpgradeDocInfoDto>>();
        }
        ArrayList<UpgradeDocInfoDto> onlineLibs = new ArrayList<UpgradeDocInfoDto>(allOnlineContentDo);
        onlineLibs.removeIf(onlineLib -> {
            onlineLib.setUniqueId();
            return this.upgradeThreadParameterDto.getLocalUniqueIdSet().contains(onlineLib.getUniqueId());
        });
        List<CompareLibDto> compareLibDtos = UpgradeCompareConverter.INSTANCE.convertCompareLibList(onlineLibs);
        Map<String, List<CompareLibDto>> onlineSeriesLib = this.serialString(compareLibDtos);
        UpgradeFilterChain onlineLibFilterChain = new UpgradeFilterChain();
        return onlineLibFilterChain.handler(this.upgradeThreadParameterDto.getLocalUpgradeContentMap(), onlineSeriesLib, false);
    }

    public abstract Map<String, List<CompareLibDto>> serialString(List<CompareLibDto> var1);

    private Set<UpgradeDocInfoDto> getAllOnlineContentDo() {
        List<String> prodNames = this.upgradeThreadParameterDto.getProdNames();
        HashSet<UpgradeDocInfoDto> allOnlineContentDo = new HashSet<UpgradeDocInfoDto>();
        for (String prodName : prodNames) {
            if (!this.isFailGetOnlineDocInfos(prodName, allOnlineContentDo)) continue;
            return new HashSet<UpgradeDocInfoDto>();
        }
        return allOnlineContentDo;
    }

    private boolean isFailGetOnlineDocInfos(String queryParam, Set<UpgradeDocInfoDto> allOnlineContentDo) {
        OnlineQueryBusiness onlineQueryBusiness = (OnlineQueryBusiness)SpringContextUtil.getBean((String)"onlineQueryBusiness");
        Map<String, Object> documents = onlineQueryBusiness.getDocumentsWhenUpgrade(queryParam, "", this.upgradeThreadParameterDto.getLang(), this.upgradeThreadParameterDto.getDomainType());
        if (MapUtils.isEmpty(documents)) {
            return true;
        }
        String code = (String)StringUtils.defaultIfBlank((CharSequence)documents.get("code").toString(), (CharSequence)"-1");
        if (this.sendMessage(code)) {
            UpgradeUtils.getUpgradesByDocuments(allOnlineContentDo, documents);
            return false;
        }
        return true;
    }

    public boolean sendMessage(String code) {
        if (this.isNeedUpgradePercent) {
            float progress = (float)this.upgradeThreadParameterDto.getCurSize() / (float)this.upgradeThreadParameterDto.getSumSize() * 100.0f;
            EventBusUtils.INSTANCE.getEventBus().post((Object)new UpgradeLibProcessingMessage(Math.round(progress), "1", code, null));
        }
        if (StringUtils.equals((CharSequence)code, (CharSequence)"0")) {
            return true;
        }
        CodeCCUtils.INSTANCE.warnLog(LOG, " network code :{0} --->getHdxOnlineContentDo network exception", new Object[]{code});
        return false;
    }
}

