/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelib.service.impl;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.libmanage.service.LibManageService;
import com.huawei.support.icslite.business.upgradelib.entity.convertors.EarlierDocInfoConvert;
import com.huawei.support.icslite.business.upgradelib.entity.convertors.UpgradeCompareConverter;
import com.huawei.support.icslite.business.upgradelib.entity.dto.UpgradeDocInfoDto;
import com.huawei.support.icslite.business.upgradelib.entity.vo.EarlierDocInfoVo;
import com.huawei.support.icslite.business.upgradelib.service.EarlierLibBusiness;
import com.huawei.support.icslite.business.upgradelib.service.impl.UpgradeLibBusinessHandler;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.enums.HdxAutoUpdate;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.localfilter.LocalHdxLibFilter;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.localfilter.LocalIcsLibFilter;
import com.huawei.support.icslite.business.upgradelibcommon.util.VersionUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class EarlierLibBusinessHandler
implements EarlierLibBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(EarlierLibBusinessHandler.class);
    private static final LocalHdxLibFilter LOCAL_HDX_LIB_FILTER = new LocalHdxLibFilter();
    private static final LocalIcsLibFilter LOCAL_ICS_LIB_FILTER = new LocalIcsLibFilter();
    private static final AtomicBoolean EXIST_EARLIER_VERSION_LIB = new AtomicBoolean(Boolean.FALSE);

    public static EarlierLibBusinessHandler getInstance() {
        return EarlierLibBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public boolean existEarlierVersionLib() {
        return EXIST_EARLIER_VERSION_LIB.get();
    }

    public void scheduleUpdateEarlierExist() {
        CodeCCUtils.INSTANCE.infoLog(LOG, "schedule start updateEarlierExist");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)ConfigServiceHandler.getInstance().getOrSetDefault("reminderStatus", "0"))) {
            return;
        }
        if (MapUtils.isEmpty(this.earlierLibList())) {
            return;
        }
        if (EXIST_EARLIER_VERSION_LIB.compareAndSet(false, true)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Schedule can not update earlier status,status is true");
        }
    }

    @Override
    public Map<String, List<EarlierDocInfoVo>> earlierLibList() {
        EXIST_EARLIER_VERSION_LIB.set(false);
        HashMap<String, List<CompareLibDto>> resultMap = new HashMap<String, List<CompareLibDto>>();
        this.addHwicsEarlierDocs(resultMap);
        this.addHedexEarlierDocs(resultMap);
        return this.convertorEarlierDocVo(resultMap);
    }

    private Map<String, List<EarlierDocInfoVo>> convertorEarlierDocVo(Map<String, List<CompareLibDto>> resultMap) {
        HashMap<String, List<EarlierDocInfoVo>> earlierDocMap = new HashMap<String, List<EarlierDocInfoVo>>();
        resultMap.forEach((key, value) -> {
            List earlierDocInfoVoList = value.stream().map(EarlierDocInfoConvert.INSTANCE::compareDtoToEarlierVo).collect(Collectors.toList());
            if (earlierDocInfoVoList.size() > 1) {
                earlierDocMap.put((String)key, earlierDocInfoVoList);
            }
        });
        return earlierDocMap;
    }

    private void addHedexEarlierDocs(Map<String, List<CompareLibDto>> resultMap) {
        List<UpgradeDocInfoDto> hdxLocalDocs = UpgradeLibBusinessHandler.getInstance().getContentDoByLibPlatFormType("HDX");
        List<CompareLibDto> compareLibDtos = UpgradeCompareConverter.INSTANCE.convertCompareLibList(hdxLocalDocs);
        Map<String, List<CompareLibDto>> hdxSequenceMap = LOCAL_HDX_LIB_FILTER.filterLocalHdxDocList(this.filterHdxMatchVersion(compareLibDtos));
        resultMap.putAll(hdxSequenceMap);
    }

    private List<CompareLibDto> filterHdxMatchVersion(List<CompareLibDto> hdxLocalDocs) {
        return hdxLocalDocs.stream().filter(upgradeDocInfoDto -> VersionUtils.isRclVersion(upgradeDocInfoDto.getProductVersion()) || VersionUtils.isVrcVersion(upgradeDocInfoDto.getProductVersion()) || StringUtils.equals((CharSequence)upgradeDocInfoDto.getAutoUpdateFromMe(), (CharSequence)HdxAutoUpdate.AUTO_UPDATE_ALL.getLevel())).filter(upgradeDocInfoDto -> VersionUtils.isLibVersion(upgradeDocInfoDto.getLibVersion())).collect(Collectors.toList());
    }

    private List<CompareLibDto> filterIcsMatchVersion(List<CompareLibDto> hwicsLocalDocs) {
        return hwicsLocalDocs.stream().filter(upgradeDocInfoDto -> VersionUtils.isDotVersion(upgradeDocInfoDto.getProductVersion()) || VersionUtils.isVrcVersion(upgradeDocInfoDto.getProductVersion())).collect(Collectors.toList());
    }

    private void addHwicsEarlierDocs(Map<String, List<CompareLibDto>> resultMap) {
        List<UpgradeDocInfoDto> hwicsLocalDocs = UpgradeLibBusinessHandler.getInstance().getContentDoByLibPlatFormType("HWICS");
        List<CompareLibDto> compareLibDtos = UpgradeCompareConverter.INSTANCE.convertCompareLibList(hwicsLocalDocs);
        Map<String, List<CompareLibDto>> icsSequenceMap = LOCAL_ICS_LIB_FILTER.filterLocalIcsDocList(this.filterIcsMatchVersion(compareLibDtos));
        resultMap.putAll(icsSequenceMap);
    }

    @Override
    public List<String> removeDocList(List<String> docIds) {
        LibManageService libManageService = (LibManageService)SpringContextUtil.getBean((String)"libManageService");
        return libManageService.delByDocIdList(docIds);
    }

    @Override
    public String reminderStatus() {
        return ConfigServiceHandler.getInstance().getOrSetDefault("reminderStatus", "0");
    }

    @Override
    public boolean reminderChange(String reminderStatus) {
        return ConfigServiceHandler.getInstance().set("reminderStatus", reminderStatus);
    }

    private static class EarlierLibBusinessHandlerHolder {
        private static final EarlierLibBusinessHandler INSTANCE = new EarlierLibBusinessHandler();

        private EarlierLibBusinessHandlerHolder() {
        }
    }
}

