/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelib.service.impl;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.http.exception.CustomSslException;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.libmanage.service.LibManageService;
import com.huawei.support.icslite.business.upgradelib.concurrent.HdxUpgradeCallable;
import com.huawei.support.icslite.business.upgradelib.concurrent.IcsUpgradeCallable;
import com.huawei.support.icslite.business.upgradelib.entity.convertors.UpgradeCompareConverter;
import com.huawei.support.icslite.business.upgradelib.entity.convertors.UpgradeDocInfoConverter;
import com.huawei.support.icslite.business.upgradelib.entity.dto.UpgradeDocInfoDto;
import com.huawei.support.icslite.business.upgradelib.entity.dto.UpgradeThreadParameterDto;
import com.huawei.support.icslite.business.upgradelib.entity.message.UpgradeLibProcessingMessage;
import com.huawei.support.icslite.business.upgradelib.service.UpgradeLibBusiness;
import com.huawei.support.icslite.business.upgradelib.util.UpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.localfilter.LocalHdxLibFilter;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.localfilter.LocalIcsLibFilter;
import com.huawei.support.icslite.business.upgradelibcommon.util.CommonLibUpgradeUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class UpgradeLibBusinessHandler
implements UpgradeLibBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(UpgradeLibBusinessHandler.class);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final LocalHdxLibFilter LOCAL_HDX_LIB_FILTER = new LocalHdxLibFilter();
    private static final LocalIcsLibFilter LOCAL_ICS_LIB_FILTER = new LocalIcsLibFilter();
    private static String lastUpdateTime;
    private final ThreadPoolExecutor upgradeLibExecutor = ThreadPoolFactory.getThreadPool((String)"upgradeLib", (int)4, (int)600, (int)4, (int)10);
    private final List<String> libLoadedCache = new CopyOnWriteArrayList<String>();
    private final Map<String, List<String>> currentCacheUniqueIds = new HashMap<String, List<String>>();
    private final ReentrantLock reentrantLock = new ReentrantLock();
    private AsyncEventBus eventBus = EventBusUtils.INSTANCE.getEventBus();
    private Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> preCache;
    private Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> currentCache = new HashMap<UpgradeDocInfoDto, List<UpgradeDocInfoDto>>();

    private UpgradeLibBusinessHandler() {
    }

    public static UpgradeLibBusinessHandler getInstance() {
        return UpgradeLibBusinessHandlerHolder.INSTANCE;
    }

    private static void setLastUpdateTime(LocalDateTime now) {
        lastUpdateTime = now.format(DATE_FORMAT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<UpgradeDocInfoDto>> getUpgradeDocs(String docId) {
        ArrayList<List<UpgradeDocInfoDto>> result = new ArrayList<List<UpgradeDocInfoDto>>();
        try {
            LinkedHashSet<String> docIdsSet = new LinkedHashSet<String>();
            if (!this.reentrantLock.tryLock(10L, TimeUnit.SECONDS)) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "getUpgradeDocs fail! Already wait 10 second, not get lock.");
            }
            for (Map.Entry<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> entry : this.currentCache.entrySet()) {
                UpgradeDocInfoDto topUpgradeDto = entry.getValue().get(0);
                String highestDocId = topUpgradeDto.getDocId();
                if (!docIdsSet.contains(highestDocId)) {
                    topUpgradeDto.setSelected(false);
                    docIdsSet.add(highestDocId);
                }
                if (StringUtils.isNotBlank((CharSequence)docId) && StringUtils.equals((CharSequence)entry.getKey().getDocId(), (CharSequence)docId)) {
                    topUpgradeDto.setSelected(true);
                }
                this.handlerUpgradeResultList(topUpgradeDto.getLibPlatFormType(), entry.getKey(), entry.getValue(), result);
            }
            UpgradeUtils.sortLibName(result);
            this.preCache = this.currentCache;
            if (StringUtils.isBlank((CharSequence)lastUpdateTime)) {
                CodeCCUtils.INSTANCE.warnLog(LOG, "getUpgradeDocs currentCache lastUpdateTime is null");
                UpgradeLibBusinessHandler.setLastUpdateTime(LocalDateTime.now());
            }
            this.eventBus.post((Object)new UpgradeLibProcessingMessage(100, "2", null, lastUpdateTime));
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getUpgradeDocs fail!", (Throwable)e);
        }
        finally {
            if (this.reentrantLock.isHeldByCurrentThread()) {
                this.reentrantLock.unlock();
            }
        }
        return result;
    }

    private void handlerUpgradeResultList(String libPlatFormType, UpgradeDocInfoDto lowerUpgradeDocInfoDto, List<UpgradeDocInfoDto> upgradeDocInfoDtoList, List<List<UpgradeDocInfoDto>> result) {
        if (StringUtils.equalsIgnoreCase((CharSequence)libPlatFormType, (CharSequence)"HDX")) {
            ArrayList<UpgradeDocInfoDto> hdxUpgradeDocInfos = new ArrayList<UpgradeDocInfoDto>();
            hdxUpgradeDocInfos.add(lowerUpgradeDocInfoDto);
            hdxUpgradeDocInfos.addAll(upgradeDocInfoDtoList);
            result.add(hdxUpgradeDocInfos);
        } else {
            this.addIcsDocInfo(lowerUpgradeDocInfoDto, upgradeDocInfoDtoList, result);
        }
    }

    private void addIcsDocInfo(UpgradeDocInfoDto lowerUpgradeDocInfoDto, List<UpgradeDocInfoDto> upgradeDocInfoDtoList, List<List<UpgradeDocInfoDto>> result) {
        ArrayList<UpgradeDocInfoDto> icsUpgradeDocInfos = new ArrayList<UpgradeDocInfoDto>();
        icsUpgradeDocInfos.add(lowerUpgradeDocInfoDto);
        upgradeDocInfoDtoList.forEach(upgradeDocInfoDto -> {
            if (!CollectionUtils.isEmpty(upgradeDocInfoDto.getNetworkInfoList())) {
                ArrayList<UpgradeDocInfoDto> networkUpgradeList = new ArrayList<UpgradeDocInfoDto>();
                networkUpgradeList.add(lowerUpgradeDocInfoDto);
                networkUpgradeList.add((UpgradeDocInfoDto)upgradeDocInfoDto);
                result.add(networkUpgradeList);
            } else {
                icsUpgradeDocInfos.add((UpgradeDocInfoDto)upgradeDocInfoDto);
            }
        });
        if (icsUpgradeDocInfos.size() > 1) {
            result.add(icsUpgradeDocInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateUpgradeDocsCache(String lang, String domainType, boolean isNeedUpgradePercent) {
        AtomicInteger curSize = new AtomicInteger(0);
        AtomicInteger sumSize = new AtomicInteger(0);
        UpgradeThreadParameterDto hdxParameterDto = this.getLibParameterDto("HDX", sumSize, lang, domainType, curSize);
        UpgradeThreadParameterDto icsParameterDto = this.getLibParameterDto("HWICS", sumSize, lang, domainType, curSize);
        Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> upgradeDocInfoDtoListMap = this.refreshUpgradeDocsCache(hdxParameterDto, icsParameterDto, isNeedUpgradePercent, sumSize);
        try {
            if (!this.reentrantLock.tryLock(10L, TimeUnit.SECONDS)) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "updateUpgradeDocsCache fail! Already wait 10 second, not get lock.");
                boolean bl = false;
                return bl;
            }
            this.preUpgradeInfoRemoveMark();
            this.currentCache = upgradeDocInfoDtoListMap;
            ArrayList<String> failDocIds = new ArrayList<String>();
            this.saveUniqueIdsAndMark(upgradeDocInfoDtoListMap, failDocIds, isNeedUpgradePercent);
            UpgradeLibBusinessHandler.setLastUpdateTime(LocalDateTime.now());
            if (isNeedUpgradePercent) {
                String code = curSize.get() < sumSize.get() ? "-1" : "0";
                this.eventBus.post((Object)new UpgradeLibProcessingMessage(100, "1", code, null));
            }
            if (CollectionUtils.isNotEmpty(failDocIds)) {
                CodeCCUtils.INSTANCE.warnLog(LOG, "markUpgradeDocs failed docIds is: {0}", new Object[]{((Object)failDocIds).toString()});
                boolean bl = false;
                return bl;
            }
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateUpgradeDocsCache fail!", (Throwable)e);
        }
        finally {
            if (this.reentrantLock.isHeldByCurrentThread()) {
                this.reentrantLock.unlock();
            }
        }
        return true;
    }

    private void preUpgradeInfoRemoveMark() {
        Set<UpgradeDocInfoDto> upgradeDocInfoDtos = this.currentCache.keySet();
        if (CollectionUtils.isEmpty(upgradeDocInfoDtos)) {
            return;
        }
        ArrayList failDocIds = new ArrayList();
        upgradeDocInfoDtos.forEach(upgradeDocInfoDto -> {
            String docId = upgradeDocInfoDto.getDocId();
            boolean isMark = this.setUpdate(docId, false);
            if (!isMark) {
                failDocIds.add(docId);
            }
        });
        if (CollectionUtils.isNotEmpty(failDocIds)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "perUpGradeInfoRemoveMark failed docIds is: {0}", new Object[]{((Object)failDocIds).toString()});
        }
    }

    private boolean setUpdate(String docId, boolean isUpdate) {
        LibManageService libManageService = (LibManageService)SpringContextUtil.getBean((String)"libManageService");
        return libManageService.setUpdate(docId, isUpdate);
    }

    private void saveUniqueIdsAndMark(Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> upgradeDocInfoDtoListMap, List<String> failDocIds, boolean isNeedUpgradePercent) {
        upgradeDocInfoDtoListMap.forEach((key, upgradeDocInfoDtos) -> this.handlerDocMark(key.getDocId(), key.getUniqueId(), (List<UpgradeDocInfoDto>)upgradeDocInfoDtos, failDocIds, isNeedUpgradePercent));
    }

    private void handlerDocMark(String lowVersionLocalDocId, String uniqueId, List<UpgradeDocInfoDto> upgradeDocInfoDtos, List<String> failDocIds, boolean isNeedUpgradePercent) {
        this.putUniqueIds(uniqueId, lowVersionLocalDocId, upgradeDocInfoDtos);
        boolean isMark = this.setUpdate(lowVersionLocalDocId, true);
        if (!isMark) {
            failDocIds.add(lowVersionLocalDocId);
        }
        if (isMark && !isNeedUpgradePercent) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "updateUpgradeDocsCache  docId : {0} set update success", new Object[]{lowVersionLocalDocId});
        }
    }

    private void putUniqueIds(String lowVersionLocalUniqueId, String lowVersionLocalDocId, List<UpgradeDocInfoDto> upgradeDocInfoDtos) {
        ArrayList<String> uniqueIds = new ArrayList<String>();
        upgradeDocInfoDtos.forEach(upgradeDocInfoDto -> {
            String uniqueId = upgradeDocInfoDto.getUniqueId();
            uniqueIds.add(uniqueId);
        });
        uniqueIds.add(lowVersionLocalUniqueId);
        this.currentCacheUniqueIds.put(lowVersionLocalDocId, uniqueIds);
    }

    private Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> refreshUpgradeDocsCache(UpgradeThreadParameterDto hdxParameterDto, UpgradeThreadParameterDto icsParameterDto, boolean isNeedUpgradePercent, AtomicInteger sumSize) {
        if (isNeedUpgradePercent && sumSize.get() == 0) {
            this.eventBus.post((Object)new UpgradeLibProcessingMessage(100, "0", "0", null));
            return new HashMap<UpgradeDocInfoDto, List<UpgradeDocInfoDto>>();
        }
        Future<Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>>> hdxLibFuture = null;
        if (hdxParameterDto.isNeedThread()) {
            hdxParameterDto.setSumSize(sumSize.get() + 1);
            hdxLibFuture = this.upgradeLibExecutor.submit(new HdxUpgradeCallable(hdxParameterDto, isNeedUpgradePercent));
        }
        Future<Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>>> icsLibFuture = null;
        if (icsParameterDto.isNeedThread()) {
            icsParameterDto.setSumSize(sumSize.get() + 1);
            icsLibFuture = this.upgradeLibExecutor.submit(new IcsUpgradeCallable(icsParameterDto, isNeedUpgradePercent));
        }
        return UpgradeUtils.convergenceFutureList(hdxLibFuture, icsLibFuture);
    }

    private UpgradeThreadParameterDto getLibParameterDto(String libPlatFormType, AtomicInteger sumSize, String lang, String domainType, AtomicInteger curSize) {
        List<String> prodNames;
        UpgradeThreadParameterDto upgradeThreadParameterDto = new UpgradeThreadParameterDto();
        upgradeThreadParameterDto.setLang(lang).setDomainType(domainType).setCurSize(curSize);
        List<UpgradeDocInfoDto> allContentDo = this.getContentDoByLibPlatFormType(libPlatFormType);
        List<CompareLibDto> compareLibDtos = UpgradeCompareConverter.INSTANCE.convertCompareLibList(allContentDo);
        HashMap<String, List<CompareLibDto>> localContentDtoMap = new HashMap();
        if (StringUtils.equalsIgnoreCase((CharSequence)libPlatFormType, (CharSequence)"HWICS")) {
            localContentDtoMap = LOCAL_ICS_LIB_FILTER.filterLocalIcsLib(compareLibDtos);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)libPlatFormType, (CharSequence)"HDX")) {
            localContentDtoMap = LOCAL_HDX_LIB_FILTER.filterLocalHdxLib(compareLibDtos);
        }
        boolean isNeedThread = false;
        if (MapUtils.isNotEmpty(localContentDtoMap) && !CollectionUtils.isEmpty(prodNames = CommonLibUpgradeUtils.getProductNames(localContentDtoMap))) {
            upgradeThreadParameterDto.setProdNames(prodNames);
            sumSize.getAndAdd(prodNames.size());
            isNeedThread = true;
        }
        upgradeThreadParameterDto.setNeedThread(isNeedThread);
        upgradeThreadParameterDto.setAllLocalContentDo(compareLibDtos);
        upgradeThreadParameterDto.setLocalUpgradeContentMap(localContentDtoMap);
        upgradeThreadParameterDto.setLocalUniqueIdSet(this.getUniqueIdSet(allContentDo));
        return upgradeThreadParameterDto;
    }

    private Set<String> getUniqueIdSet(List<UpgradeDocInfoDto> allContentDo) {
        return allContentDo.stream().peek(UpgradeDocInfoDto::setUniqueId).map(UpgradeDocInfoDto::getUniqueId).collect(Collectors.toSet());
    }

    public List<UpgradeDocInfoDto> getContentDoByLibPlatFormType(String libPlatFormType) {
        HashSet<UpgradeDocInfoDto> contentDtoSet = new HashSet<UpgradeDocInfoDto>();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)libPlatFormType, (CharSequence[])new CharSequence[]{"HWICS", "ALL"})) {
            List icsContentDos = IcsContentPoolServiceHandler.getInstance().getAll("", "");
            for (IcsContentDo icsContentDo : icsContentDos) {
                contentDtoSet.add(UpgradeDocInfoConverter.INSTANCE.icsContentDoToUpgradeDocInfoDto(icsContentDo));
            }
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)libPlatFormType, (CharSequence[])new CharSequence[]{"HDX", "ALL"})) {
            List hdxContentDos = HdxContentPoolServiceHandler.getInstance().getAll("", "");
            for (HdxContentDo hdxContentDo : hdxContentDos) {
                contentDtoSet.add(UpgradeDocInfoConverter.INSTANCE.hdxContentDoToUpgradeDocInfoDto(hdxContentDo));
            }
        }
        return new ArrayList<UpgradeDocInfoDto>(contentDtoSet);
    }

    @Override
    public boolean isDifferentWithPreCache() {
        if (MapUtils.isEmpty(this.preCache) && MapUtils.isEmpty(this.currentCache)) {
            return false;
        }
        if (MapUtils.isEmpty(this.preCache) && !MapUtils.isEmpty(this.currentCache)) {
            return true;
        }
        if (this.preCache.size() != this.currentCache.size()) {
            return true;
        }
        for (Map.Entry<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> entry : this.currentCache.entrySet()) {
            List<UpgradeDocInfoDto> preUpgradeDocInfoDtos = this.preCache.get(entry.getKey());
            if (CollectionUtils.isEmpty(preUpgradeDocInfoDtos)) {
                return true;
            }
            List<UpgradeDocInfoDto> currentUpgradeDocInfoDtos = entry.getValue();
            if (preUpgradeDocInfoDtos.size() != currentUpgradeDocInfoDtos.size()) {
                return true;
            }
            for (int index = 0; index < currentUpgradeDocInfoDtos.size(); ++index) {
                if (currentUpgradeDocInfoDtos.get(index).equals(preUpgradeDocInfoDtos.get(index))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void lowerDocsCancelUpgradeMark() {
        List<UpgradeDocInfoDto> allContentDo = this.getContentDoByLibPlatFormType("ALL");
        List<UpgradeDocInfoDto> incrementalList = allContentDo.stream().filter(upgradeDocInfoDto -> !this.libLoadedCache.contains(upgradeDocInfoDto.getDocId())).collect(Collectors.toList());
        if (incrementalList.isEmpty()) {
            return;
        }
        incrementalList.forEach(this::libHandler);
    }

    private void libHandler(UpgradeDocInfoDto upgradeDocInfoDto) {
        if (MapUtils.isEmpty(this.currentCacheUniqueIds)) {
            return;
        }
        upgradeDocInfoDto.setUniqueId();
        String uniqueId = upgradeDocInfoDto.getUniqueId();
        if (StringUtils.isBlank((CharSequence)uniqueId)) {
            return;
        }
        for (Map.Entry<String, List<String>> uniqueIdListEntry : this.currentCacheUniqueIds.entrySet()) {
            boolean isCancelMark;
            boolean isContainUniqueId;
            List<String> upgradeUniqueIds = uniqueIdListEntry.getValue();
            String lowVersionLocalDocId = uniqueIdListEntry.getKey();
            if (CollectionUtils.isEmpty(upgradeUniqueIds) || StringUtils.equals((CharSequence)uniqueId, (CharSequence)upgradeUniqueIds.get(upgradeUniqueIds.size() - 1)) || !(isContainUniqueId = upgradeUniqueIds.contains(uniqueId)) || (isCancelMark = this.setUpdate(lowVersionLocalDocId, false))) continue;
            CodeCCUtils.INSTANCE.infoLog(LOG, "libHandler  lowVersionLocalDocId : {0} set update fail", new Object[]{lowVersionLocalDocId});
        }
        this.libLoadedCache.add(upgradeDocInfoDto.getDocId());
    }

    @Override
    public void initLoadedDocIds() {
        this.upgradeLibExecutor.execute(() -> {
            HashSet allDocId = new HashSet();
            allDocId.addAll(HdxContentPoolServiceHandler.getInstance().getAllDocId());
            allDocId.addAll(IcsContentPoolServiceHandler.getInstance().getAllDocId());
            this.libLoadedCache.addAll(allDocId);
        });
    }

    public void updateUpgradeDocsCacheRunnable() {
        CodeCCUtils.INSTANCE.infoLog(LOG, "schedule start updateUpgradeDocsCacheRunnable");
        boolean isUpgradeDocsCache = false;
        try {
            isUpgradeDocsCache = this.updateUpgradeDocsCache("all", "all", false);
        }
        catch (CustomSslException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateUpgradeDocsCache has CustomSslException", (Throwable)e);
        }
        if (!isUpgradeDocsCache) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "updateUpgradeDocsCacheRunnable failed because : libManageService.setUpdate failed ");
        }
    }

    @Override
    public boolean delLibLoadedCache(String docId) {
        boolean isRemove = this.libLoadedCache.remove(docId);
        if (!isRemove) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "delLibLoadedCache fail, docId: {0}", new Object[]{docId});
        }
        return isRemove;
    }

    public static class UpgradeLibBusinessHandlerHolder {
        private static final UpgradeLibBusinessHandler INSTANCE = new UpgradeLibBusinessHandler();
    }
}

