/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelib.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.onlinelib.dto.LibInfoDto;
import com.huawei.support.icslite.business.onlinelib.utils.OnlineQueryUtils;
import com.huawei.support.icslite.business.upgradelib.entity.convertors.UpgradeDocInfoConverter;
import com.huawei.support.icslite.business.upgradelib.entity.dto.UpgradeDocInfoDto;
import com.huawei.wsf.core.HWDecoder;
import java.io.Serializable;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.collections4.CollectionUtils;

public class UpgradeUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(UpgradeUtils.class);

    private UpgradeUtils() {
    }

    public static void getUpgradesByDocuments(Set<UpgradeDocInfoDto> allOnlineContentDo, Map<String, Object> documents) {
        List libInfoDtos = JsonUtils.castList((Object)documents.get("libInfoDtos"), LibInfoDto.class);
        if (CollectionUtils.isEmpty((Collection)libInfoDtos)) {
            return;
        }
        for (LibInfoDto libInfoDto : libInfoDtos) {
            if (OnlineQueryUtils.isErrorLibInfoDto(libInfoDto)) continue;
            UpgradeDocInfoDto upgradeDocInfoDto = UpgradeDocInfoConverter.INSTANCE.onlineLibInfoToUpgradeDocInfoDto(libInfoDto);
            allOnlineContentDo.add(upgradeDocInfoDto);
        }
    }

    public static Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> convergenceFutureList(Future<Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>>> hdxLibFuture, Future<Map<UpgradeDocInfoDto, List<UpgradeDocInfoDto>>> icsLibFuture) {
        HashMap<UpgradeDocInfoDto, List<UpgradeDocInfoDto>> upgradeDocInfos = new HashMap<UpgradeDocInfoDto, List<UpgradeDocInfoDto>>();
        try {
            if (hdxLibFuture != null) {
                upgradeDocInfos.putAll(hdxLibFuture.get());
            }
            if (icsLibFuture != null) {
                upgradeDocInfos.putAll(icsLibFuture.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "ConvergenceFutureList has a exception", (Throwable)e);
        }
        return upgradeDocInfos;
    }

    public static void sortLibName(List<List<UpgradeDocInfoDto>> result) {
        result.sort(new LibNameComparator());
    }

    static class LibNameComparator
    implements Comparator<List<UpgradeDocInfoDto>>,
    Serializable {
        private static final long serialVersionUID = 6995957655663735450L;

        LibNameComparator() {
        }

        @Override
        public int compare(List<UpgradeDocInfoDto> o1, List<UpgradeDocInfoDto> o2) {
            if (CollectionUtils.isEmpty(o1) || CollectionUtils.isEmpty(o2)) {
                return 0;
            }
            String libNameOne = HWDecoder.decodeForHTML((String)o1.get(1).getLibName());
            String libNameTwo = HWDecoder.decodeForHTML((String)o2.get(1).getLibName());
            Collator sortChina = Collator.getInstance(Locale.CHINA);
            return sortChina.compare(libNameOne, libNameTwo);
        }
    }
}

