/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.enums;

import com.huawei.support.icslite.business.upgradelibcommon.exception.VersionCompareException;

public enum HdxAutoUpdate {
    AUTO_UPDATE_0("0", 0, -1, -1),
    AUTO_UPDATE_1("1", 1, -1, -1),
    AUTO_UPDATE_V("V", 2, 0, -1),
    AUTO_UPDATE_R("R", 3, 4, 0),
    AUTO_UPDATE_C("C", 4, 8, 4),
    AUTO_UPDATE_L("L", 5, -1, 7),
    AUTO_UPDATE_P("P", 6, -1, -1),
    AUTO_UPDATE_ALL("ALL", 7, -1, -1);

    private final String level;
    private final int weight;
    private final int vrcOffset;
    private final int rclOffset;

    private HdxAutoUpdate(String level, int weight, int vrcOffset, int rclOffset) {
        this.level = level;
        this.weight = weight;
        this.vrcOffset = vrcOffset;
        this.rclOffset = rclOffset;
    }

    public static HdxAutoUpdate getMatchedEnum(String libLevel) throws VersionCompareException {
        switch (libLevel) {
            case "0": {
                return AUTO_UPDATE_0;
            }
            case "1": {
                return AUTO_UPDATE_1;
            }
            case "V": {
                return AUTO_UPDATE_V;
            }
            case "R": {
                return AUTO_UPDATE_R;
            }
            case "C": {
                return AUTO_UPDATE_C;
            }
            case "L": {
                return AUTO_UPDATE_L;
            }
            case "P": {
                return AUTO_UPDATE_P;
            }
            case "ALL": {
                return AUTO_UPDATE_ALL;
            }
        }
        throw new VersionCompareException("no suitable case: " + libLevel);
    }

    public static HdxAutoUpdate getMaxWeightEnum(HdxAutoUpdate first, HdxAutoUpdate second) {
        return first.getWeight() - second.getWeight() >= 0 ? first : second;
    }

    public String getLevel() {
        return this.level;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getVrcOffset() {
        return this.vrcOffset;
    }

    public int getRclOffset() {
        return this.rclOffset;
    }
}

