/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.libfilter.localfilter;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.enums.HdxAutoUpdate;
import com.huawei.support.icslite.business.upgradelibcommon.rule.CompareLibFacade;
import com.huawei.support.icslite.business.upgradelibcommon.util.CommonLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.HdxLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.SeriesLibUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LocalHdxLibFilter {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(LocalHdxLibFilter.class);

    public Map<String, List<CompareLibDto>> filterLocalHdxLib(List<CompareLibDto> localHdxDos) {
        Map<String, List<CompareLibDto>> classifiedHdxContentDo = SeriesLibUtils.serialHdxString(localHdxDos, Boolean.TRUE);
        return this.filterLocalHdxLib(classifiedHdxContentDo);
    }

    public Map<String, List<CompareLibDto>> filterLocalHdxLib(Map<String, List<CompareLibDto>> classifiedHdxLibMap) {
        HashMap<String, List<CompareLibDto>> result = new HashMap<String, List<CompareLibDto>>();
        for (Map.Entry<String, List<CompareLibDto>> seriesSetEntry : classifiedHdxLibMap.entrySet()) {
            String key = seriesSetEntry.getKey();
            List<CompareLibDto> differentVrcMaxVersions = this.getDifferentVersionsByType(key, "VRC", seriesSetEntry.getValue());
            List<CompareLibDto> differentRclVersions = this.getDifferentVersionsByType(key, "RCL", seriesSetEntry.getValue());
            differentVrcMaxVersions.addAll(differentRclVersions);
            if (CollectionUtils.isNotEmpty(differentVrcMaxVersions)) {
                result.put(key, differentVrcMaxVersions);
                continue;
            }
            List<CompareLibDto> differentAutoAllVersions = HdxLibUpgradeUtils.differentAllVersions(key, seriesSetEntry.getValue());
            differentVrcMaxVersions.addAll(differentAutoAllVersions);
            if (CollectionUtils.isNotEmpty(differentVrcMaxVersions)) {
                result.put(key, differentVrcMaxVersions);
                continue;
            }
            CodeCCUtils.INSTANCE.infoLog(log, "{0} key get differentMaxVersions is empty", new Object[]{key});
        }
        return result;
    }

    public Map<String, List<CompareLibDto>> filterLocalHdxDocList(List<CompareLibDto> localHdxDos) {
        Map<String, List<CompareLibDto>> classifiedHdxContentDo = SeriesLibUtils.serialHdxString(localHdxDos, Boolean.TRUE);
        classifiedHdxContentDo.forEach((key, value) -> {
            if (this.isAutoAllVersion((List<CompareLibDto>)value)) {
                CompareLibFacade.getInstance().sortLibVersion((List<CompareLibDto>)value);
            } else {
                CompareLibFacade.getInstance().sortVersion((List<CompareLibDto>)value);
            }
        });
        return classifiedHdxContentDo;
    }

    private boolean isAutoAllVersion(List<CompareLibDto> upgradeDocInfoDtos) {
        return Optional.of(upgradeDocInfoDtos).map(list -> list.isEmpty() ? null : (CompareLibDto)list.get(0)).map(upgradeDocInfoDto -> upgradeDocInfoDto.getAutoUpdateFromMe().equals(HdxAutoUpdate.AUTO_UPDATE_ALL.getLevel())).orElse(false);
    }

    public List<CompareLibDto> getDifferentVersionsByType(String seriesName, String type, List<CompareLibDto> seriesList) {
        Optional<List<CompareLibDto>> compareLibDtosOpt = CommonLibUpgradeUtils.getVersionListByType(type, seriesName, seriesList);
        return compareLibDtosOpt.map(compareLibDtoList -> this.filterLibVersionList(this.getDifferentVersionMap((List<CompareLibDto>)compareLibDtoList, type))).orElseGet(ArrayList::new);
    }

    public List<CompareLibDto> filterLibVersionList(Map<String, List<CompareLibDto>> differentVersionMap) {
        ArrayList<CompareLibDto> upgradeDocInfoDtos = new ArrayList<CompareLibDto>();
        for (Map.Entry<String, List<CompareLibDto>> differentVersionsEntry : differentVersionMap.entrySet()) {
            List<CompareLibDto> versionList = differentVersionsEntry.getValue();
            if (versionList.size() >= 2) {
                CompareLibFacade.getInstance().sortLibVersion(versionList);
            }
            upgradeDocInfoDtos.add(versionList.get(0));
        }
        return upgradeDocInfoDtos;
    }

    private Map<String, List<CompareLibDto>> getDifferentVersionMap(List<CompareLibDto> seriesListFilter, String type) {
        LinkedHashMap<String, List<CompareLibDto>> differentVersionMap = new LinkedHashMap<String, List<CompareLibDto>>();
        for (CompareLibDto upgradeDocInfoDto : seriesListFilter) {
            String pureVersion = this.getPureVersionByType(upgradeDocInfoDto.getProductVersion(), type);
            if (StringUtils.isBlank((CharSequence)pureVersion)) continue;
            differentVersionMap.computeIfAbsent(pureVersion, k -> new ArrayList()).add(upgradeDocInfoDto);
        }
        return differentVersionMap;
    }

    private String getPureVersionByType(String productVersion, String type) {
        String pureVersion = "";
        if (StringUtils.equals((CharSequence)type, (CharSequence)"VRC")) {
            pureVersion = CommonLibUpgradeUtils.getPureVrcVersion(productVersion);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"RCL")) {
            pureVersion = HdxLibUpgradeUtils.getPureRclVersion(productVersion);
        }
        return pureVersion;
    }
}

