/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.libfilter.localfilter;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.rule.CompareLibFacade;
import com.huawei.support.icslite.business.upgradelibcommon.util.CommonLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.SeriesLibUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LocalIcsLibFilter {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(LocalIcsLibFilter.class);

    public Map<String, List<CompareLibDto>> filterLocalIcsLib(List<CompareLibDto> localIcsDos) {
        Map<String, List<CompareLibDto>> classifiedIcsLibMap = SeriesLibUtils.serialIcsString(localIcsDos, Boolean.TRUE);
        return this.filterLocalIcsLib(classifiedIcsLibMap);
    }

    public Map<String, List<CompareLibDto>> filterLocalIcsLib(Map<String, List<CompareLibDto>> classifiedIcsLibMap) {
        HashMap<String, List<CompareLibDto>> result = new HashMap<String, List<CompareLibDto>>();
        for (Map.Entry<String, List<CompareLibDto>> icsCompareEntry : classifiedIcsLibMap.entrySet()) {
            String key = icsCompareEntry.getKey();
            Optional<CompareLibDto> maxVrcVersionOpt = this.getMaxVersionByType(key, "VRC", icsCompareEntry.getValue());
            Optional<CompareLibDto> maxDotVersionOpt = this.getMaxVersionByType(key, "DOT", icsCompareEntry.getValue());
            ArrayList<CompareLibDto> maxVersionList = new ArrayList<CompareLibDto>();
            this.addVersionList(maxVrcVersionOpt.orElse(null), maxVersionList);
            this.addVersionList(maxDotVersionOpt.orElse(null), maxVersionList);
            if (CollectionUtils.isEmpty(maxVersionList)) {
                CodeCCUtils.INSTANCE.infoLog(log, "{0} key ics lib get maxVersions is empty", new Object[]{key});
                continue;
            }
            result.put(key, maxVersionList);
        }
        return result;
    }

    private void addVersionList(CompareLibDto maxVersionDto, List<CompareLibDto> maxVersionList) {
        if (Objects.isNull(maxVersionDto)) {
            return;
        }
        if (!StringUtils.equals((CharSequence)maxVersionDto.getUpgradeType(), (CharSequence)"2")) {
            maxVersionList.add(maxVersionDto);
        }
    }

    public Map<String, List<CompareLibDto>> filterLocalIcsDocList(List<CompareLibDto> localIcsDos) {
        Map<String, List<CompareLibDto>> classifiedIcsContentDo = SeriesLibUtils.serialIcsString(localIcsDos, Boolean.TRUE);
        classifiedIcsContentDo.forEach((key, value) -> CompareLibFacade.getInstance().sortVersionAndDate((List<CompareLibDto>)value));
        return classifiedIcsContentDo;
    }

    public Optional<CompareLibDto> getMaxVersionByType(String seriesName, String type, List<CompareLibDto> upgradeDocInfoDtos) {
        Optional<List<CompareLibDto>> compareLibDtosOpt = CommonLibUpgradeUtils.getVersionListByType(type, seriesName, upgradeDocInfoDtos);
        if (!compareLibDtosOpt.isPresent()) {
            return Optional.empty();
        }
        List<CompareLibDto> compareLibDtoList = compareLibDtosOpt.get();
        CompareLibFacade.getInstance().sortVersionAndDate(compareLibDtoList);
        return Optional.ofNullable(compareLibDtoList.get(0));
    }
}

