/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.OnlineFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public abstract class OnlineFilterAbstract
implements OnlineFilter {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(OnlineFilterAbstract.class);
    private static final Pattern HDX_LIB_ID_PATTERN = Pattern.compile("HDXLIBID");

    @Override
    public abstract boolean canApply(CompareLibDto var1);

    @Override
    public void doFilter(Map<String, List<CompareLibDto>> localLibs, Map<String, List<CompareLibDto>> onlineLibs) {
        if (MapUtils.isEmpty(onlineLibs)) {
            CodeCCUtils.INSTANCE.warnLog(log, "onlineLibs map is empty");
            return;
        }
        if (!this.canApply(localLibs.values().iterator().next().get(0))) {
            return;
        }
        HashMap<String, List<CompareLibDto>> tempOnlineLibs = new HashMap<String, List<CompareLibDto>>();
        for (Map.Entry<String, List<CompareLibDto>> localSeriesLibEntry : localLibs.entrySet()) {
            String[] hdxSerialStrings;
            List<CompareLibDto> specialOnlineLibs;
            List<CompareLibDto> localSeriesLibs = localSeriesLibEntry.getValue();
            if (CollectionUtils.isEmpty(localSeriesLibs) || CollectionUtils.isEmpty(specialOnlineLibs = onlineLibs.get((hdxSerialStrings = HDX_LIB_ID_PATTERN.split(localSeriesLibEntry.getKey()))[0]))) continue;
            specialOnlineLibs.removeIf(this::canNotUpgradeLib);
            tempOnlineLibs.put(localSeriesLibEntry.getKey(), specialOnlineLibs);
        }
        onlineLibs.clear();
        onlineLibs.putAll(tempOnlineLibs);
    }

    public abstract boolean canNotUpgradeLib(CompareLibDto var1);
}

