/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.enums.HdxAutoUpdate;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.OnlineFilter;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.impl.OnlineHdxNoUpgradeAttributeFilter;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.impl.OnlineHdxVersionCompareFilter;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.impl.OnlineHwicsNoUpgradeAttributeFilter;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.impl.OnlineHwicsVersionCompareFilter;
import com.huawei.support.icslite.business.upgradelibcommon.rule.CompareLibFacade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class OnlineLibFilterChain<T> {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(OnlineLibFilterChain.class);
    private final List<OnlineFilter> handlers = new ArrayList<OnlineFilter>();

    public OnlineLibFilterChain() {
        this.handlers.add(new OnlineHdxNoUpgradeAttributeFilter());
        this.handlers.add(new OnlineHdxVersionCompareFilter());
        this.handlers.add(new OnlineHwicsNoUpgradeAttributeFilter());
        this.handlers.add(new OnlineHwicsVersionCompareFilter());
    }

    public Map<T, List<T>> handler(Map<String, List<CompareLibDto>> localSeriesLib, Map<String, List<CompareLibDto>> onlineSeriesLib, boolean retainMaxVersion) {
        for (OnlineFilter handler : this.handlers) {
            handler.doFilter(localSeriesLib, onlineSeriesLib);
        }
        HashMap<T, List<T>> result = new HashMap<T, List<T>>();
        for (Map.Entry<String, List<CompareLibDto>> localLibEntry : localSeriesLib.entrySet()) {
            String key = localLibEntry.getKey();
            List<CompareLibDto> libBaseDos = onlineSeriesLib.get(key);
            CompareLibDto localMaxLibDto = localLibEntry.getValue().get(0);
            if (CollectionUtils.isEmpty(libBaseDos) && retainMaxVersion) {
                libBaseDos = Collections.singletonList(localMaxLibDto);
            }
            if (CollectionUtils.isEmpty(libBaseDos)) {
                CodeCCUtils.INSTANCE.warnLog(log, "key: {0}, not have upgrade libs", new Object[]{key});
                continue;
            }
            CompareLibDto upgradeDocInfoDto = libBaseDos.get(0);
            if (StringUtils.equalsIgnoreCase((CharSequence)upgradeDocInfoDto.getLibPlatFormType(), (CharSequence)"HDX") && StringUtils.equalsIgnoreCase((CharSequence)upgradeDocInfoDto.getAutoUpdateToMe(), (CharSequence)HdxAutoUpdate.AUTO_UPDATE_ALL.getLevel())) {
                CompareLibFacade.getInstance().sortLibVersion(libBaseDos);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)upgradeDocInfoDto.getLibPlatFormType(), (CharSequence)"HWICS")) {
                CompareLibFacade.getInstance().sortVersionAndDate(libBaseDos);
            } else {
                CompareLibFacade.getInstance().sortVersion(libBaseDos);
            }
            libBaseDos = this.removeGtFinalVersion(libBaseDos);
            List<T> targetCompareList = this.convertList(libBaseDos);
            T targetKeyDto = this.convertSourceDto(localMaxLibDto);
            result.put(targetKeyDto, targetCompareList);
        }
        return result;
    }

    protected abstract T convertSourceDto(CompareLibDto var1);

    protected abstract List<T> convertList(List<CompareLibDto> var1);

    private List<CompareLibDto> removeGtFinalVersion(List<CompareLibDto> libBaseDos) {
        CompareLibDto upgradeDocInfoDto;
        int index;
        if (!StringUtils.equalsIgnoreCase((CharSequence)"HWICS", (CharSequence)libBaseDos.get(0).getLibPlatFormType())) {
            return libBaseDos;
        }
        int size = libBaseDos.size();
        for (index = size - 1; index >= 0 && !StringUtils.equals((CharSequence)"2", (CharSequence)(upgradeDocInfoDto = libBaseDos.get(index)).getUpgradeType()); --index) {
        }
        if (index == -1 || index == 0) {
            return libBaseDos;
        }
        return new ArrayList<CompareLibDto>(libBaseDos.subList(index, size));
    }
}

