/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.enums.HdxAutoUpdate;
import com.huawei.support.icslite.business.upgradelibcommon.exception.VersionCompareException;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.OnlineFilter;
import com.huawei.support.icslite.business.upgradelibcommon.util.CommonLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.HdxLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.VersionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OnlineHdxVersionCompareFilter
implements OnlineFilter {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(OnlineHdxVersionCompareFilter.class);

    @Override
    public boolean canApply(CompareLibDto libBaseDo) {
        return "HDX".equalsIgnoreCase(libBaseDo.getLibPlatFormType());
    }

    @Override
    public void doFilter(Map<String, List<CompareLibDto>> localLibs, Map<String, List<CompareLibDto>> onlineLibs) {
        if (MapUtils.isEmpty(onlineLibs)) {
            CodeCCUtils.INSTANCE.warnLog(log, "onlineLibs map is empty");
            return;
        }
        if (!this.canApply(localLibs.values().iterator().next().get(0))) {
            return;
        }
        HashMap<String, List<CompareLibDto>> tempOnlineLibs = new HashMap<String, List<CompareLibDto>>();
        HashMap tempLocalLibs = new HashMap();
        for (Map.Entry<String, List<CompareLibDto>> localListEntry : localLibs.entrySet()) {
            List<CompareLibDto> localHdxLibList = localListEntry.getValue();
            for (CompareLibDto upgradeDocInfoDto : localHdxLibList) {
                String key = localListEntry.getKey() + upgradeDocInfoDto.getProductVersion();
                ArrayList<CompareLibDto> upgradeDocInfoDtos = new ArrayList<CompareLibDto>();
                upgradeDocInfoDtos.add(upgradeDocInfoDto);
                tempLocalLibs.put(key, upgradeDocInfoDtos);
                List<CompareLibDto> maxCompareResult = this.getMaxCompareResult(upgradeDocInfoDto, onlineLibs.get(localListEntry.getKey()));
                if (CollectionUtils.isEmpty(maxCompareResult)) continue;
                tempOnlineLibs.put(key, maxCompareResult);
            }
        }
        localLibs.clear();
        localLibs.putAll(tempLocalLibs);
        onlineLibs.clear();
        onlineLibs.putAll(tempOnlineLibs);
    }

    private List<CompareLibDto> getMaxCompareResult(CompareLibDto localHdxDo, List<CompareLibDto> onlineLibs, boolean isVrc) {
        ArrayList<CompareLibDto> result = new ArrayList<CompareLibDto>();
        for (CompareLibDto onlineLibBaseDo : onlineLibs) {
            if (!this.equalsAutoAndCheckVersion(onlineLibBaseDo.getAutoUpdateToMe(), onlineLibBaseDo.getProductVersion(), isVrc)) continue;
            this.getMaxCompareResult(localHdxDo, onlineLibBaseDo, result);
        }
        return result;
    }

    private boolean equalsAutoAndCheckVersion(String autoUpdateToMe, String productVersion, boolean isVrcVersion) {
        if (StringUtils.equalsIgnoreCase((CharSequence)autoUpdateToMe, (CharSequence)HdxAutoUpdate.AUTO_UPDATE_ALL.getLevel())) {
            return true;
        }
        return isVrcVersion ? VersionUtils.isVrcVersion(productVersion) : VersionUtils.isRclVersion(productVersion);
    }

    private List<CompareLibDto> getMaxAllCompareResult(CompareLibDto localHdxDo, List<CompareLibDto> onlineLibs) {
        ArrayList<CompareLibDto> result = new ArrayList<CompareLibDto>();
        for (CompareLibDto onlineLibBaseDo : onlineLibs) {
            this.getMaxCompareResult(localHdxDo, onlineLibBaseDo, result);
        }
        return result;
    }

    private List<CompareLibDto> getMaxCompareResult(CompareLibDto localHdxDo, List<CompareLibDto> onlineLibs) {
        if (CollectionUtils.isEmpty(onlineLibs)) {
            return new ArrayList<CompareLibDto>();
        }
        List<CompareLibDto> resultTemp = VersionUtils.isVrcVersion(localHdxDo.getProductVersion()) ? this.getMaxCompareResult(localHdxDo, onlineLibs, true) : (VersionUtils.isRclVersion(localHdxDo.getProductVersion()) ? this.getMaxCompareResult(localHdxDo, onlineLibs, false) : this.getMaxAllCompareResult(localHdxDo, onlineLibs));
        return resultTemp;
    }

    private void getMaxCompareResult(CompareLibDto localHdxDo, CompareLibDto onlineLib, List<CompareLibDto> result) {
        try {
            int libVersionCompareResult;
            int prodVersionCompareResult = HdxLibUpgradeUtils.compareProdVersionWithAutoUpgrade(localHdxDo, onlineLib);
            if (prodVersionCompareResult < 0) {
                result.add(onlineLib);
                return;
            }
            if (prodVersionCompareResult == 0 && StringUtils.equals((CharSequence)localHdxDo.getLibId(), (CharSequence)onlineLib.getLibId()) && (libVersionCompareResult = CommonLibUpgradeUtils.compareLibVersion(localHdxDo.getLibVersion(), onlineLib.getLibVersion())) < 0) {
                result.add(onlineLib);
            }
        }
        catch (VersionCompareException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "getMaxCompareResult VersionCompareException");
        }
    }
}

