/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.upgradefilter.OnlineFilter;
import com.huawei.support.icslite.business.upgradelibcommon.rule.CompareLibFacade;
import com.huawei.support.icslite.business.upgradelibcommon.util.VersionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

public class OnlineHwicsVersionCompareFilter
implements OnlineFilter {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(OnlineHwicsVersionCompareFilter.class);

    @Override
    public boolean canApply(CompareLibDto libBaseDo) {
        return "HWICS".equalsIgnoreCase(libBaseDo.getLibPlatFormType());
    }

    @Override
    public void doFilter(Map<String, List<CompareLibDto>> localLibs, Map<String, List<CompareLibDto>> onlineLibs) {
        if (!this.canApply(localLibs.values().iterator().next().get(0))) {
            return;
        }
        HashMap tempOnlineLibs = new HashMap();
        if (MapUtils.isEmpty(onlineLibs)) {
            CodeCCUtils.INSTANCE.errorLog(log, "onlineLibs map is empty");
            return;
        }
        localLibs.forEach((key, localHwicsLibList) -> localHwicsLibList.stream().filter(localUpgradeDocInfoDto -> onlineLibs.containsKey(key)).forEach(localUpgradeDocInfoDto -> tempOnlineLibs.put(key, this.handlerList((CompareLibDto)localUpgradeDocInfoDto, (List)onlineLibs.get(key)))));
        onlineLibs.clear();
        onlineLibs.putAll(tempOnlineLibs);
    }

    private List<CompareLibDto> handlerList(CompareLibDto localUpgradeDocInfoDto, List<CompareLibDto> upgradeDocInfoDtos) {
        int index;
        List<CompareLibDto> maxCompareResult = new ArrayList<CompareLibDto>();
        String localProductVersion = localUpgradeDocInfoDto.getProductVersion();
        if (VersionUtils.isVrcVersion(localProductVersion)) {
            maxCompareResult = upgradeDocInfoDtos.stream().filter(upgradeDocInfoDto -> VersionUtils.isVrcVersion(upgradeDocInfoDto.getProductVersion())).collect(Collectors.toList());
        }
        if (VersionUtils.isDotVersion(localProductVersion)) {
            maxCompareResult = upgradeDocInfoDtos.stream().filter(upgradeDocInfoDto -> VersionUtils.isDotVersion(upgradeDocInfoDto.getProductVersion())).collect(Collectors.toList());
        }
        if ((index = this.handlerHigherVersionList(localUpgradeDocInfoDto, maxCompareResult)) == 0) {
            return Collections.emptyList();
        }
        return maxCompareResult.subList(0, index);
    }

    private int handlerHigherVersionList(CompareLibDto localUpgradeDocInfoDto, List<CompareLibDto> maxCompareResult) {
        maxCompareResult.add(localUpgradeDocInfoDto);
        CompareLibFacade.getInstance().sortVersionAndDate(maxCompareResult);
        String maxVersionKey = this.getUpgradeKey(maxCompareResult.get(0));
        String localVersionKey = this.getUpgradeKey(localUpgradeDocInfoDto);
        if (localVersionKey.equals(maxVersionKey)) {
            return 0;
        }
        return maxCompareResult.indexOf(localUpgradeDocInfoDto);
    }

    private String getUpgradeKey(CompareLibDto upgradeDocInfoDto) {
        return upgradeDocInfoDto.getProductVersion() + upgradeDocInfoDto.getLibVersion() + upgradeDocInfoDto.getIssueDate();
    }
}

