/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.rule;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.exception.VersionCompareException;
import com.huawei.support.icslite.business.upgradelibcommon.util.CommonLibUpgradeUtils;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;

public class LibVersionComparator
implements Comparator<CompareLibDto>,
Serializable {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(LibVersionComparator.class);
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(CompareLibDto beforeDocInfoDto, CompareLibDto afterDocInfoDto) {
        try {
            return CommonLibUpgradeUtils.compareLibVersion(afterDocInfoDto.getLibVersion(), beforeDocInfoDto.getLibVersion());
        }
        catch (VersionCompareException e) {
            CodeCCUtils.INSTANCE.errorLog(log, String.format(Locale.ENGLISH, "Illegal libVersion format in compare, this LibId: %s, this libVersion: %s, that LibId: %s, that libVersion: %s", beforeDocInfoDto.getLibId(), beforeDocInfoDto.getLibVersion(), afterDocInfoDto.getLibId(), afterDocInfoDto.getLibVersion()));
            return 0;
        }
    }
}

