/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.rule;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.exception.VersionCompareException;
import com.huawei.support.icslite.business.upgradelibcommon.util.CommonLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.HdxLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.IcsLibUpgradeUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.VersionUtils;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;

public class ProdVersionComparator
implements Comparator<CompareLibDto>,
Serializable {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(ProdVersionComparator.class);
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(CompareLibDto beforeDocInfoDto, CompareLibDto afterDocInfoDto) {
        String beforeProdVer = beforeDocInfoDto.getProductVersion();
        String afterProdVer = afterDocInfoDto.getProductVersion();
        try {
            if (VersionUtils.isVrcVersion(beforeProdVer) && VersionUtils.isVrcVersion(afterProdVer)) {
                return CommonLibUpgradeUtils.compareVrcVersion(afterProdVer, beforeProdVer);
            }
            if (VersionUtils.isRclVersion(beforeProdVer) && VersionUtils.isRclVersion(afterProdVer)) {
                return HdxLibUpgradeUtils.compareRclVersion(afterProdVer, beforeProdVer);
            }
            if (VersionUtils.isDotVersion(beforeProdVer) && VersionUtils.isDotVersion(afterProdVer)) {
                return IcsLibUpgradeUtils.compareDotVersion(afterProdVer, beforeProdVer);
            }
        }
        catch (VersionCompareException e) {
            CodeCCUtils.INSTANCE.errorLog(log, String.format(Locale.ENGLISH, "ProductVersion illegal productName:%s,productionVersion:%s. after productionVersion:%s", beforeDocInfoDto.getProductName(), beforeDocInfoDto.getProductVersion(), afterDocInfoDto.getProductVersion()));
        }
        CodeCCUtils.INSTANCE.errorLog(log, String.format(Locale.ENGLISH, "ProductVersion not match,not in vrc/rcl/dot productName:%s,productionVersion:%s. after productionVersion:%s", beforeDocInfoDto.getProductName(), beforeDocInfoDto.getProductVersion(), afterDocInfoDto.getProductVersion()));
        return 0;
    }
}

