/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.upgradelibcommon.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.exception.VersionCompareException;
import com.huawei.support.icslite.business.upgradelibcommon.util.PatternUtils;
import com.huawei.support.icslite.business.upgradelibcommon.util.VersionUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CommonLibUpgradeUtils
extends PatternUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(CommonLibUpgradeUtils.class);

    private CommonLibUpgradeUtils() {
    }

    public static int compareVrcVersion(String version, String comparedVersion) throws VersionCompareException {
        return CommonLibUpgradeUtils.compareVrcVersion(version, comparedVersion, Integer.MIN_VALUE);
    }

    public static int compareVrcVersion(String version, String comparedVersion, int maxSupportVersionOffset) throws VersionCompareException {
        CommonLibUpgradeUtils.versionIllegal(version, comparedVersion, VersionUtils.isVrcVersion(version), VersionUtils.isVrcVersion(comparedVersion));
        String upperVersion = CommonLibUpgradeUtils.getRealVrcVersion(version);
        String upperComparedVersion = CommonLibUpgradeUtils.getRealVrcVersion(comparedVersion);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{upperVersion, upperComparedVersion})) {
            throw new VersionCompareException(String.format("version info is illegal: %s : %s", version, comparedVersion));
        }
        return CommonLibUpgradeUtils.commonCompareVersion(upperVersion, upperComparedVersion, maxSupportVersionOffset, 11);
    }

    public static void versionIllegal(String version, String comparedVersion, boolean isVersion, boolean isCompareVersion) throws VersionCompareException {
        if (!(!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{version, comparedVersion}) || isVersion && isCompareVersion)) {
            throw new VersionCompareException(String.format("version info is illegal: %s : %s", version, comparedVersion));
        }
    }

    public static String getPureVrcVersion(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            CodeCCUtils.INSTANCE.warnLog(log, "getVrcVersionNoExtraInfos version is blank ");
            return "";
        }
        String supplementVersion = CommonLibUpgradeUtils.getRealVrcVersion(version);
        return supplementVersion.substring(0, 11);
    }

    public static String getRealVrcVersion(String version) {
        if (!VersionUtils.isVrcVersion(version)) {
            return "";
        }
        String upperVersion = StringUtils.upperCase((String)version);
        if (upperVersion.length() == 8) {
            return upperVersion + "C00";
        }
        if (upperVersion.contains("&")) {
            return CommonLibUpgradeUtils.getOverlayVersion(upperVersion);
        }
        String cVersion = StringUtils.substring((String)upperVersion, (int)8, (int)11).trim();
        if (!VRC_C_VERSION_PATTERN.matcher(cVersion).find()) {
            return upperVersion.substring(0, 8) + "C00" + upperVersion.substring(8);
        }
        return upperVersion;
    }

    private static String getOverlayVersion(String version) {
        String substring = version.substring(8);
        String finalVersionC = "C00";
        for (int index = 3; index <= substring.length(); index += 4) {
            String versionStr = substring.substring(0, index);
            if (!VRC_C_VERSION_PATTERN.matcher(versionStr.trim()).find()) {
                return version.substring(0, 8) + finalVersionC + version.substring(8 + (index > 3 ? index - 4 : 0));
            }
            String compareCVersion = versionStr.substring(versionStr.length() - 3);
            finalVersionC = CommonLibUpgradeUtils.maxVersionC(finalVersionC, compareCVersion);
        }
        return version.substring(0, 8) + finalVersionC;
    }

    private static String maxVersionC(String versionC, String compareVersionC) {
        for (int index = 1; index < 3; ++index) {
            if (compareVersionC.charAt(index) - versionC.charAt(index) <= 0) continue;
            return compareVersionC;
        }
        return versionC;
    }

    public static int commonCompareVersion(String version, String comparedVersion, int maxSupportVersionOffset, int versionLength) throws VersionCompareException {
        for (int index = 0; index < versionLength; ++index) {
            if (maxSupportVersionOffset >= 0 && index <= maxSupportVersionOffset && version.charAt(index) != comparedVersion.charAt(index)) {
                String msg = String.format(Locale.ENGLISH, "higher version different; but only maxSupportVersionOffset is %s . current version: %s VS  %s", maxSupportVersionOffset, version, comparedVersion);
                CodeCCUtils.INSTANCE.errorLog(log, msg);
                throw new VersionCompareException(msg);
            }
            if (version.charAt(index) == comparedVersion.charAt(index)) continue;
            return version.charAt(index) - comparedVersion.charAt(index);
        }
        return 0;
    }

    public static List<String> getProductNames(Map<String, List<CompareLibDto>> localContentDo) {
        return localContentDo.values().stream().flatMap(list -> list.stream().map(CompareLibDto::getProductName)).distinct().collect(Collectors.toList());
    }

    public static int compareLibVersion(String libVersion, String comparedLibVersion) throws VersionCompareException {
        String beforeLibVersion = libVersion;
        String afterLibVersion = comparedLibVersion;
        if (StringUtils.isBlank((CharSequence)beforeLibVersion)) {
            beforeLibVersion = "Draft A";
        }
        if (StringUtils.isBlank((CharSequence)afterLibVersion)) {
            afterLibVersion = "Draft A";
        }
        if (!VersionUtils.isLibVersion(beforeLibVersion) || !VersionUtils.isLibVersion(afterLibVersion)) {
            throw new VersionCompareException(String.format(Locale.ENGLISH, "Lib version info is empty or illegal: %s : %s", beforeLibVersion, afterLibVersion));
        }
        beforeLibVersion = beforeLibVersion.trim();
        afterLibVersion = afterLibVersion.trim();
        if (LIB_VERSION_DRAFT_PATTERN.matcher(beforeLibVersion).find() && LIB_VERSION_DRAFT_PATTERN.matcher(afterLibVersion).find()) {
            return beforeLibVersion.charAt(6) - afterLibVersion.charAt(6);
        }
        if (LIB_VERSION_DIGITAL_PATTERN.matcher(beforeLibVersion).find() && LIB_VERSION_DIGITAL_PATTERN.matcher(afterLibVersion).find()) {
            return Math.subtractExact(Integer.parseInt(beforeLibVersion), Integer.parseInt(afterLibVersion));
        }
        return LIB_VERSION_DRAFT_PATTERN.matcher(beforeLibVersion).find() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
    }

    public static Optional<List<CompareLibDto>> getVersionListByType(String type, String seriesName, List<CompareLibDto> upgradeLibDtos) {
        List versionList = upgradeLibDtos.stream().filter(upgradeDocInfoDto -> CommonLibUpgradeUtils.isRightVersionByType(upgradeDocInfoDto.getProductVersion(), type)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(versionList)) {
            CodeCCUtils.INSTANCE.warnLog(log, String.format(Locale.ENGLISH, "prod version not match %s: %s .first version: %s", type, seriesName, upgradeLibDtos.get(0).getProductVersion()));
            return Optional.empty();
        }
        return Optional.of(versionList);
    }

    private static boolean isRightVersionByType(String prodVersion, String type) {
        switch (type) {
            case "VRC": {
                return VersionUtils.isVrcVersion(prodVersion);
            }
            case "RCL": {
                return VersionUtils.isRclVersion(prodVersion);
            }
            case "DOT": {
                return VersionUtils.isDotVersion(prodVersion);
            }
        }
        CodeCCUtils.INSTANCE.errorLog(log, "IsRightVersionByType input type has error");
        return false;
    }
}

